/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.naming.ejb;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.ejb.EJBHome;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBHomeLocator;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.IdentityEJBClientContextSelector;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.NamedEJBClientContextIdentifier;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.naming.ejb.EjbJndiIdentifier;
import org.jboss.ejb.client.naming.ejb.EjbJndiNameParser;
import org.jboss.ejb.client.naming.ejb.SecurityActions;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.jboss.logging.Logger;

class EjbNamingContext
implements Context {
    private static final Logger log = Logger.getLogger((String)"org.jboss.ejb.client.naming");
    private static final String SCOPED_EJB_CLIENT_CONTEXT_NAME_PREFIX = "EJBClientContext$";
    private static final AtomicLong nextEJBClientContextNumber = new AtomicLong();
    private static final String JNDI_PROPERTY_CREATE_SCOPED_EJB_CLIENT_CONTEXT = "org.jboss.ejb.client.scoped.context";
    private static final String ENV_PROPERTY_SCOPED_EJB_CLIENT_CONTEXT_IDENTIFIER = "org.jboss.ejb.client.scoped.context.identifier";
    private final Hashtable environment;
    private final boolean root;
    private final String application;
    private final String module;
    private final String distinct;
    private final EJBClientContextIdentifier ejbClientContextIdentifier;

    protected EjbNamingContext(String application, String module, String distinct, Hashtable<?, ?> env, EJBClientContextIdentifier ejbClientContextIdentifier) {
        this.application = application;
        this.module = module;
        this.distinct = distinct;
        this.environment = env == null ? new Hashtable() : env;
        this.ejbClientContextIdentifier = ejbClientContextIdentifier;
        this.root = false;
    }

    protected EjbNamingContext(Hashtable<?, ?> env) {
        this.application = null;
        this.module = null;
        this.distinct = null;
        this.environment = env == null ? new Hashtable() : env;
        this.root = true;
        this.ejbClientContextIdentifier = this.setupScopedEjbClientContextIfNeeded();
    }

    private synchronized EJBClientContextIdentifier setupScopedEjbClientContextIfNeeded() {
        EJBClientContextIdentifier alreadyCreatedContextIdentifier = (EJBClientContextIdentifier)this.environment.get(ENV_PROPERTY_SCOPED_EJB_CLIENT_CONTEXT_IDENTIFIER);
        if (alreadyCreatedContextIdentifier != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Skipping creation of scoped EJB client context for EJB naming context " + this + " with environment " + this.environment + " since one has already been created with identifier: " + alreadyCreatedContextIdentifier));
            }
            return alreadyCreatedContextIdentifier;
        }
        if (!this.requiresScopedEJBClientContext(this.environment)) {
            return null;
        }
        ContextSelector<EJBClientContext> currentSelector = EJBClientContext.getSelector();
        if (!(currentSelector instanceof IdentityEJBClientContextSelector)) {
            log.info((Object)("Cannot create a scoped EJB client context for JNDI naming context " + this + " since the current " + "EJB client context selector can't handle scoped contexts"));
            return null;
        }
        EJBClientContext ejbClientContext = this.createIdentifiableEjbClientContext(this.environment);
        String ejbClientContextName = SCOPED_EJB_CLIENT_CONTEXT_NAME_PREFIX + nextEJBClientContextNumber.addAndGet(1L);
        NamedEJBClientContextIdentifier contextIdentifier = new NamedEJBClientContextIdentifier(ejbClientContextName);
        ((IdentityEJBClientContextSelector)currentSelector).registerContext(contextIdentifier, ejbClientContext);
        try {
            this.addToEnvironment(ENV_PROPERTY_SCOPED_EJB_CLIENT_CONTEXT_IDENTIFIER, contextIdentifier);
        }
        catch (NamingException ne) {
            throw Logs.MAIN.failedToCreateScopedEjbClientContext(ne);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Created scoped EJB client context with identifier: " + contextIdentifier + " for EJB naming context " + this + " with environment " + this.environment));
        }
        return contextIdentifier;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public Object lookup(String name) throws NamingException {
        EjbJndiIdentifier identifier;
        if (this.root) {
            if (EjbJndiNameParser.isEJBClientContextJNDIName(name)) {
                try {
                    return EJBClientContext.require(this.ejbClientContextIdentifier);
                }
                catch (IllegalStateException ise) {
                    throw new NameNotFoundException(name + " not found within EJB naming context " + this);
                }
            }
            identifier = EjbJndiNameParser.parse(name);
        } else {
            identifier = this.application == null || this.application.isEmpty() ? EjbJndiNameParser.parse("ejb:" + name) : (this.module == null || this.module.isEmpty() ? EjbJndiNameParser.parse(this.application, name) : (this.distinct == null || this.distinct.isEmpty() ? EjbJndiNameParser.parse(this.application, this.module, name) : EjbJndiNameParser.parse(this.application, this.module, this.distinct, name)));
        }
        if (identifier.getEjbName() == null) {
            return this.createEjbContext(identifier, this.environment);
        }
        return this.createEjbProxy(identifier);
    }

    private Object createEjbContext(EjbJndiIdentifier identifier, Hashtable<?, ?> env) {
        return new EjbNamingContext(identifier.getApplication(), identifier.getModule(), identifier.getDistinctName(), env, this.ejbClientContextIdentifier);
    }

    protected Object createEjbProxy(EjbJndiIdentifier identifier) throws NamingException {
        Class<?> viewClass;
        try {
            viewClass = Class.forName(identifier.getViewName(), false, SecurityActions.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            NamingException naming = Logs.MAIN.couldNotLoadProxyClass(identifier.getViewName());
            naming.setRootCause(e);
            throw naming;
        }
        try {
            return EJBHome.class.isAssignableFrom(viewClass) ? this.doCreateHomeProxy(viewClass.asSubclass(EJBHome.class), identifier) : this.doCreateProxy(viewClass, identifier);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Failed to create proxy");
            ne.initCause(e);
            throw ne;
        }
    }

    private <T extends EJBHome> T doCreateHomeProxy(Class<T> viewClass, EjbJndiIdentifier identifier) throws Exception {
        boolean stateful;
        Map<String, String> options = identifier.getOptions();
        boolean bl = stateful = options.containsKey("stateful") && !"false".equalsIgnoreCase(options.get("stateful"));
        if (stateful) {
            log.warnf("Ignoring 'stateful' option on lookup of home %s", viewClass);
        }
        EJBHomeLocator<T> locator = new EJBHomeLocator<T>(viewClass, identifier.getApplication(), identifier.getModule(), identifier.getEjbName(), identifier.getDistinctName());
        return (T)((EJBHome)EJBClient.createProxy(locator, this.ejbClientContextIdentifier));
    }

    private <T> T doCreateProxy(Class<T> viewClass, EjbJndiIdentifier identifier) throws Exception {
        Map<String, String> options = identifier.getOptions();
        boolean stateful = options.containsKey("stateful") && !"false".equalsIgnoreCase(options.get("stateful"));
        EJBLocator locator = stateful ? EJBClient.createSession(this.ejbClientContextIdentifier, viewClass, identifier.getApplication(), identifier.getModule(), identifier.getEjbName(), identifier.getDistinctName()) : new StatelessEJBLocator<T>(viewClass, identifier.getApplication(), identifier.getModule(), identifier.getEjbName(), identifier.getDistinctName());
        return EJBClient.createProxy(locator, this.ejbClientContextIdentifier);
    }

    private boolean requiresScopedEJBClientContext(Hashtable jndiProps) {
        Object createScopedContext = jndiProps.get(JNDI_PROPERTY_CREATE_SCOPED_EJB_CLIENT_CONTEXT);
        if (createScopedContext == null) {
            return false;
        }
        if (createScopedContext instanceof String) {
            return Boolean.parseBoolean((String)createScopedContext);
        }
        if (createScopedContext instanceof Boolean) {
            return (Boolean)createScopedContext;
        }
        return false;
    }

    private EJBClientContext createIdentifiableEjbClientContext(Hashtable jndiProps) {
        Properties ejbClientContextConfigProps = new Properties();
        ejbClientContextConfigProps.putAll((Map<?, ?>)jndiProps);
        PropertiesBasedEJBClientConfiguration ejbClientConfiguration = new PropertiesBasedEJBClientConfiguration(ejbClientContextConfigProps);
        ConfigBasedEJBClientContextSelector configBasedEJBClientContextSelector = new ConfigBasedEJBClientContextSelector(ejbClientConfiguration, SecurityActions.getContextClassLoader());
        return configBasedEJBClientContextSelector.getCurrent();
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperation();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw Logs.MAIN.unsupportedNamingOperationForReadOnlyContext();
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParser(){

            @Override
            public Name parse(String name) throws NamingException {
                return new CompositeName(name);
            }
        };
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new NameParser(){

            @Override
            public Name parse(String name) throws NamingException {
                return new CompositeName(name);
            }
        };
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        Object existing = this.environment.get(propName);
        this.environment.put(propName, propVal);
        return existing;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        if (this.ejbClientContextIdentifier != null) {
            ContextSelector<EJBClientContext> currentSelector = EJBClientContext.getSelector();
            if (!(currentSelector instanceof IdentityEJBClientContextSelector)) {
                log.debug((Object)("Cannot unregister a scoped EJB client context for JNDI naming context " + this + " since the current " + "EJB client context selector can't handle scoped contexts"));
                return;
            }
            EJBClientContext previouslyRegisteredContext = ((IdentityEJBClientContextSelector)currentSelector).unRegisterContext(this.ejbClientContextIdentifier);
            if (previouslyRegisteredContext != null) {
                try {
                    previouslyRegisteredContext.close();
                }
                catch (IOException ioe) {
                    NamingException ne = new NamingException("Encountered an exception while closing the EJB naming context");
                    ne.setRootCause(ioe);
                    throw ne;
                }
            }
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        if (this.application == null) {
            return "ejb:";
        }
        if (this.module == null) {
            return "ejb:" + this.application;
        }
        if (this.distinct == null) {
            return "ejb:" + this.application + "/" + this.module;
        }
        return "ejb:" + this.application + "/" + this.module + "/" + this.distinct;
    }
}

