/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;

final class SecurityActions {
    private static final PrivilegedAction<ClassLoader> GET_CLASS_LOADER = new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };

    static String getSystemProperty(final String key) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        });
    }

    static void setSystemProperty(final String key, final String value) {
        if (System.getSecurityManager() == null) {
            System.setProperty(key, value);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    System.setProperty(key, value);
                    return null;
                }
            });
        }
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GET_CLASS_LOADER);
    }

    static <S> ServiceLoader<S> loadService(final Class<S> type, final ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return ServiceLoader.load(type, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<S>>(){

            @Override
            public ServiceLoader<S> run() {
                return ServiceLoader.load(type, classLoader);
            }
        });
    }

    static void addShutdownHook(final Thread shutdownHook) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                    return null;
                }
            });
        }
    }

    static Boolean removeShutdownHook(final Thread shutdownHook) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
        });
    }

    private SecurityActions() {
    }
}

