/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.ConstantContextSelector;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.DaemonThreadFactory;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContextInitializer;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBClientPropertiesLoader;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.RandomDeploymentNodeSelector;
import org.jboss.ejb.client.SecurityActions;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.jboss.ejb.client.remoting.ReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;

public final class EJBClientContext
extends Attachable {
    private static final Logger logger = Logger.getLogger(EJBClientContext.class);
    private static final RuntimePermission SET_SELECTOR_PERMISSION = new RuntimePermission("setEJBClientContextSelector");
    private static final RuntimePermission ADD_INTERCEPTOR_PERMISSION = new RuntimePermission("registerInterceptor");
    private static final RuntimePermission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createEJBClientContext");
    private static final AtomicReferenceFieldUpdater<EJBClientContext, EJBClientInterceptor.Registration[]> registrationsUpdater = AtomicReferenceFieldUpdater.newUpdater(EJBClientContext.class, EJBClientInterceptor.Registration[].class, "registrations");
    private static final EJBClientInterceptor.Registration[] NO_INTERCEPTORS = new EJBClientInterceptor.Registration[0];
    private static volatile ContextSelector<EJBClientContext> SELECTOR;
    private static volatile boolean SELECTOR_LOCKED;
    private final Map<EJBReceiver, ReceiverAssociation> ejbReceiverAssociations = new IdentityHashMap<EJBReceiver, ReceiverAssociation>();
    private final Map<EJBReceiverContext, EJBReceiverContextCloseHandler> receiverContextCloseHandlers = Collections.synchronizedMap(new IdentityHashMap());
    private volatile EJBClientInterceptor.Registration[] registrations = NO_INTERCEPTORS;
    private final Map<String, ClusterContext> clusterContexts = Collections.synchronizedMap(new HashMap());
    private final EJBClientConfiguration ejbClientConfiguration;
    private final ClusterFormationNotifier clusterFormationNotifier = new ClusterFormationNotifier();
    private final DeploymentNodeSelector deploymentNodeSelector = new RandomDeploymentNodeSelector();
    private final ExecutorService reconnectionExecutorService = Executors.newCachedThreadPool(new DaemonThreadFactory("ejb-client-remote-connection-reconnect"));
    private final List<ReconnectHandler> reconnectHandlers = new ArrayList<ReconnectHandler>();

    private EJBClientContext(EJBClientConfiguration ejbClientConfiguration) {
        this.ejbClientConfiguration = ejbClientConfiguration;
    }

    private void init(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = EJBClientContext.class.getClassLoader();
        }
        for (EJBClientContextInitializer contextInitializer : SecurityActions.loadService(EJBClientContextInitializer.class, classLoader)) {
            try {
                contextInitializer.initialize(this);
            }
            catch (Throwable ignored) {
                logger.debug((Object)("EJB client context initializer " + contextInitializer + " failed to initialize context " + this), ignored);
            }
        }
    }

    public static EJBClientContext create() {
        return EJBClientContext.create(null, EJBClientContext.class.getClassLoader());
    }

    public static EJBClientContext create(ClassLoader classLoader) {
        return EJBClientContext.create(null, classLoader);
    }

    public static EJBClientContext create(EJBClientConfiguration ejbClientConfiguration) {
        return EJBClientContext.create(ejbClientConfiguration, EJBClientContext.class.getClassLoader());
    }

    public static EJBClientContext create(EJBClientConfiguration ejbClientConfiguration, ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        EJBClientContext context = new EJBClientContext(ejbClientConfiguration);
        context.init(classLoader);
        return context;
    }

    public static ContextSelector<EJBClientContext> setSelector(ContextSelector<EJBClientContext> newSelector) {
        if (newSelector == null) {
            throw new IllegalArgumentException("EJB client context selector cannot be set to null");
        }
        if (SELECTOR_LOCKED) {
            throw new SecurityException("EJB client context selector may not be changed");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_SELECTOR_PERMISSION);
        }
        ContextSelector<EJBClientContext> oldSelector = SELECTOR;
        SELECTOR = newSelector;
        return oldSelector;
    }

    public static ContextSelector<EJBClientContext> setConstantContext(EJBClientContext context) {
        return EJBClientContext.setSelector(new ConstantContextSelector<EJBClientContext>(context));
    }

    public static void lockSelector() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_SELECTOR_PERMISSION);
        }
        SELECTOR_LOCKED = true;
    }

    public static EJBClientContext getCurrent() {
        return SELECTOR.getCurrent();
    }

    public static EJBClientContext requireCurrent() throws IllegalStateException {
        EJBClientContext clientContext = EJBClientContext.getCurrent();
        if (clientContext == null) {
            throw new IllegalStateException("No EJB client context is available");
        }
        return clientContext;
    }

    public boolean registerEJBReceiver(EJBReceiver receiver) {
        return this.registerEJBReceiver(receiver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean registerEJBReceiver(EJBReceiver receiver, EJBReceiverContextCloseHandler receiverContextCloseHandler) {
        EJBReceiverContext ejbReceiverContext;
        if (receiver == null) {
            throw new IllegalArgumentException("Cannot register a null receiver");
        }
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            if (this.ejbReceiverAssociations.containsKey(receiver)) {
                logger.debug((Object)("Skipping registration of receiver " + receiver + " since the same instance already exists in this client context " + this));
                return false;
            }
            EJBReceiver existingReceiverForNode = this.getNodeEJBReceiver(receiver.getNodeName(), false);
            if (existingReceiverForNode != null) {
                logger.debug((Object)("Skipping registration of receiver " + receiver + " since an EJB receiver already exists for " + "node name " + receiver.getNodeName() + " in client context " + this));
                return false;
            }
            ejbReceiverContext = new EJBReceiverContext(receiver, this);
            ReceiverAssociation association = new ReceiverAssociation(ejbReceiverContext);
            this.ejbReceiverAssociations.put(receiver, association);
            if (receiverContextCloseHandler != null) {
                this.receiverContextCloseHandlers.put(ejbReceiverContext, receiverContextCloseHandler);
            }
        }
        receiver.associate(ejbReceiverContext);
        map = this.ejbReceiverAssociations;
        synchronized (map) {
            association.associated = true;
            return this.ejbReceiverAssociations.get(receiver) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEJBReceiver(EJBReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("Receiver cannot be null");
        }
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            EJBReceiverContext receiverContext;
            EJBReceiverContextCloseHandler receiverContextCloseHandler;
            ReceiverAssociation association = this.ejbReceiverAssociations.remove(receiver);
            if (association != null && (receiverContextCloseHandler = this.receiverContextCloseHandlers.remove(receiverContext = association.context)) != null) {
                receiverContextCloseHandler.receiverContextClosed(receiverContext);
            }
        }
    }

    public void registerConnection(Connection connection) {
        this.registerEJBReceiver(new RemotingConnectionEJBReceiver(connection));
    }

    public EJBClientInterceptor.Registration registerInterceptor(int priority, EJBClientInterceptor clientInterceptor) throws IllegalArgumentException {
        Object[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        if (clientInterceptor == null) {
            throw new IllegalArgumentException("clientInterceptor is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_INTERCEPTOR_PERMISSION);
        }
        EJBClientInterceptor.Registration newRegistration = new EJBClientInterceptor.Registration(this, clientInterceptor, priority);
        do {
            for (EJBClientInterceptor.Registration oldRegistration : oldRegistrations = this.registrations) {
                if (oldRegistration.getInterceptor() != clientInterceptor) continue;
                if (oldRegistration.compareTo(newRegistration) == 0) {
                    return oldRegistration;
                }
                throw new IllegalArgumentException("Interceptor '" + clientInterceptor + "' is already registered");
            }
            int length = oldRegistrations.length;
            newRegistrations = Arrays.copyOf(oldRegistrations, length + 1);
            newRegistrations[length] = newRegistration;
            Arrays.sort(newRegistrations);
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, (EJBClientInterceptor.Registration[])newRegistrations));
        return newRegistration;
    }

    public EJBClientConfiguration getEJBClientConfiguration() {
        return this.ejbClientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReconnectHandler(ReconnectHandler reconnectHandler) {
        if (reconnectHandler == null) {
            throw new IllegalArgumentException("Reconnect handler cannot be null");
        }
        List<ReconnectHandler> list = this.reconnectHandlers;
        synchronized (list) {
            this.reconnectHandlers.add(reconnectHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterReconnectHandler(ReconnectHandler reconnectHandler) {
        List<ReconnectHandler> list = this.reconnectHandlers;
        synchronized (list) {
            this.reconnectHandlers.remove(reconnectHandler);
        }
    }

    void removeInterceptor(EJBClientInterceptor.Registration registration) {
        EJBClientInterceptor.Registration[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        do {
            block5: {
                int newLength;
                int length;
                block4: {
                    oldRegistrations = this.registrations;
                    newRegistrations = null;
                    length = oldRegistrations.length;
                    newLength = length - 1;
                    if (length != 1) break block4;
                    if (oldRegistrations[0].getInterceptor() != registration) break block5;
                    newRegistrations = NO_INTERCEPTORS;
                    break block5;
                }
                for (int i = 0; i < length; ++i) {
                    if (oldRegistrations[i].getInterceptor() != registration) continue;
                    if (i == newLength) {
                        newRegistrations = Arrays.copyOf(oldRegistrations, newLength);
                        break;
                    }
                    newRegistrations = new EJBClientInterceptor.Registration[newLength];
                    if (i > 0) {
                        System.arraycopy(oldRegistrations, 0, newRegistrations, 0, i);
                    }
                    System.arraycopy(oldRegistrations, i + 1, newRegistrations, i, newLength - i);
                    break;
                }
            }
            if (newRegistrations != null) continue;
            return;
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, newRegistrations));
    }

    Collection<EJBReceiver> getEJBReceivers(String appName, String moduleName, String distinctName) {
        return this.getEJBReceivers(appName, moduleName, distinctName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<EJBReceiver> getEJBReceivers(String appName, String moduleName, String distinctName, boolean attemptReconnect) {
        HashSet<EJBReceiver> eligibleEJBReceivers = new HashSet<EJBReceiver>();
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            for (Map.Entry<EJBReceiver, ReceiverAssociation> entry : this.ejbReceiverAssociations.entrySet()) {
                EJBReceiver ejbReceiver;
                if (!entry.getValue().associated || !(ejbReceiver = entry.getKey()).acceptsModule(appName, moduleName, distinctName)) continue;
                eligibleEJBReceivers.add(ejbReceiver);
            }
        }
        if (eligibleEJBReceivers.isEmpty() && attemptReconnect) {
            this.attemptReconnections();
            eligibleEJBReceivers.addAll(this.getEJBReceivers(appName, moduleName, distinctName, false));
        }
        return eligibleEJBReceivers;
    }

    EJBReceiver getEJBReceiver(String appName, String moduleName, String distinctName) {
        return this.getEJBReceiver(null, appName, moduleName, distinctName);
    }

    EJBReceiver requireEJBReceiver(String appName, String moduleName, String distinctName) throws IllegalStateException {
        EJBReceiver ejbReceiver = this.getEJBReceiver(appName, moduleName, distinctName);
        if (ejbReceiver == null) {
            throw new IllegalStateException("No EJB receiver available for handling [appName:" + appName + ",modulename:" + moduleName + ",distinctname:" + distinctName + "] combination");
        }
        return ejbReceiver;
    }

    EJBReceiver getEJBReceiver(EJBClientInvocationContext invocationContext, String appName, String moduleName, String distinctName) {
        Iterator<EJBReceiver> iterator = this.getEJBReceivers(appName, moduleName, distinctName).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Set<String> excludedNodes = invocationContext == null ? Collections.EMPTY_SET : invocationContext.getExcludedNodes();
        HashMap<String, EJBReceiver> eligibleReceivers = new HashMap<String, EJBReceiver>();
        while (iterator.hasNext()) {
            EJBReceiver receiver = iterator.next();
            String nodeName = receiver.getNodeName();
            if (excludedNodes.contains(nodeName)) {
                logger.debug((Object)(nodeName + " is excluded from handling appname=" + appName + ",modulename=" + moduleName + ",distinctname=" + distinctName + " in invocation context " + invocationContext));
                continue;
            }
            eligibleReceivers.put(receiver.getNodeName(), receiver);
        }
        if (eligibleReceivers.isEmpty()) {
            return null;
        }
        String selectedNode = this.deploymentNodeSelector.selectNode(eligibleReceivers.keySet().toArray(new String[eligibleReceivers.size()]), appName, moduleName, distinctName);
        logger.debug((Object)(this.deploymentNodeSelector + " deployment node selector selected " + selectedNode + " node for appname=" + appName + ",modulename=" + moduleName + ",distinctname=" + distinctName));
        if (selectedNode == null || selectedNode.trim().isEmpty() || !eligibleReceivers.containsKey(selectedNode)) {
            logger.debug((Object)("Selected node " + selectedNode + " doesn't belong to eligible receivers. Continuing with a random eligible receiver"));
            return iterator.next();
        }
        return (EJBReceiver)eligibleReceivers.get(selectedNode);
    }

    EJBReceiver requireEJBReceiver(EJBClientInvocationContext clientInvocationContext, String appName, String moduleName, String distinctName) throws IllegalStateException {
        EJBReceiver ejbReceiver = this.getEJBReceiver(clientInvocationContext, appName, moduleName, distinctName);
        if (ejbReceiver == null) {
            throw new IllegalStateException("No EJB receiver available for handling [appName:" + appName + ",modulename:" + moduleName + ",distinctname:" + distinctName + "] combination for invocation context " + clientInvocationContext);
        }
        return ejbReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBReceiverContext requireEJBReceiverContext(EJBReceiver receiver) throws IllegalStateException {
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            ReceiverAssociation association = this.ejbReceiverAssociations.get(receiver);
            if (association == null) {
                throw new IllegalStateException(receiver + " has not been associated with " + this);
            }
            return association.context;
        }
    }

    EJBReceiver requireNodeEJBReceiver(String nodeName) {
        EJBReceiver receiver = this.getNodeEJBReceiver(nodeName);
        if (receiver != null) {
            return receiver;
        }
        throw new IllegalStateException("No EJBReceiver available for node name " + nodeName);
    }

    EJBReceiver getNodeEJBReceiver(String nodeName) {
        return this.getNodeEJBReceiver(nodeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBReceiver getNodeEJBReceiver(String nodeName, boolean attemptReconnect) {
        if (nodeName == null) {
            throw new IllegalArgumentException("Node name cannot be null");
        }
        Map<EJBReceiver, ReceiverAssociation> map = this.ejbReceiverAssociations;
        synchronized (map) {
            for (Map.Entry<EJBReceiver, ReceiverAssociation> entry : this.ejbReceiverAssociations.entrySet()) {
                EJBReceiver ejbReceiver;
                if (!entry.getValue().associated || !nodeName.equals((ejbReceiver = entry.getKey()).getNodeName())) continue;
                return ejbReceiver;
            }
        }
        if (attemptReconnect) {
            this.attemptReconnections();
            return this.getNodeEJBReceiver(nodeName, false);
        }
        return null;
    }

    EJBReceiverContext requireNodeEJBReceiverContext(String nodeName) {
        EJBReceiver ejbReceiver = this.requireNodeEJBReceiver(nodeName);
        return this.requireEJBReceiverContext(ejbReceiver);
    }

    EJBReceiverContext getNodeEJBReceiverContext(String nodeName) {
        EJBReceiver ejbReceiver = this.getNodeEJBReceiver(nodeName);
        return ejbReceiver == null ? null : this.requireEJBReceiverContext(ejbReceiver);
    }

    boolean clusterContains(String clusterName, String nodeName) {
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            return false;
        }
        return clusterContext.isNodeAvailable(nodeName);
    }

    EJBReceiverContext getClusterEJBReceiverContext(String clusterName) throws IllegalArgumentException {
        return this.getClusterEJBReceiverContext(null, clusterName);
    }

    EJBReceiverContext getClusterEJBReceiverContext(EJBClientInvocationContext invocationContext, String clusterName) throws IllegalArgumentException {
        return this.getClusterEJBReceiverContext(invocationContext, clusterName, true);
    }

    private EJBReceiverContext getClusterEJBReceiverContext(EJBClientInvocationContext invocationContext, String clusterName, boolean attemptReconnect) throws IllegalArgumentException {
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            return null;
        }
        EJBReceiverContext ejbReceiverContext = clusterContext.getEJBReceiverContext(invocationContext);
        if (ejbReceiverContext == null && attemptReconnect) {
            this.attemptReconnections();
            return this.getClusterEJBReceiverContext(invocationContext, clusterName, false);
        }
        return ejbReceiverContext;
    }

    EJBReceiverContext requireClusterEJBReceiverContext(String clusterName) throws IllegalArgumentException {
        return this.requireClusterEJBReceiverContext(null, clusterName);
    }

    EJBReceiverContext requireClusterEJBReceiverContext(EJBClientInvocationContext invocationContext, String clusterName) throws IllegalArgumentException {
        EJBReceiverContext ejbReceiverContext;
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            logger.debug((Object)("Waiting for cluster topology information to be available for cluster named " + clusterName));
            this.waitForClusterTopology(clusterName);
            clusterContext = this.clusterContexts.get(clusterName);
            if (clusterContext == null) {
                throw new IllegalArgumentException("No cluster context (and as a result EJB receiver context) available for cluster named " + clusterName);
            }
        }
        if ((ejbReceiverContext = this.getClusterEJBReceiverContext(invocationContext, clusterName)) == null) {
            throw new IllegalStateException("No EJB receiver contexts available in cluster " + clusterName);
        }
        return ejbReceiverContext;
    }

    EJBClientInterceptor[] getInterceptorChain() {
        EJBClientInterceptor.Registration[] registrations = this.registrations;
        EJBClientInterceptor[] interceptors = new EJBClientInterceptor[registrations.length];
        for (int i = 0; i < registrations.length; ++i) {
            interceptors[i] = registrations[i].getInterceptor();
        }
        return interceptors;
    }

    public synchronized ClusterContext getOrCreateClusterContext(String clusterName) {
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            clusterContext = new ClusterContext(clusterName, this, this.ejbClientConfiguration);
            clusterContext.registerListener(this.clusterFormationNotifier);
            this.clusterContexts.put(clusterName, clusterContext);
        }
        return clusterContext;
    }

    public synchronized ClusterContext getClusterContext(String clusterName) {
        return this.clusterContexts.get(clusterName);
    }

    public synchronized void removeCluster(String clusterName) {
        ClusterContext clusterContext = this.clusterContexts.remove(clusterName);
        if (clusterContext == null) {
            return;
        }
        try {
            clusterContext.close();
        }
        catch (Throwable t) {
            logger.debug((Object)("Ignoring an error that occured while closing a cluster context for cluster named " + clusterName), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForClusterTopology(String clusterName) {
        CountDownLatch clusterFormationLatch = new CountDownLatch(1);
        this.clusterFormationNotifier.registerForClusterFormation(clusterName, clusterFormationLatch);
        try {
            boolean receivedClusterTopology = clusterFormationLatch.await(5L, TimeUnit.SECONDS);
            if (receivedClusterTopology) {
                logger.debug((Object)("Received the cluster topology for cluster named " + clusterName + " during the wait time"));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.clusterFormationNotifier.unregisterFromClusterNotification(clusterName, clusterFormationLatch);
        }
    }

    private synchronized void attemptReconnections() {
        if (this.reconnectHandlers.isEmpty()) {
            return;
        }
        CountDownLatch reconnectTasksCompletionNotifierLatch = new CountDownLatch(this.reconnectHandlers.size());
        for (ReconnectHandler reconnectHandler : this.reconnectHandlers) {
            this.reconnectionExecutorService.submit(new ReconnectAttempt(reconnectHandler, reconnectTasksCompletionNotifierLatch));
        }
        try {
            reconnectTasksCompletionNotifierLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        Properties ejbClientProperties = EJBClientPropertiesLoader.loadEJBClientProperties();
        if (ejbClientProperties == null) {
            SELECTOR = new ConfigBasedEJBClientContextSelector(null);
        } else {
            PropertiesBasedEJBClientConfiguration clientConfiguration = new PropertiesBasedEJBClientConfiguration(ejbClientProperties);
            SELECTOR = new ConfigBasedEJBClientContextSelector(clientConfiguration);
        }
    }

    private class ReconnectAttempt
    implements Runnable {
        private final ReconnectHandler reconnectHandler;
        private final CountDownLatch taskCompletionNotifierLatch;

        ReconnectAttempt(ReconnectHandler reconnectHandler, CountDownLatch taskCompletionNotifierLatch) {
            this.reconnectHandler = reconnectHandler;
            this.taskCompletionNotifierLatch = taskCompletionNotifierLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.reconnectHandler.reconnect();
            }
            catch (Exception e) {
                logger.debug((Object)("Exception trying to re-establish a connection from EJB client context " + EJBClientContext.this), (Throwable)e);
            }
            finally {
                this.taskCompletionNotifierLatch.countDown();
            }
        }
    }

    private final class ClusterFormationNotifier
    implements ClusterContext.ClusterContextListener {
        private final Map<String, List<CountDownLatch>> clusterFormationListeners = new HashMap<String, List<CountDownLatch>>();

        private ClusterFormationNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerForClusterFormation(String clusterName, CountDownLatch latch) {
            Map<String, List<CountDownLatch>> map = this.clusterFormationListeners;
            synchronized (map) {
                List<CountDownLatch> listeners = this.clusterFormationListeners.get(clusterName);
                if (listeners == null) {
                    listeners = new ArrayList<CountDownLatch>();
                    this.clusterFormationListeners.put(clusterName, listeners);
                }
                listeners.add(latch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyClusterFormation(String clusterName) {
            List<CountDownLatch> listeners;
            Map<String, List<CountDownLatch>> map = this.clusterFormationListeners;
            synchronized (map) {
                listeners = this.clusterFormationListeners.remove(clusterName);
            }
            if (listeners == null) {
                return;
            }
            for (CountDownLatch latch : listeners) {
                latch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregisterFromClusterNotification(String clusterName, CountDownLatch latch) {
            Map<String, List<CountDownLatch>> map = this.clusterFormationListeners;
            synchronized (map) {
                List<CountDownLatch> listeners = this.clusterFormationListeners.get(clusterName);
                if (listeners == null) {
                    return;
                }
                listeners.remove(latch);
            }
        }

        @Override
        public void clusterNodesAdded(String clusterName, ClusterNodeManager ... nodes) {
            this.notifyClusterFormation(clusterName);
        }
    }

    private static final class ReceiverAssociation {
        final EJBReceiverContext context;
        boolean associated = false;

        private ReceiverAssociation(EJBReceiverContext context) {
            this.context = context;
        }
    }

    static interface EJBReceiverContextCloseHandler {
        public void receiverContextClosed(EJBReceiverContext var1);
    }
}

