/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.remoting.MaxAttemptsReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingCleanupHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;

class EJBClientContextConnectionReconnectHandler
extends MaxAttemptsReconnectHandler {
    private final EJBClientContext ejbClientContext;
    private final RemotingCleanupHandler remotingCleanupHandler = new RemotingCleanupHandler();
    private EJBReceiver ejbReceiver = null;

    EJBClientContextConnectionReconnectHandler(EJBClientContext clientContext, Endpoint endpoint, String protocol, String host, int port, EJBClientConfiguration.CommonConnectionCreationConfiguration connectionConfiguration, int maxReconnectAttempts) {
        super(endpoint, protocol, host, port, connectionConfiguration, maxReconnectAttempts);
        this.ejbClientContext = clientContext;
        this.ejbClientContext.registerEJBClientContextListener(this.remotingCleanupHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws IOException {
        Connection connection = null;
        try {
            connection = this.tryConnect();
            if (connection == null) {
                return;
            }
            this.remotingCleanupHandler.addConnection(connection);
            if (this.ejbReceiver != null) {
                this.ejbClientContext.unregisterEJBReceiver(this.ejbReceiver);
                this.ejbReceiver = null;
            }
            this.ejbReceiver = new RemotingConnectionEJBReceiver(connection, this, this.connectionConfiguration.getChannelCreationOptions(), this.protocol);
            this.ejbClientContext.registerEJBReceiver(this.ejbReceiver);
        }
        finally {
            if (connection != null || !this.hasMoreAttempts()) {
                this.ejbClientContext.unregisterReconnectHandler(this);
            }
        }
    }
}

