/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.ejb.client.ClusterNodeManager;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DaemonThreadFactory;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.RandomClusterNodeSelector;
import org.jboss.logging.Logger;

@Deprecated
public final class ClusterContext
implements EJBClientContext.EJBReceiverContextCloseHandler {
    private static final Logger logger = Logger.getLogger(ClusterContext.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new DaemonThreadFactory("ejb-client-cluster-node-connection-creation"));
    private final String clusterName;
    private final EJBClientContext clientContext;
    private final ConcurrentMap<String, ClusterNodeManager> nodeManagers = new ConcurrentHashMap<String, ClusterNodeManager>();
    private long maxClusterNodeOpenConnections = 10L;
    private ClusterNodeSelector clusterNodeSelector = new RandomClusterNodeSelector();
    private final Set<ClusterContextListener> clusterContextListeners = new HashSet<ClusterContextListener>();
    private final Set<String> connectedNodes = Collections.synchronizedSet(new HashSet());

    ClusterContext(String clusterName, EJBClientContext clientContext, EJBClientConfiguration ejbClientConfiguration) {
        this.clusterName = clusterName;
        this.clientContext = clientContext;
        if (ejbClientConfiguration != null && ejbClientConfiguration.getClusterConfiguration(this.clusterName) != null) {
            EJBClientConfiguration.ClusterConfiguration clusterConfiguration = ejbClientConfiguration.getClusterConfiguration(this.clusterName);
            this.setupClusterSpecificConfigurations(clusterConfiguration);
        } else {
            this.maxClusterNodeOpenConnections = 10L;
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public EJBClientContext getEJBClientContext() {
        return this.clientContext;
    }

    EJBReceiverContext getEJBReceiverContext(EJBClientInvocationContext invocationContext) {
        HashSet<String> excludedNodes = invocationContext == null ? new HashSet<String>() : new HashSet<String>(invocationContext.getExcludedNodes());
        return this.getEJBReceiverContext(invocationContext, excludedNodes);
    }

    private EJBReceiverContext getEJBReceiverContext(EJBClientInvocationContext invocationContext, Set<String> excludedNodes) {
        Set nodesInThisCluster;
        EJBReceiver ejbReceiver;
        EJBLocator<?> ejbLocator = invocationContext.getLocator();
        if (this.nodeManagers.isEmpty()) {
            return null;
        }
        HashSet availableNodes = new HashSet(this.nodeManagers.keySet());
        availableNodes.removeAll(excludedNodes);
        if (availableNodes.isEmpty()) {
            logger.debugf("No nodes available in cluster %s for selecting a receiver context", (Object)this.clusterName);
            return null;
        }
        this.connectedNodes.removeAll(excludedNodes);
        Set<String> connectedDeployedNodes = this.getConnectedAndDeployedNodes(ejbLocator);
        String selectedNodeName = this.clusterNodeSelector.selectNode(this.clusterName, connectedDeployedNodes.toArray(new String[connectedDeployedNodes.size()]), availableNodes.toArray(new String[availableNodes.size()]));
        if (selectedNodeName == null || selectedNodeName.trim().isEmpty()) {
            logger.warn((Object)(this.clusterNodeSelector + " selected an invalid node name: " + selectedNodeName + " for cluster: " + this.clusterName + ". No EJB receiver context can be selected"));
            return null;
        }
        logger.debugf("%s has selected node %s, in cluster %s", (Object)this.clusterNodeSelector, (Object)selectedNodeName, (Object)this.clusterName);
        excludedNodes.add(selectedNodeName);
        ClusterNodeManager clusterNodeManager = (ClusterNodeManager)this.nodeManagers.get(selectedNodeName);
        if (clusterNodeManager == null) {
            logger.debugf("No node manager available for node: %s in cluster: %s", (Object)selectedNodeName, (Object)this.clusterName);
            if (availableNodes.contains(selectedNodeName) || this.connectedNodes.contains(selectedNodeName)) {
                Set nodesInThisCluster2 = this.nodeManagers.keySet();
                if (excludedNodes.containsAll(nodesInThisCluster2)) {
                    logger.debugf("All nodes have been tried for a receiver, in cluster %s. No suitable receiver found", (Object)this.clusterName);
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Retrying receiver selection in cluster " + this.clusterName + " with excluded nodes " + Arrays.toString(excludedNodes.toArray())));
                }
                return this.getEJBReceiverContext(invocationContext, excludedNodes);
            }
            logger.debugf("Node selector returned a non-existent %s for cluster: %s. No EJB receiver context can be selected", (Object)selectedNodeName, (Object)this.clusterName);
            return null;
        }
        EJBReceiverContext selectedNodeReceiverContext = this.clientContext.getNodeEJBReceiverContext(selectedNodeName);
        if (selectedNodeReceiverContext != null) {
            if (selectedNodeReceiverContext.getReceiver().acceptsModule(ejbLocator.getAppName(), ejbLocator.getModuleName(), ejbLocator.getDistinctName())) {
                return selectedNodeReceiverContext;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring node " + selectedNodeName + " since it cannot handle appName=" + ejbLocator.getAppName() + ",moduleName=" + ejbLocator.getModuleName() + ",distinct-name=" + ejbLocator.getDistinctName()));
            }
        }
        if ((ejbReceiver = clusterNodeManager.getEJBReceiver()) != null) {
            this.registerEJBReceiver(ejbReceiver);
            EJBReceiverContext ejbReceiverContext = this.clientContext.getNodeEJBReceiverContext(selectedNodeName);
            if (ejbReceiverContext != null) {
                if (ejbReceiverContext.getReceiver().acceptsModule(ejbLocator.getAppName(), ejbLocator.getModuleName(), ejbLocator.getDistinctName())) {
                    return ejbReceiverContext;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Ignoring node " + selectedNodeName + " since it cannot handle appName=" + ejbLocator.getAppName() + ",moduleName=" + ejbLocator.getModuleName() + ",distinct-name=" + ejbLocator.getDistinctName()));
                }
            }
        }
        if (excludedNodes.containsAll(nodesInThisCluster = this.nodeManagers.keySet())) {
            logger.debugf("All nodes have been tried for a receiver, in cluster %s. No suitable receiver found", (Object)this.clusterName);
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrying receiver selection in cluster " + this.clusterName + " with excluded nodes " + Arrays.toString(excludedNodes.toArray())));
        }
        return this.getEJBReceiverContext(invocationContext, excludedNodes);
    }

    boolean isNodeAvailable(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        return this.nodeManagers.containsKey(nodeName);
    }

    boolean isNodeConnected(String nodeName) {
        if (nodeName == null) {
            return false;
        }
        return this.connectedNodes.contains(nodeName);
    }

    boolean isNodeConnectedAndDeployed(String nodeName, EJBLocator locator) {
        if (nodeName == null) {
            return false;
        }
        EJBReceiverContext receiverContext = this.clientContext.getNodeEJBReceiverContext(nodeName);
        if (receiverContext == null) {
            return false;
        }
        return receiverContext.getReceiver().acceptsModule(locator.getAppName(), locator.getModuleName(), locator.getDistinctName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getConnectedAndDeployedNodes(EJBLocator locator) {
        HashSet<String> connectedAndDeployed = new HashSet<String>();
        Set<String> set = this.connectedNodes;
        synchronized (set) {
            connectedAndDeployed.addAll(this.connectedNodes);
        }
        Iterator iteratorConnectedNodes = connectedAndDeployed.iterator();
        while (iteratorConnectedNodes.hasNext()) {
            String node = (String)iteratorConnectedNodes.next();
            if (this.isNodeConnectedAndDeployed(node, locator)) continue;
            iteratorConnectedNodes.remove();
        }
        return connectedAndDeployed;
    }

    public void addClusterNode(String nodeName, ClusterNodeManager clusterNodeManager) {
        this.addClusterNodes(clusterNodeManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClusterNodes(ClusterNodeManager ... clusterNodeManagers) {
        if (clusterNodeManagers == null) {
            return;
        }
        try {
            HashSet<Future<Void>> futureAssociationResults = new HashSet<Future<Void>>();
            for (int i = 0; i < clusterNodeManagers.length; ++i) {
                ClusterNodeManager clusterNodeManager = clusterNodeManagers[i];
                if (clusterNodeManager == null) continue;
                String nodeName = clusterNodeManager.getNodeName();
                if (nodeName == null || nodeName.trim().isEmpty()) {
                    throw Logs.MAIN.nodeNameCannotBeNullOrEmptyStringForCluster(this.clusterName);
                }
                if (this.nodeManagers.putIfAbsent(nodeName, clusterNodeManager) != null || this.connectedNodes.contains(nodeName) || (long)this.connectedNodes.size() >= this.maxClusterNodeOpenConnections) continue;
                futureAssociationResults.add(executorService.submit(new EJBReceiverAssociationTask(this, nodeName)));
            }
            for (Future future : futureAssociationResults) {
                try {
                    future.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            for (ClusterContextListener listener : this.clusterContextListeners) {
                try {
                    listener.clusterNodesAdded(this.clusterName, clusterNodeManagers);
                }
                catch (Throwable throwable) {
                    logger.debugf(throwable, "Ignoring the exception thrown by listener %s", (Object)listener);
                }
            }
        }
    }

    public void removeClusterNode(String nodeName) {
        this.nodeManagers.remove(nodeName);
        this.connectedNodes.remove(nodeName);
    }

    public void removeAllClusterNodes() {
        this.nodeManagers.clear();
        this.connectedNodes.clear();
    }

    void close() {
        this.removeAllClusterNodes();
    }

    public void registerEJBReceiver(EJBReceiver receiver) {
        if (receiver == null) {
            throw Logs.MAIN.paramCannotBeNull("EJB receiver");
        }
        String nodeName = receiver.getNodeName();
        if (this.connectedNodes.contains(nodeName)) {
            return;
        }
        this.clientContext.registerEJBReceiver(receiver, this);
        EJBReceiverContext ejbReceiverContext = this.clientContext.getNodeEJBReceiverContext(nodeName);
        if (ejbReceiverContext != null) {
            this.connectedNodes.add(nodeName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + " Added a new EJB receiver in cluster context " + this.clusterName + " for node " + nodeName + ". Total nodes in cluster context = " + this.connectedNodes.size()));
            }
        }
    }

    private void setupClusterSpecificConfigurations(EJBClientConfiguration.ClusterConfiguration clusterConfiguration) {
        ClusterNodeSelector nodeSelector;
        long maxLimit = clusterConfiguration.getMaximumAllowedConnectedNodes();
        if (maxLimit > 0L) {
            this.maxClusterNodeOpenConnections = maxLimit;
        }
        if ((nodeSelector = clusterConfiguration.getClusterNodeSelector()) != null) {
            this.clusterNodeSelector = nodeSelector;
        }
    }

    @Override
    public void receiverContextClosed(EJBReceiverContext receiverContext) {
        String nodeName = receiverContext.getReceiver().getNodeName();
        this.connectedNodes.remove(nodeName);
        logger.debugf("Node %s removed from cluster context %s for cluster %s", (Object)nodeName, (Object)this, (Object)this.clusterName);
    }

    void registerListener(ClusterContextListener listener) {
        if (listener == null) {
            return;
        }
        this.clusterContextListeners.add(listener);
    }

    static interface ClusterContextListener {
        public void clusterNodesAdded(String var1, ClusterNodeManager ... var2);
    }

    private class EJBReceiverAssociationTask
    implements Callable<Void> {
        private final ClusterContext clusterContext;
        private final String nodeName;

        EJBReceiverAssociationTask(ClusterContext clusterContext2, String nodeName) {
            this.nodeName = nodeName;
            this.clusterContext = clusterContext2;
        }

        @Override
        public Void call() throws Exception {
            ClusterNodeManager clusterNodeManager = (ClusterNodeManager)this.clusterContext.nodeManagers.get(this.nodeName);
            if (clusterNodeManager == null) {
                logger.debugf("Cannot create EJBReceiver since no cluster node manager found for node %s in cluster context for cluster %s", (Object)this.nodeName, (Object)ClusterContext.this.clusterName);
                return null;
            }
            EJBReceiver ejbReceiver = clusterNodeManager.getEJBReceiver();
            if (ejbReceiver == null) {
                return null;
            }
            this.clusterContext.registerEJBReceiver(ejbReceiver);
            return null;
        }
    }
}

