/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb._private.NetworkUtil;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.ConfigurationBasedEJBClientContextSelector;
import org.jboss.ejb.client.DeploymentNodeSelector;
import org.jboss.ejb.client.DiscoveredURISelector;
import org.jboss.ejb.client.EJBClientCluster;
import org.jboss.ejb.client.EJBClientConnection;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.EJBTransportProvider;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.ejb.client.TransactionInterceptor;
import org.jboss.ejb.client.URIAffinity;
import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceType;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.ServicesQueue;

public final class EJBClientContext
extends Attachable
implements Contextual<EJBClientContext> {
    public static final ServiceType EJB_SERVICE_TYPE = ServiceType.of((String)"ejb", (String)"jboss");
    private static final ContextManager<EJBClientContext> CONTEXT_MANAGER = new ContextManager(EJBClientContext.class, "jboss.ejb.client");
    private static final Supplier<Discovery> DISCOVERY_SUPPLIER = AccessController.doPrivileged(() -> ((ContextManager)Discovery.getContextManager()).getPrivilegedSupplier());
    private static final Supplier<EJBClientContext> GETTER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private static final EJBClientInterceptor[] NO_INTERCEPTORS = new EJBClientInterceptor[0];
    private static final EJBTransportProvider[] NO_TRANSPORT_PROVIDERS = new EJBTransportProvider[0];
    private static final String[] NO_STRINGS = new String[0];
    public static final String FILTER_ATTR_EJB_MODULE = "ejb-module";
    public static final String FILTER_ATTR_EJB_MODULE_DISTINCT = "ejb-module-distinct";
    public static final String FILTER_ATTR_NODE = "node";
    public static final String FILTER_ATTR_CLUSTER = "cluster";
    public static final String FILTER_ATTR_SOURCE_IP = "source-ip";
    private final EJBClientInterceptor[] interceptors;
    private final EJBTransportProvider[] transportProviders;
    private final long invocationTimeout;
    private final EJBReceiverContext receiverContext;
    private final List<EJBClientConnection> configuredConnections;
    private final Map<String, EJBClientCluster> configuredClusters;
    private final ClusterNodeSelector clusterNodeSelector;

    EJBClientContext(Builder builder) {
        List<EJBClientInterceptor> builderInterceptors = builder.interceptors;
        this.interceptors = builderInterceptors == null || builderInterceptors.isEmpty() ? NO_INTERCEPTORS : builderInterceptors.toArray(NO_INTERCEPTORS);
        List<EJBTransportProvider> builderTransportProviders = builder.transportProviders;
        this.transportProviders = builderTransportProviders == null || builderTransportProviders.isEmpty() ? NO_TRANSPORT_PROVIDERS : builderTransportProviders.toArray(new EJBTransportProvider[builderTransportProviders.size()]);
        this.invocationTimeout = builder.invocationTimeout;
        this.receiverContext = new EJBReceiverContext(this);
        List<EJBClientConnection> clientConnections = builder.clientConnections;
        this.configuredConnections = clientConnections == null || clientConnections.isEmpty() ? Collections.emptyList() : (clientConnections.size() == 1 ? Collections.singletonList(clientConnections.get(0)) : Collections.unmodifiableList(new ArrayList<EJBClientConnection>(clientConnections)));
        List<EJBClientCluster> clientClusters = builder.clientClusters;
        if (clientClusters == null || clientClusters.isEmpty()) {
            this.configuredClusters = Collections.emptyMap();
        } else if (clientClusters.size() == 1) {
            EJBClientCluster clientCluster = clientClusters.get(0);
            this.configuredClusters = Collections.singletonMap(clientCluster.getName(), clientCluster);
        } else {
            HashMap<String, EJBClientCluster> map = new HashMap<String, EJBClientCluster>();
            for (EJBClientCluster clientCluster : clientClusters) {
                map.put(clientCluster.getName(), clientCluster);
            }
            this.configuredClusters = Collections.unmodifiableMap(map);
        }
        this.clusterNodeSelector = builder.clusterNodeSelector;
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            transportProvider.notifyRegistered(this.receiverContext);
        }
    }

    public ContextManager<EJBClientContext> getInstanceContextManager() {
        return EJBClientContext.getContextManager();
    }

    public static ContextManager<EJBClientContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    public long getInvocationTimeout() {
        return this.invocationTimeout;
    }

    public List<EJBClientConnection> getConfiguredConnections() {
        return this.configuredConnections;
    }

    public EJBClientContext withAddedInterceptors(EJBClientInterceptor ... interceptors) {
        if (interceptors == null) {
            return this;
        }
        int length = interceptors.length;
        if (length == 0) {
            return this;
        }
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBClientInterceptor interceptor : interceptors) {
            if (interceptor == null) continue;
            builder.addInterceptor(interceptor);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    public EJBClientContext withAddedTransportProviders(EJBTransportProvider ... transportProviders) {
        if (transportProviders == null) {
            return this;
        }
        int length = transportProviders.length;
        if (length == 0) {
            return this;
        }
        Builder builder = new Builder(this);
        boolean construct = false;
        for (EJBTransportProvider transportProvider : transportProviders) {
            if (transportProvider == null) continue;
            builder.addTransportProvider(transportProvider);
            construct = true;
        }
        return construct ? builder.build() : this;
    }

    EJBReceiver getTransportProvider(String scheme) {
        for (EJBTransportProvider transportProvider : this.transportProviders) {
            if (!transportProvider.supportsProtocol(scheme)) continue;
            return transportProvider.getReceiver(this.receiverContext, scheme);
        }
        return null;
    }

    ServicesQueue discover(FilterSpec filterSpec) {
        return this.getDiscovery().discover(EJB_SERVICE_TYPE, filterSpec);
    }

    EJBTransportProvider[] getTransportProviders() {
        return this.transportProviders;
    }

    Discovery getDiscovery() {
        return DISCOVERY_SUPPLIER.get();
    }

    public static EJBClientContext getCurrent() {
        EJBClientContext clientContext = GETTER.get();
        if (clientContext == null) {
            throw Logs.MAIN.noEJBClientContextAvailable();
        }
        return clientContext;
    }

    public static EJBClientContext requireCurrent() {
        return EJBClientContext.getCurrent();
    }

    <T> StatefulEJBLocator<T> createSession(StatelessEJBLocator<T> statelessLocator) throws Exception {
        LocatedAction action = (receiver, originalLocator, newAffinity) -> receiver.createSession(originalLocator.withNewAffinity(newAffinity));
        return this.performLocatedAction(statelessLocator, action);
    }

    <R, L extends EJBLocator<T>, T> R performLocatedAction(L locator, LocatedAction<R, L, T> locatedAction) throws Exception {
        String scheme;
        Affinity affinity = locator.getAffinity();
        if (affinity instanceof NodeAffinity) {
            return this.discoverAffinityNode(locator, (NodeAffinity)affinity, locatedAction);
        }
        if (affinity instanceof ClusterAffinity) {
            return this.discoverAffinityCluster(locator, (ClusterAffinity)affinity, locatedAction);
        }
        if (affinity == Affinity.LOCAL) {
            scheme = "local";
        } else if (affinity instanceof URIAffinity) {
            scheme = affinity.getUri().getScheme();
        } else {
            assert (affinity == Affinity.NONE);
            return this.discoverAffinityNone(locator, locatedAction);
        }
        EJBReceiver transportProvider = this.getTransportProvider(scheme);
        if (transportProvider == null) {
            throw Logs.MAIN.noEJBReceiverAvailable(locator);
        }
        return locatedAction.execute(transportProvider, locator, locator.getAffinity());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <R, L extends EJBLocator<T>, T> R discoverAffinityNone(L locator, LocatedAction<R, L, T> locatedAction) throws Exception {
        assert (locator.getAffinity() == Affinity.NONE);
        try (ServicesQueue servicesQueue = this.discover(this.getFilterSpec(locator.getIdentifier()));){
            ServiceURL nextServiceURL;
            ServiceURL serviceURL;
            do {
                if ((serviceURL = servicesQueue.takeService()) != null) continue;
                throw Logs.MAIN.noEJBReceiverAvailable(locator);
            } while (!this.supports(serviceURL));
            while ((nextServiceURL = servicesQueue.takeService()) != null && !this.supports(nextServiceURL)) {
            }
            if (nextServiceURL == null) {
                Affinity affinity = Affinity.forUri(serviceURL.getLocationURI());
                if (affinity instanceof NodeAffinity) {
                    R r = this.discoverAffinityNode(locator, (NodeAffinity)affinity, locatedAction);
                    return r;
                }
                if (affinity instanceof ClusterAffinity) {
                    R r = this.discoverAffinityCluster(locator, (ClusterAffinity)affinity, locatedAction);
                    return r;
                }
                if (affinity == Affinity.LOCAL) {
                    assert (this.supports(serviceURL));
                    R r = locatedAction.execute(this.getTransportProvider("local"), locator, affinity);
                    return r;
                }
                EJBReceiver provider = this.getTransportProvider(affinity.getUri().getScheme());
                if (provider == null) {
                    throw Logs.MAIN.noEJBReceiverAvailable(locator);
                }
                R r = locatedAction.execute(provider, locator, affinity);
                return r;
            }
            ArrayList<URI> uris = new ArrayList<URI>();
            ArrayList<String> nodes = new ArrayList<String>();
            ArrayList<String> clusters = new ArrayList<String>();
            boolean[] local = new boolean[1];
            this.classify(serviceURL, uris, nodes, clusters, local);
            this.classify(nextServiceURL, uris, nodes, clusters, local);
            if (local[0]) {
                R r = locatedAction.execute(this.getTransportProvider("local"), locator, Affinity.LOCAL);
                return r;
            }
            serviceURL = servicesQueue.takeService();
            while (serviceURL != null) {
                if (this.supports(serviceURL)) {
                    this.classify(serviceURL, uris, nodes, clusters, local);
                }
                if (local[0]) {
                    R r = locatedAction.execute(this.getTransportProvider("local"), locator, Affinity.LOCAL);
                    return r;
                }
                serviceURL = servicesQueue.takeService();
            }
            if (!uris.isEmpty()) {
                DiscoveredURISelector selector;
                URI uri;
                if (uris.size() == 1) {
                    uri = (URI)uris.get(0);
                } else {
                    selector = DiscoveredURISelector.RANDOM;
                    uri = selector.selectNode(uris, locator);
                    if (uri == null) {
                        throw Logs.MAIN.selectorReturnedNull(selector);
                    }
                }
                selector = locatedAction.execute(this.getTransportProvider(uri.getScheme()), locator, Affinity.forUri(uri));
                return (R)selector;
            }
            if (!nodes.isEmpty()) {
                String node;
                if (nodes.size() == 1) {
                    node = (String)nodes.get(0);
                } else {
                    DeploymentNodeSelector selector = DeploymentNodeSelector.RANDOM;
                    node = selector.selectNode(nodes.toArray(NO_STRINGS), locator.getAppName(), locator.getModuleName(), locator.getDistinctName());
                    if (node == null) {
                        throw Logs.MAIN.selectorReturnedNull(selector);
                    }
                }
                R r = this.discoverAffinityNode(locator, new NodeAffinity(node), locatedAction);
                return r;
            }
            assert (!clusters.isEmpty());
            R r = this.discoverAffinityCluster(locator, new ClusterAffinity((String)clusters.get(0)), locatedAction);
            return r;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Logs.MAIN.operationInterrupted();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <R, L extends EJBLocator<T>, T> R discoverAffinityNode(L locator, NodeAffinity nodeAffinity, LocatedAction<R, L, T> locatedAction) throws Exception {
        try (ServicesQueue servicesQueue = this.discover(this.getFilterSpec(nodeAffinity));){
            while (true) {
                ServiceURL serviceURL;
                if ((serviceURL = servicesQueue.takeService()) == null) {
                    throw Logs.MAIN.noEJBReceiverAvailable(locator);
                }
                EJBReceiver receiver = this.getTransportProvider(serviceURL.getUriScheme());
                if (receiver != null) {
                    R r = locatedAction.execute(receiver, locator, Affinity.forUri(serviceURL.getLocationURI()));
                    return r;
                }
                continue;
                break;
            }
        }
    }

    private <R, L extends EJBLocator<T>, T> R discoverAffinityCluster(L locator, ClusterAffinity clusterAffinity, LocatedAction<R, L, T> locatedAction) throws Exception {
        String[] nodeArray;
        ClusterNodeSelector configSelector;
        String clusterName = clusterAffinity.getClusterName();
        EJBClientCluster cluster = this.configuredClusters.get(clusterName);
        ClusterNodeSelector selector = cluster != null ? ((configSelector = cluster.getClusterNodeSelector()) == null ? this.clusterNodeSelector : configSelector) : this.clusterNodeSelector;
        HashSet<URI> unresolvedUris = new HashSet<URI>();
        HashSet<String> nodes = new HashSet<String>();
        try (ServicesQueue servicesQueue = this.discover(this.getFilterSpec(clusterAffinity));){
            Object serviceURL = servicesQueue.takeService();
            while (serviceURL != null) {
                String scheme;
                switch (scheme = serviceURL.getUriScheme()) {
                    case "node": {
                        nodes.add(serviceURL.getLocationURI().getSchemeSpecificPart());
                        break;
                    }
                    case "local": {
                        break;
                    }
                    case "cluster": {
                        break;
                    }
                    default: {
                        if (this.getTransportProvider(scheme) == null) break;
                        unresolvedUris.add(serviceURL.getLocationURI());
                    }
                }
                serviceURL = servicesQueue.takeService();
            }
        }
        if (nodes.isEmpty()) {
            if (unresolvedUris.isEmpty()) {
                throw Logs.MAIN.noEJBReceiverAvailable(locator);
            }
            URI uri = (URI)unresolvedUris.iterator().next();
            return locatedAction.execute(this.getTransportProvider(uri.getScheme()), locator, URIAffinity.forUri(uri));
        }
        if (nodes.size() == 1) {
            return this.discoverAffinityNode(locator, new NodeAffinity((String)nodes.iterator().next()), locatedAction);
        }
        HashMap<String, URI> all = new HashMap<String, URI>();
        HashMap<String, URI> connected = new HashMap<String, URI>();
        block40: for (String nodeName : nodes) {
            ServicesQueue servicesQueue = this.discover(this.getNodeFilterSpec(nodeName));
            Throwable throwable = null;
            try {
                ServiceURL serviceURL = servicesQueue.takeService();
                while (serviceURL != null) {
                    String scheme;
                    switch (scheme = serviceURL.getUriScheme()) {
                        case "node": {
                            break;
                        }
                        case "cluster": {
                            break;
                        }
                        default: {
                            EJBReceiver transportProvider = this.getTransportProvider(scheme);
                            if (transportProvider == null) break;
                            URI locationURI = serviceURL.getLocationURI();
                            if (!this.satisfiesSourceAddress(serviceURL, transportProvider)) continue block40;
                            if (transportProvider.isConnected(locationURI)) {
                                connected.put(nodeName, locationURI);
                            }
                            all.put(nodeName, locationURI);
                            continue block40;
                        }
                    }
                    serviceURL = servicesQueue.takeService();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (servicesQueue == null) continue;
                if (throwable != null) {
                    try {
                        servicesQueue.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                servicesQueue.close();
            }
        }
        String[] connectedArray = connected.keySet().toArray(NO_STRINGS);
        String node = selector.selectNode(clusterName, connectedArray, nodeArray = all.keySet().toArray(NO_STRINGS));
        if (node == null) {
            throw Logs.MAIN.selectorReturnedNull(selector);
        }
        URI uri = (URI)all.get(node);
        if (uri == null) {
            throw Logs.MAIN.noEJBReceiverAvailable(locator);
        }
        return locatedAction.execute(this.getTransportProvider(uri.getScheme()), locator, Affinity.forUri(uri));
    }

    private boolean supports(ServiceURL serviceURL) {
        String scheme = serviceURL.getLocationURI().getScheme();
        return FILTER_ATTR_NODE.equals(scheme) || FILTER_ATTR_CLUSTER.equals(scheme) || this.getTransportProvider(scheme) != null;
    }

    private void classify(ServiceURL serviceURL, List<URI> uris, List<String> nodes, List<String> clusters, boolean[] local) {
        URI locationURI = serviceURL.getLocationURI();
        String scheme = locationURI.getScheme();
        if (FILTER_ATTR_NODE.equals(scheme)) {
            nodes.add(locationURI.getSchemeSpecificPart());
        } else if (FILTER_ATTR_CLUSTER.equals(scheme)) {
            clusters.add(locationURI.getSchemeSpecificPart());
        } else if ("local".equals(scheme)) {
            local[0] = true;
        } else {
            uris.add(locationURI);
        }
    }

    FilterSpec getFilterSpec(EJBIdentifier identifier) {
        String appName = identifier.getAppName();
        String moduleName = identifier.getModuleName();
        String distinctName = identifier.getDistinctName();
        if (distinctName != null && !distinctName.isEmpty()) {
            if (appName.isEmpty()) {
                return FilterSpec.equal((String)FILTER_ATTR_EJB_MODULE_DISTINCT, (String)(moduleName + '/' + distinctName));
            }
            return FilterSpec.equal((String)FILTER_ATTR_EJB_MODULE_DISTINCT, (String)(appName + '/' + moduleName + '/' + distinctName));
        }
        if (appName.isEmpty()) {
            return FilterSpec.equal((String)FILTER_ATTR_EJB_MODULE, (String)moduleName);
        }
        return FilterSpec.equal((String)FILTER_ATTR_EJB_MODULE, (String)(appName + '/' + moduleName));
    }

    FilterSpec getFilterSpec(NodeAffinity nodeAffinity) {
        return this.getNodeFilterSpec(nodeAffinity.getNodeName());
    }

    FilterSpec getNodeFilterSpec(String nodeName) {
        return FilterSpec.equal((String)FILTER_ATTR_NODE, (String)nodeName);
    }

    FilterSpec getFilterSpec(ClusterAffinity clusterAffinity) {
        return FilterSpec.equal((String)FILTER_ATTR_CLUSTER, (String)clusterAffinity.getClusterName());
    }

    boolean satisfiesSourceAddress(ServiceURL serviceURL, EJBReceiver receiver) {
        List values = serviceURL.getAttributeValues(FILTER_ATTR_SOURCE_IP);
        if (values.isEmpty()) {
            return true;
        }
        SocketAddress sourceAddress = receiver.getSourceAddress(serviceURL.getLocationURI());
        InetAddress inetAddress = sourceAddress instanceof InetSocketAddress ? ((InetSocketAddress)sourceAddress).getAddress() : null;
        for (AttributeValue value : values) {
            int mask;
            InetAddress matchAddress;
            String string;
            int slash;
            if (!value.isString() || (slash = (string = value.toString()).indexOf(47)) == -1) continue;
            try {
                matchAddress = InetAddress.getByName(string.substring(0, slash));
            }
            catch (UnknownHostException e) {
                continue;
            }
            try {
                mask = Integer.parseInt(string.substring(slash + 1));
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (inetAddress == null) {
                if (mask != 0) continue;
                break;
            }
            if (!NetworkUtil.belongsToNetwork(inetAddress, matchAddress, mask)) continue;
            return true;
        }
        return false;
    }

    EJBClientInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    static {
        CONTEXT_MANAGER.setGlobalDefaultSupplier((Supplier)new ConfigurationBasedEJBClientContextSelector());
    }

    static interface LocatedAction<R, L extends EJBLocator<T>, T> {
        public R execute(EJBReceiver var1, L var2, Affinity var3) throws Exception;
    }

    public static final class Builder {
        List<EJBClientInterceptor> interceptors;
        List<EJBTransportProvider> transportProviders;
        List<EJBClientConnection> clientConnections;
        List<EJBClientCluster> clientClusters;
        ClusterNodeSelector clusterNodeSelector = ClusterNodeSelector.DEFAULT;
        long invocationTimeout;

        public Builder() {
            this.interceptors = new ArrayList<EJBClientInterceptor>();
            this.interceptors.add(new TransactionInterceptor());
        }

        Builder(EJBClientContext ejbClientContext) {
            EJBTransportProvider[] transportProviders;
            EJBClientInterceptor[] interceptors = ejbClientContext.getInterceptors();
            if (interceptors.length > 0) {
                this.interceptors = new ArrayList<EJBClientInterceptor>(Arrays.asList(interceptors));
            }
            if ((transportProviders = ejbClientContext.getTransportProviders()).length > 0) {
                this.transportProviders = new ArrayList<EJBTransportProvider>(Arrays.asList(transportProviders));
            }
            this.clientConnections = new ArrayList<EJBClientConnection>(ejbClientContext.getConfiguredConnections());
        }

        public void addInterceptor(EJBClientInterceptor interceptor) {
            Assert.checkNotNullParam((String)"interceptor", (Object)interceptor);
            if (this.interceptors == null) {
                this.interceptors = new ArrayList<EJBClientInterceptor>();
            }
            this.interceptors.add(interceptor);
        }

        public void addTransportProvider(EJBTransportProvider provider) {
            Assert.checkNotNullParam((String)"provider", (Object)provider);
            if (this.transportProviders == null) {
                this.transportProviders = new ArrayList<EJBTransportProvider>();
            }
            this.transportProviders.add(provider);
        }

        public void addClientConnection(EJBClientConnection connection) {
            Assert.checkNotNullParam((String)"connection", (Object)connection);
            if (this.clientConnections == null) {
                this.clientConnections = new ArrayList<EJBClientConnection>();
            }
            this.clientConnections.add(connection);
        }

        public void addClientCluster(EJBClientCluster cluster) {
            Assert.checkNotNullParam((String)EJBClientContext.FILTER_ATTR_CLUSTER, (Object)cluster);
            if (this.clientClusters == null) {
                this.clientClusters = new ArrayList<EJBClientCluster>();
            }
            this.clientClusters.add(cluster);
        }

        public void setClusterNodeSelector(ClusterNodeSelector clusterNodeSelector) {
            Assert.checkNotNullParam((String)"clusterNodeSelector", (Object)clusterNodeSelector);
            this.clusterNodeSelector = clusterNodeSelector;
        }

        public void setInvocationTimeout(long invocationTimeout) {
            Assert.checkMinimumParameter((String)"invocationTimeout", (long)0L, (long)invocationTimeout);
            this.invocationTimeout = invocationTimeout;
        }

        public EJBClientContext build() {
            return new EJBClientContext(this);
        }
    }
}

