/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

final class IndexedList<T>
extends AbstractList<T> {
    private final ArrayList<T> arrayList;
    private final HashSet<T> hashSet;

    IndexedList(ArrayList<T> arrayList, HashSet<T> hashSet) {
        this.arrayList = arrayList;
        this.hashSet = hashSet;
    }

    static <T> List<T> indexedListOf(Collection<T> list) {
        if (list.size() == 0) {
            return Collections.emptyList();
        }
        if (list.size() == 1) {
            return Collections.singletonList(list.iterator().next());
        }
        ArrayList<T> al = new ArrayList<T>(list);
        HashSet<T> index = new HashSet<T>(al);
        return new IndexedList<T>(al, index);
    }

    @Override
    public boolean contains(Object o) {
        return this.hashSet.contains(o);
    }

    @Override
    public int size() {
        return this.arrayList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }

    @Override
    public int indexOf(Object o) {
        return this.arrayList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.arrayList.lastIndexOf(o);
    }

    @Override
    public Object[] toArray() {
        return this.arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.arrayList.toArray(a);
    }

    @Override
    public T get(int index) {
        return this.arrayList.get(index);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.arrayList.forEach((Consumer<T>)action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.arrayList.spliterator();
    }
}

