/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import javax.ejb.NoSuchEJBException;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.jboss.ejb.protocol.remote.EJBClientChannel;
import org.jboss.ejb.protocol.remote.NodeInformation;
import org.jboss.ejb.protocol.remote.RemoteEJBReceiver;
import org.jboss.ejb.protocol.remote.RemoteTransportProvider;

@ClientInterceptorPriority(value=200200)
public final class RemotingEJBClientInterceptor
implements EJBClientInterceptor {
    public static final int PRIORITY = 200200;

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        context.sendRequest();
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        try {
            return context.getResult();
        }
        catch (NoSuchEJBException e) {
            this.removeNode(context);
            throw e;
        }
    }

    @Override
    public StatefulEJBLocator<?> handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        try {
            return context.proceed();
        }
        catch (NoSuchEJBException e) {
            this.removeNode(context);
            throw e;
        }
    }

    private void removeNode(AbstractInvocationContext context) {
        NodeInformation nodeInformation;
        EJBClientChannel ejbClientChannel;
        RemoteEJBReceiver ejbReceiver;
        Affinity targetAffinity = context.getTargetAffinity();
        if (targetAffinity instanceof NodeAffinity && (ejbReceiver = context.getClientContext().getAttachment(RemoteTransportProvider.ATTACHMENT_KEY)) != null && (ejbClientChannel = context.getAttachment(RemoteEJBReceiver.EJBCC_KEY)) != null && (nodeInformation = ejbReceiver.getDiscoveredNodeRegistry().getNodeInformation(((NodeAffinity)targetAffinity).getNodeName())) != null) {
            nodeInformation.removeModule(ejbClientChannel, context.getLocator().getIdentifier().getModuleIdentifier());
        }
    }
}

