/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jboss.ejb._private.Logs;
import org.wildfly.common.Assert;

final class CallbackBuffer {
    private final AtomicReference<State> stateRef = new AtomicReference<UnfinishedState>(INITIAL);
    private static final State COMPLETE = new State();
    private static final UnfinishedState INITIAL = new UnfinishedState();

    CallbackBuffer() {
    }

    public void activate() {
        this.stateRef.get().activate(this.stateRef);
    }

    public <T, U> void addListener(BiConsumer<T, U> consumer, T p1, U p2) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        this.stateRef.get().addListener(this.stateRef, consumer, p1, p2);
    }

    public <T> void addListener(Consumer<T> consumer, T p1) {
        this.addListener(Consumer::accept, consumer, p1);
    }

    public void addListener(Runnable runnable) {
        this.addListener(Runnable::run, runnable);
    }

    static class State {
        State() {
        }

        void activate(AtomicReference<State> stateRef) {
        }

        <T, U> void addListener(AtomicReference<State> stateRef, BiConsumer<T, U> consumer, T p1, U p2) {
            Logs.REMOTING.tracef("Running callback %s(%s, %s)", consumer, p1, p2);
            consumer.accept(p1, p2);
        }
    }

    static class UnfinishedState
    extends State {
        UnfinishedState() {
        }

        @Override
        final void activate(AtomicReference<State> stateRef) {
            if (stateRef.compareAndSet(this, COMPLETE)) {
                this.activated();
            } else {
                stateRef.get().activate(stateRef);
            }
        }

        void activated() {
        }

        @Override
        <T, U> void addListener(AtomicReference<State> stateRef, BiConsumer<T, U> consumer, T p1, U p2) {
            if (!stateRef.compareAndSet(this, new UnfinishedWithListenerState<T, U>(this, consumer, p1, p2))) {
                stateRef.get().addListener(stateRef, consumer, p1, p2);
            }
            Logs.REMOTING.tracef("Added callback (delayed) %s(%s, %s)", consumer, p1, p2);
        }
    }

    static class UnfinishedWithListenerState<T, U>
    extends UnfinishedState {
        private final UnfinishedState next;
        private final BiConsumer<T, U> consumer;
        private final T p1;
        private final U p2;

        UnfinishedWithListenerState(UnfinishedState next, BiConsumer<T, U> consumer, T p1, U p2) {
            this.next = next;
            this.consumer = consumer;
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        void activated() {
            try {
                Logs.REMOTING.tracef("Running callback (delayed) %s(%s, %s)", this.consumer, this.p1, this.p2);
                this.consumer.accept(this.p1, this.p2);
            }
            finally {
                this.next.activated();
            }
        }
    }
}

