/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.jboss.annotation.factory.AnnotationProxy;
import org.jboss.annotation.factory.AnnotationValidator;
import org.jboss.annotation.factory.SimpleAnnotationValidator;
import org.jboss.annotation.factory.ast.ASTAnnotation;
import org.jboss.annotation.factory.ast.ASTChar;
import org.jboss.annotation.factory.ast.ASTIdentifier;
import org.jboss.annotation.factory.ast.ASTMemberValueArrayInitializer;
import org.jboss.annotation.factory.ast.ASTMemberValuePair;
import org.jboss.annotation.factory.ast.ASTMemberValuePairs;
import org.jboss.annotation.factory.ast.ASTSingleMemberValue;
import org.jboss.annotation.factory.ast.ASTStart;
import org.jboss.annotation.factory.ast.ASTString;
import org.jboss.annotation.factory.ast.AnnotationParser;
import org.jboss.annotation.factory.ast.AnnotationParserVisitor;
import org.jboss.annotation.factory.ast.Node;
import org.jboss.annotation.factory.ast.SimpleNode;
import org.jboss.annotation.factory.javassist.DefaultValueAnnotationValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCreator
implements AnnotationParserVisitor {
    private Class<?> annotation;
    private Class<?> type;
    public Object typeValue;
    static final AnnotationValidator defaultAnnotationReader;

    public AnnotationCreator(Class<?> annotation, Class<?> type) {
        this.type = type;
        this.annotation = annotation;
    }

    @Override
    public Object visit(ASTMemberValuePairs node, Object data) {
        node.childrenAccept(this, data);
        return null;
    }

    @Override
    public Object visit(ASTMemberValuePair node, Object data) {
        String name = node.getIdentifier().getValue();
        node.getValue().jjtAccept(this, name);
        return data;
    }

    @Override
    public Object visit(ASTSingleMemberValue node, Object data) {
        node.getValue().jjtAccept(this, "value");
        return data;
    }

    @Override
    public Object visit(ASTIdentifier node, Object data) {
        try {
            if (this.type.equals(Class.class)) {
                String classname = node.getValue();
                if (classname.endsWith(".class")) {
                    classname = classname.substring(0, classname.indexOf(".class"));
                }
                if (classname.equals("void")) {
                    this.typeValue = Void.TYPE;
                } else if (classname.equals("int")) {
                    this.typeValue = Integer.TYPE;
                } else if (classname.equals("byte")) {
                    this.typeValue = Byte.TYPE;
                } else if (classname.equals("long")) {
                    this.typeValue = Long.TYPE;
                } else if (classname.equals("double")) {
                    this.typeValue = Double.TYPE;
                } else if (classname.equals("float")) {
                    this.typeValue = Float.TYPE;
                } else if (classname.equals("char")) {
                    this.typeValue = Character.TYPE;
                } else if (classname.equals("short")) {
                    this.typeValue = Short.TYPE;
                } else if (classname.equals("boolean")) {
                    this.typeValue = Boolean.TYPE;
                } else {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    this.typeValue = Class.forName(classname, false, loader);
                }
            } else if (this.type.isPrimitive()) {
                if (this.type.equals(Boolean.TYPE)) {
                    this.typeValue = new Boolean(node.getValue());
                } else if (this.type.equals(Short.TYPE)) {
                    this.typeValue = Short.valueOf(node.getValue());
                } else if (this.type.equals(Float.TYPE)) {
                    this.typeValue = Float.valueOf(node.getValue());
                } else if (this.type.equals(Double.TYPE)) {
                    this.typeValue = Double.valueOf(node.getValue());
                } else if (this.type.equals(Long.TYPE)) {
                    this.typeValue = Long.valueOf(node.getValue());
                } else if (this.type.equals(Byte.TYPE)) {
                    this.typeValue = new Byte(node.getValue());
                } else if (this.type.equals(Integer.TYPE)) {
                    this.typeValue = new Integer(node.getValue());
                }
            } else {
                int index = node.getValue().lastIndexOf(46);
                if (index == -1) {
                    throw new RuntimeException("Enum must be fully qualified: " + node.getValue());
                }
                String className = node.getValue().substring(0, index);
                String en = node.getValue().substring(index + 1);
                Class<?> enumClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                if (enumClass.getSuperclass().getName().equals("java.lang.Enum")) {
                    Method valueOf = null;
                    Method[] methods = enumClass.getSuperclass().getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals("valueOf")) continue;
                        valueOf = methods[i];
                        break;
                    }
                    Object[] args = new Object[]{enumClass, en};
                    this.typeValue = valueOf.invoke(null, args);
                } else {
                    Field field = enumClass.getField(en);
                    this.typeValue = field.get(null);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public Object visit(ASTString node, Object data) {
        if (!this.type.equals(String.class)) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an String");
        }
        this.typeValue = node.getValue();
        return null;
    }

    @Override
    public Object visit(ASTChar node, Object data) {
        if (!this.type.equals(Character.TYPE)) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an char");
        }
        this.typeValue = new Character(node.getValue());
        return null;
    }

    @Override
    public Object visit(ASTMemberValueArrayInitializer node, Object data) {
        if (!this.type.isArray()) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an array");
        }
        Class<?> baseType = this.type.getComponentType();
        int size = node.jjtGetNumChildren();
        this.typeValue = Array.newInstance(baseType, size);
        for (int i = 0; i < size; ++i) {
            AnnotationCreator creator = new AnnotationCreator(this.annotation, baseType);
            node.jjtGetChild(i).jjtAccept(creator, null);
            Array.set(this.typeValue, i, creator.typeValue);
        }
        return null;
    }

    @Override
    public Object visit(ASTAnnotation node, Object data) {
        try {
            Class<?> subAnnotation = Thread.currentThread().getContextClassLoader().loadClass(node.getIdentifier());
            this.typeValue = AnnotationCreator.createAnnotation(node, subAnnotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        return null;
    }

    private static Class<?> getMemberType(Class<?> annotation, String member) {
        Method[] methods = annotation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(member)) continue;
            return methods[i].getReturnType();
        }
        throw new RuntimeException("unable to determine member type for annotation: " + annotation.getName() + "." + member);
    }

    private static ASTAnnotation getRootExpr(final String annotationExpr) throws Exception {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ASTAnnotation>(){

                @Override
                public ASTAnnotation run() throws Exception {
                    AnnotationParser parser = new AnnotationParser(new StringReader(annotationExpr));
                    ASTStart start = parser.Start();
                    return (ASTAnnotation)start.jjtGetChild(0);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Error getting root expression", e.getException());
        }
    }

    public static Object createAnnotation(ASTAnnotation node, Class<?> annotation, ClassLoader cl) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (annotation == null) {
            ClassLoader loader = cl != null ? cl : Thread.currentThread().getContextClassLoader();
            annotation = loader.loadClass(node.getIdentifier());
        }
        if (node.jjtGetNumChildren() > 0) {
            Node contained = node.jjtGetChild(0);
            if (contained instanceof ASTSingleMemberValue) {
                Class<?> type = AnnotationCreator.getMemberType(annotation, "value");
                AnnotationCreator creator = new AnnotationCreator(annotation, type);
                contained.jjtAccept(creator, "value");
                map.put("value", creator.typeValue);
            } else {
                ASTMemberValuePairs pairs = (ASTMemberValuePairs)contained;
                for (int i = 0; i < pairs.jjtGetNumChildren(); ++i) {
                    ASTMemberValuePair member = (ASTMemberValuePair)pairs.jjtGetChild(i);
                    Class<?> type = AnnotationCreator.getMemberType(annotation, member.getIdentifier().getValue());
                    AnnotationCreator creator = new AnnotationCreator(annotation, type);
                    member.jjtAccept(creator, null);
                    map.put(member.getIdentifier().getValue(), creator.typeValue);
                }
            }
        }
        defaultAnnotationReader.validate(map, annotation);
        return AnnotationProxy.createProxy(map, annotation);
    }

    public static Object createAnnotation(ASTAnnotation node, Class<?> annotation) throws Exception {
        return AnnotationCreator.createAnnotation(node, annotation, null);
    }

    public static Object createAnnotation(String annotationExpr, Class<?> annotation) throws Exception {
        return AnnotationCreator.createAnnotation(AnnotationCreator.getRootExpr(annotationExpr), annotation, null);
    }

    public static Object createAnnotation(String annotationExpr, ClassLoader cl) throws Exception {
        return AnnotationCreator.createAnnotation(AnnotationCreator.getRootExpr(annotationExpr), null, cl);
    }

    static {
        boolean haveJavassist = false;
        try {
            Class.forName("javassist.CtClass");
            haveJavassist = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        defaultAnnotationReader = haveJavassist ? new DefaultValueAnnotationValidator() : new SimpleAnnotationValidator();
    }
}

