/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.jboss.annotation.factory.AnnotationProxy;
import org.jboss.annotation.factory.AnnotationValidator;
import org.jboss.annotation.factory.SimpleAnnotationValidator;
import org.jboss.annotation.factory.ast.ASTAnnotation;
import org.jboss.annotation.factory.ast.ASTChar;
import org.jboss.annotation.factory.ast.ASTIdentifier;
import org.jboss.annotation.factory.ast.ASTMemberValueArrayInitializer;
import org.jboss.annotation.factory.ast.ASTMemberValuePair;
import org.jboss.annotation.factory.ast.ASTMemberValuePairs;
import org.jboss.annotation.factory.ast.ASTSingleMemberValue;
import org.jboss.annotation.factory.ast.ASTStart;
import org.jboss.annotation.factory.ast.ASTString;
import org.jboss.annotation.factory.ast.AnnotationParser;
import org.jboss.annotation.factory.ast.AnnotationParserVisitor;
import org.jboss.annotation.factory.ast.Node;
import org.jboss.annotation.factory.ast.SimpleNode;
import org.jboss.annotation.factory.javassist.DefaultValueAnnotationValidator;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCreator
implements AnnotationParserVisitor {
    private Class<?> annotation;
    private Class<?> type;
    public Object typeValue;
    private ClassLoader loader;
    static final AnnotationValidator defaultAnnotationReader;

    public AnnotationCreator(Class<?> annotation, Class<?> type, ClassLoader loader) {
        this.type = type;
        this.annotation = annotation;
        this.loader = loader;
    }

    public AnnotationCreator(Class<?> annotation, Class<?> type) {
        this.type = type;
        this.annotation = annotation;
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Object visit(ASTMemberValuePairs node, Object data) {
        node.childrenAccept(this, data);
        return null;
    }

    @Override
    public Object visit(ASTMemberValuePair node, Object data) {
        String name = node.getIdentifier().getValue();
        node.getValue().jjtAccept(this, name);
        return data;
    }

    @Override
    public Object visit(ASTSingleMemberValue node, Object data) {
        node.getValue().jjtAccept(this, "value");
        return data;
    }

    @Override
    public Object visit(ASTIdentifier node, Object data) {
        try {
            if (this.type.equals(Class.class)) {
                String classname = node.getValue();
                if (classname.endsWith(".class")) {
                    classname = classname.substring(0, classname.indexOf(".class"));
                }
                this.typeValue = classname.equals("void") ? Void.TYPE : (classname.equals("int") ? Integer.TYPE : (classname.equals("byte") ? Byte.TYPE : (classname.equals("long") ? Long.TYPE : (classname.equals("double") ? Double.TYPE : (classname.equals("float") ? Float.TYPE : (classname.equals("char") ? Character.TYPE : (classname.equals("short") ? Short.TYPE : (classname.equals("boolean") ? Boolean.TYPE : Class.forName(classname, false, this.loader)))))))));
            } else if (this.type.isPrimitive()) {
                if (this.type.equals(Boolean.TYPE)) {
                    this.typeValue = new Boolean(node.getValue());
                } else if (this.type.equals(Short.TYPE)) {
                    this.typeValue = Short.valueOf(node.getValue());
                } else if (this.type.equals(Float.TYPE)) {
                    this.typeValue = Float.valueOf(node.getValue());
                } else if (this.type.equals(Double.TYPE)) {
                    this.typeValue = Double.valueOf(node.getValue());
                } else if (this.type.equals(Long.TYPE)) {
                    this.typeValue = Long.valueOf(node.getValue());
                } else if (this.type.equals(Byte.TYPE)) {
                    this.typeValue = new Byte(node.getValue());
                } else if (this.type.equals(Integer.TYPE)) {
                    this.typeValue = new Integer(node.getValue());
                }
            } else {
                int index = node.getValue().lastIndexOf(46);
                if (index == -1) {
                    throw new RuntimeException("Enum must be fully qualified: " + node.getValue());
                }
                String className = node.getValue().substring(0, index);
                String en = node.getValue().substring(index + 1);
                Class<?> enumClass = this.loader.loadClass(className);
                if (enumClass.getSuperclass().getName().equals("java.lang.Enum")) {
                    Method valueOf = null;
                    Method[] methods = enumClass.getSuperclass().getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals("valueOf")) continue;
                        valueOf = methods[i];
                        break;
                    }
                    Object[] args = new Object[]{enumClass, en};
                    this.typeValue = valueOf.invoke(null, args);
                } else {
                    Field field = enumClass.getField(en);
                    this.typeValue = field.get(null);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public Object visit(ASTString node, Object data) {
        if (!this.type.equals(String.class)) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an String");
        }
        this.typeValue = node.getValue();
        return null;
    }

    @Override
    public Object visit(ASTChar node, Object data) {
        if (!this.type.equals(Character.TYPE)) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an char");
        }
        this.typeValue = new Character(node.getValue());
        return null;
    }

    @Override
    public Object visit(ASTMemberValueArrayInitializer node, Object data) {
        if (!this.type.isArray()) {
            throw new RuntimeException(this.annotation.getName() + "." + data + " is not an array");
        }
        Class<?> baseType = this.type.getComponentType();
        int size = node.jjtGetNumChildren();
        this.typeValue = Array.newInstance(baseType, size);
        for (int i = 0; i < size; ++i) {
            AnnotationCreator creator = new AnnotationCreator(this.annotation, baseType, this.loader);
            node.jjtGetChild(i).jjtAccept(creator, null);
            Array.set(this.typeValue, i, creator.typeValue);
        }
        return null;
    }

    @Override
    public Object visit(ASTAnnotation node, Object data) {
        try {
            Class<?> subAnnotation = this.loader.loadClass(node.getIdentifier());
            this.typeValue = AnnotationCreator.createAnnotation(node, subAnnotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        return null;
    }

    @Override
    public Object visit(ASTStart node, Object data) {
        return null;
    }

    private static Class<?> getMemberType(Class<?> annotation, String member) {
        Method[] methods = annotation.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(member)) continue;
            return methods[i].getReturnType();
        }
        throw new RuntimeException("unable to determine member type for annotation: " + annotation.getName() + "." + member);
    }

    private static ASTAnnotation getRootExpr(final String annotationExpr) throws Exception {
        final StringBuffer expr = new StringBuffer();
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ASTAnnotation>(){

                @Override
                public ASTAnnotation run() throws Exception {
                    String expression = StringPropertyReplacer.replaceProperties((String)annotationExpr);
                    expr.append(expression);
                    AnnotationParser parser = new AnnotationParser(new StringReader(expression));
                    ASTStart start = parser.Start();
                    return (ASTAnnotation)start.jjtGetChild(0);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Error getting root expression " + expr.toString(), e.getException());
        }
    }

    public static Object createAnnotation(ASTAnnotation node, Class<?> annotation, ClassLoader cl) throws Exception {
        ClassLoader loader;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ClassLoader classLoader = loader = cl != null ? cl : Thread.currentThread().getContextClassLoader();
        if (annotation == null) {
            annotation = loader.loadClass(node.getIdentifier());
        }
        if (node.jjtGetNumChildren() > 0) {
            Node contained = node.jjtGetChild(0);
            if (contained instanceof ASTSingleMemberValue) {
                Class<?> type = AnnotationCreator.getMemberType(annotation, "value");
                AnnotationCreator creator = new AnnotationCreator(annotation, type, loader);
                contained.jjtAccept(creator, "value");
                map.put("value", creator.typeValue);
            } else {
                ASTMemberValuePairs pairs = (ASTMemberValuePairs)contained;
                for (int i = 0; i < pairs.jjtGetNumChildren(); ++i) {
                    ASTMemberValuePair member = (ASTMemberValuePair)pairs.jjtGetChild(i);
                    Class<?> type = AnnotationCreator.getMemberType(annotation, member.getIdentifier().getValue());
                    AnnotationCreator creator = new AnnotationCreator(annotation, type, loader);
                    member.jjtAccept(creator, null);
                    map.put(member.getIdentifier().getValue(), creator.typeValue);
                }
            }
        }
        defaultAnnotationReader.validate(map, annotation);
        return AnnotationProxy.createProxy(map, annotation);
    }

    public static Object createAnnotation(ASTAnnotation node, Class<?> annotation) throws Exception {
        return AnnotationCreator.createAnnotation(node, annotation, null);
    }

    public static Object createAnnotation(String annotationExpr, Class<?> annotation) throws Exception {
        return AnnotationCreator.createAnnotation(AnnotationCreator.getRootExpr(annotationExpr), annotation, null);
    }

    public static Object createAnnotation(String annotationExpr, ClassLoader cl) throws Exception {
        return AnnotationCreator.createAnnotation(AnnotationCreator.getRootExpr(annotationExpr), null, cl);
    }

    static {
        boolean haveJavassist = false;
        try {
            Class.forName("javassist.CtClass");
            haveJavassist = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        defaultAnnotationReader = haveJavassist ? new DefaultValueAnnotationValidator() : new SimpleAnnotationValidator();
    }
}

