/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.javaee.jboss;

// $Id: JBossServiceReferencesMetaData.java 67166 2007-11-16 10:25:28Z wolfc $

import javax.xml.bind.annotation.XmlType;

import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;
import org.jboss.metadata.javaee.support.JavaEEMetaDataUtil;

/**
 * JBoss service-ref metadata
 * @author Scott.Stark@jboss.org
 * @version $Revision: 67166 $
 */
@XmlType(name = "service-refType")
public class JBossServiceReferencesMetaData extends ServiceReferencesMetaData
{
   /** The serialVersionUID */
   private static final long serialVersionUID = 1;

   /**
    * Create a new ServiceReferencesMetaData.
    */
   public JBossServiceReferencesMetaData()
   {
   }

   /**
    * Merge resource references
    * 
    * @param override the override references
    * @param overriden the overriden references 
    * @param overridenFile the overriden file name
    * @param overrideFile the override file
    * @return the merged referencees
    */
   public static JBossServiceReferencesMetaData merge(ServiceReferencesMetaData override, ServiceReferencesMetaData overriden, String overridenFile, String overrideFile)
   {
      if (override == null && overriden == null)
         return null;

      // TODO: if overriden is empty, it's silly to do a merge
      
      JBossServiceReferencesMetaData merged = new JBossServiceReferencesMetaData();
      JavaEEMetaDataUtil.merge(merged, overriden, override, "service-ref", overridenFile, overrideFile, false);
      return merged;
   }

}
