/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.spi;

import java.io.ObjectStreamException;
import java.util.HashMap;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.AbstractTypeInfo;
import org.jboss.reflect.spi.ProgressionConvertor;
import org.jboss.reflect.spi.ProgressionConvertorFactory;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveInfo
extends AbstractTypeInfo {
    private static final long serialVersionUID = 3256718498443835449L;
    public static final PrimitiveInfo BOOLEAN = new PrimitiveInfo("boolean", 0, Boolean.TYPE);
    public static final PrimitiveInfo BYTE = new PrimitiveInfo("byte", 1, Byte.TYPE);
    public static final PrimitiveInfo CHAR = new PrimitiveInfo("char", 2, Character.TYPE);
    public static final PrimitiveInfo DOUBLE = new PrimitiveInfo("double", 3, Double.TYPE);
    public static final PrimitiveInfo FLOAT = new PrimitiveInfo("float", 4, Float.TYPE);
    public static final PrimitiveInfo INT = new PrimitiveInfo("int", 5, Integer.TYPE);
    public static final PrimitiveInfo LONG = new PrimitiveInfo("long", 6, Long.TYPE);
    public static final PrimitiveInfo SHORT = new PrimitiveInfo("short", 7, Short.TYPE);
    public static final PrimitiveInfo VOID = new PrimitiveInfo("void", 8, Void.TYPE);
    private static final PrimitiveInfo[] values = new PrimitiveInfo[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID};
    protected static final TypeInfoFactory typeInfoFactory = new IntrospectionTypeInfoFactory();
    protected final transient String name;
    protected final int ordinal;
    protected final transient Class<? extends Object> type;
    private static final HashMap<String, Class<?>> primitiveTypes = new HashMap();
    private static final HashMap<String, String> primitiveArrayTypes = new HashMap();
    private static final HashMap<String, Class<?>> primitiveArrayTypesClassMap = new HashMap();
    private static final HashMap<String, PrimitiveInfo> map = new HashMap();

    public static PrimitiveInfo valueOf(String name) {
        return map.get(name);
    }

    public static String getPrimativeArrayType(String name) {
        return primitiveArrayTypes.get(name);
    }

    public static Class<?> getPrimativeType(String name) {
        return primitiveTypes.get(name);
    }

    public static Class<?> getPrimativeArrayComponentType(String name) {
        return primitiveArrayTypesClassMap.get(name);
    }

    protected PrimitiveInfo(String name, int ordinal, Class<? extends Object> type) {
        this.name = name;
        this.ordinal = ordinal;
        this.type = type;
    }

    public int ordinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return this.type.getSimpleName();
    }

    @Override
    @Deprecated
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Object convertValue(Object value) throws Throwable {
        Object progressResult = ValueConvertor.progressValue(this.type, value);
        if (progressResult != null) {
            return progressResult;
        }
        return ValueConvertor.convertValue(this.type, value);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties) throws Throwable {
        Object progressResult = ValueConvertor.progressValue(this.type, value);
        if (progressResult != null) {
            return progressResult;
        }
        return ValueConvertor.convertValue(this.type, value, replaceProperties);
    }

    @Override
    public Object convertValue(Object value, boolean replaceProperties, boolean trim) throws Throwable {
        Object progressResult = ValueConvertor.progressValue(this.type, value);
        if (progressResult != null) {
            return progressResult;
        }
        return ValueConvertor.convertValue(this.type, value, replaceProperties, trim);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public TypeInfo getArrayType() {
        Class<?> arrayClass = ClassInfoImpl.getArrayClass(this.getType());
        return typeInfoFactory.getTypeInfo(arrayClass);
    }

    @Override
    public Object newArrayInstance(int size) throws Throwable {
        throw new UnsupportedOperationException("Not an array " + this.name);
    }

    @Override
    public boolean isAssignableFrom(TypeInfo info) {
        if (info == this) {
            return true;
        }
        try {
            ProgressionConvertor pc = ProgressionConvertorFactory.getInstance().getConvertor();
            return pc.canProgress(this.getType(), info.getType());
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public TypeInfoFactory getTypeInfoFactory() {
        return typeInfoFactory;
    }

    public String toString() {
        return this.name;
    }

    public String toShortString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrimitiveInfo)) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        PrimitiveInfo other = (PrimitiveInfo)obj;
        return other.ordinal == this.ordinal;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    Object readResolve() throws ObjectStreamException {
        return values[this.ordinal];
    }

    static {
        map.put("boolean", BOOLEAN);
        map.put("byte", BYTE);
        map.put("char", CHAR);
        map.put("double", DOUBLE);
        map.put("float", FLOAT);
        map.put("int", INT);
        map.put("long", LONG);
        map.put("short", SHORT);
        map.put("void", VOID);
        primitiveTypes.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveTypes.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveTypes.put(Character.TYPE.getName(), Character.TYPE);
        primitiveTypes.put(Double.TYPE.getName(), Double.TYPE);
        primitiveTypes.put(Float.TYPE.getName(), Float.TYPE);
        primitiveTypes.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveTypes.put(Long.TYPE.getName(), Long.TYPE);
        primitiveTypes.put(Short.TYPE.getName(), Short.TYPE);
        primitiveArrayTypes.put(Byte.TYPE.getName(), "B");
        primitiveArrayTypes.put(Boolean.TYPE.getName(), "Z");
        primitiveArrayTypes.put(Character.TYPE.getName(), "C");
        primitiveArrayTypes.put(Double.TYPE.getName(), "D");
        primitiveArrayTypes.put(Float.TYPE.getName(), "F");
        primitiveArrayTypes.put(Integer.TYPE.getName(), "I");
        primitiveArrayTypes.put(Long.TYPE.getName(), "J");
        primitiveArrayTypes.put(Short.TYPE.getName(), "S");
        primitiveArrayTypesClassMap.put("B", Byte.TYPE);
        primitiveArrayTypesClassMap.put("Z", Boolean.TYPE);
        primitiveArrayTypesClassMap.put("C", Character.TYPE);
        primitiveArrayTypesClassMap.put("D", Double.TYPE);
        primitiveArrayTypesClassMap.put("F", Float.TYPE);
        primitiveArrayTypesClassMap.put("I", Integer.TYPE);
        primitiveArrayTypesClassMap.put("J", Long.TYPE);
        primitiveArrayTypesClassMap.put("S", Short.TYPE);
    }
}

