/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.joinpoint.spi;

/**
 * A join point
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @author <a href="mailto:adrian@jboss.org">Adrian Brock</a>
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
public interface Joinpoint extends Cloneable
{
   /**
    * Invoke on the actual joinpoint
    *
    * @return the result of the invocation
    * @throws Throwable for any error
    */
   Object dispatch() throws Throwable;

   /**
    * Invoke cleanup on joinpoint.
    *
    * @return cleanup result
    */
   Object cleanup();

   /**
    * Make a copy of the joinpoint
    * 
    * @return a copy of the join point
    */
   Object clone();

   /**
    * A human readable version of the join point
    *
    * @return a human readable description of the join point
    */
   String toHumanReadableString();
}
