/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Collection;
import java.util.Map;
import javassist.CtClass;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.javassist.JavassistHelper;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.DelegateClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

public class JavassistParameterizedClassInfo
extends DelegateClassInfo {
    private static final long serialVersionUID = 2L;
    private final JavassistTypeInfoFactoryImpl factory;
    private final SignatureAttribute.TypeArgument[] typeArguments;
    private volatile TypeInfo[] typeArgumentInfos = ClassInfoImpl.UNKNOWN_TYPES;

    JavassistParameterizedClassInfo(JavassistTypeInfoFactoryImpl factory, ClassInfo delegate, SignatureAttribute.TypeArgument[] typeArguments) {
        super(delegate);
        this.factory = factory;
        this.typeArguments = typeArguments;
    }

    public JavassistParameterizedClassInfo(JavassistTypeInfoFactoryImpl factory, ClassInfo delegate, TypeInfo[] typeArgumentInfos) {
        this(factory, delegate, (SignatureAttribute.TypeArgument[])null);
        this.typeArgumentInfos = typeArgumentInfos;
    }

    public TypeInfoFactory getTypeInfoFactory() {
        return this.factory;
    }

    public TypeInfo[] getActualTypeArguments() {
        if (this.typeArgumentInfos == ClassInfoImpl.UNKNOWN_TYPES && this.typeArguments.length > 0) {
            try {
                TypeInfo[] infos = new TypeInfo[this.typeArguments.length];
                for (int i = 0; i < this.typeArguments.length; ++i) {
                    infos[i] = (TypeInfo)this.factory.get(this.typeArguments[i].getType().toString(), this.delegate.getClassLoader());
                }
                this.typeArgumentInfos = infos;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.typeArgumentInfos;
    }

    public TypeInfo getComponentType() {
        return this.findTypeInfo(Collection.class.getName(), 0, CollectionTypeChecker.INSTANCE);
    }

    public TypeInfo getKeyType() {
        return this.findTypeInfo(Map.class.getName(), 0, MapTypeChecker.INSTANCE);
    }

    public TypeInfo getValueType() {
        return this.findTypeInfo(Map.class.getName(), 1, MapTypeChecker.INSTANCE);
    }

    private TypeInfo findTypeInfo(String target, int parameter, TypeChecker checker) {
        SignatureAttribute.ClassSignature sig = JavassistHelper.getClassSignature(((JavassistTypeInfo)this.delegate).getCtClass());
        if (sig == null) {
            return this.delegate.getComponentType();
        }
        if (!checker.check(this)) {
            return null;
        }
        try {
            CtClass ctClass = ((JavassistTypeInfo)this.delegate).getCtClass();
            CtClass collection = ctClass.getClassPool().get(target);
            int index = JavassistHelper.determineInfoIndex(this.getActualTypeArguments(), ((JavassistTypeInfo)this.delegate).getCtClass(), collection, parameter);
            return this.getActualTypeArguments()[index];
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
    }

    private static class CollectionTypeChecker
    implements TypeChecker {
        static final CollectionTypeChecker INSTANCE = new CollectionTypeChecker();

        private CollectionTypeChecker() {
        }

        public boolean check(JavassistParameterizedClassInfo info) {
            return info.isCollection();
        }
    }

    private static class MapTypeChecker
    implements TypeChecker {
        static final MapTypeChecker INSTANCE = new MapTypeChecker();

        private MapTypeChecker() {
        }

        public boolean check(JavassistParameterizedClassInfo info) {
            return info.isMap();
        }
    }

    private static interface TypeChecker {
        public boolean check(JavassistParameterizedClassInfo var1);
    }
}

