/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import org.jboss.reflect.util.objectweb.asm.ClassReader;
import org.jboss.util.CachePolicy;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class ClassReaderCache
{
   private final CachePolicy policy;
   
   ClassReaderCache(CachePolicy policy)
   {
      this.policy = policy;
   }
   
   public void put(String classname, ClassReader reader)
   {
      //Something strange is going on with the policy, sometimes it says duplicate entries even when I test with a peek/get, so always remove the existing entry
      policy.remove(classname);
      policy.insert(classname, reader);
   }
   
   public ClassReader get(String classname)
   {
      return (ClassReader)policy.get(classname);
   }
   
   public void invalidate()
   {
      policy.flush();
   }
}
