/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.bytecode.bytes;

/**
 * Contains the bytecode information for a class
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
public interface ClassBytes extends Bytes
{
   /**
    * Get the primitive type if this is one
    * 
    *  @return the primitive type if this is a primitive type or null otherwise
    */
   PrimitiveBytes getPrimitive();
   
   /**
    * Gets the JVM name of this class, e.g.
    * <code>org/jboss/test/SomeClass</code>
    * 
    * @return the JVM name
    * @see #getTypeInfoName()
    */
   String getJvmName();
   
   /**
    * Gets the TypeInfo name of this class, e.g.
    * <code>org.jboss.test.SomeClass</code>
    * 
    * @return the TypeInfo name
    * @see #getJvmName()
    */
   String getTypeInfoName();
   
   /**
    * Gets the classloader for the class
    * 
    * @return the classloader
    */
   ClassLoader getClassLoader();
   
   /**
    * Check if this class is an interface
    * 
    * @return true if it is an interface
    */
   boolean isInterface();
   
   /**
    * Check if this class is an enum
    * 
    * @return true if it is an enum
    */
   boolean isEnum();
   
   /**
    * Check if this class is an annotation
    * 
    * @return true if it is an annotation
    */
   boolean isAnnotation();
   
   /**
    * Get the JVM name of the superclass
    * 
    * @return the superclass name or null if there is no superclass
    * @see #getJvmName()
    */
   String getSuperClassJvmName();

   /**
    * Get the TypeInfo name of the superclass
    * 
    * @return the superclass name or null if there is no superclass
    * @see #getTypeInfoName()
    */
   String getSuperClassTypeInfoName();
   
   /**
    * Get the JVM names of the interfaces
    * 
    * @return the interface names, or an empty array if there are no interfaces
    * @see #getJvmName()
    */
   String[] getInterfaceJvmNames();
   
   /**
    * Get the TypeInfo names of the interfaces
    * 
    * @return the interface names, or an empty array if there are no interfaces
    * @see #getTypeInfoName()
    */
   String[] getInterfaceTypeInfoNames();
   
   /**
    * Get the fields declared in this class
    * 
    * @return the fields, or an empty array if there are no fields 
    */
   FieldBytes[] getDeclaredFieldBytes();
   
   /**
    * Get the constuctors declared in this class
    * 
    * @return the constructors, or an empty array if there are no constructors 
    */
   ConstructorBytes[] getDeclaredConstructorBytes();
   
   
   /**
    * Get the methods declared in this class
    * 
    * @return the methods, or an empty array if there are no methods 
    */
   MethodBytes[] getDeclaredMethodBytes();
   
   /**
    * Get the component type for an array class. If this class is not an array return null
    * 
    * @return the component type if this class is an array
    */
   ClassBytes getComponentType();
}
