/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.reflect.Array;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.SecurityActions;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.NotFoundException;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.Classes;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistUtil {
    public static Class<?> ctClassToClass(CtClass ct) {
        if (ct.isModified() && !ct.isFrozen()) {
            try {
                return ct.toClass();
            }
            catch (CannotCompileException e) {
                throw new org.jboss.reflect.spi.CannotCompileException(e.toString());
            }
        }
        try {
            if (ct.isArray()) {
                int dim = 0;
                while (ct.getComponentType() != null) {
                    ++dim;
                    ct = ct.getComponentType();
                }
                if (ct.isPrimitive()) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < dim; ++i) {
                        sb.append("[");
                    }
                    sb.append(((CtPrimitiveType)ct).getDescriptor());
                    try {
                        return JavassistUtil.getClassLoader(ct).loadClass(sb.toString());
                    }
                    catch (ClassNotFoundException cnfe) {
                        return Class.forName(sb.toString(), false, JavassistUtil.getClassLoader(ct));
                    }
                }
                return Array.newInstance(JavassistUtil.ctClassToClass(ct), new int[dim]).getClass();
            }
            return JavassistUtil.getClassLoader(ct).loadClass(ct.getName());
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
        catch (ClassNotFoundException e) {
            try {
                return ct.toClass();
            }
            catch (CannotCompileException e1) {
                throw new org.jboss.reflect.spi.CannotCompileException(e1.toString());
            }
        }
    }

    public static CtClass toCtClass(ClassPool pool, String name) {
        try {
            return pool.get(name);
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
    }

    public static CtClass[] toCtClass(ClassPool pool, String[] names) {
        if (names == null) {
            return new CtClass[0];
        }
        CtClass[] classes = new CtClass[names.length];
        for (int i = 0; i < names.length; ++i) {
            classes[i] = JavassistUtil.toCtClass(pool, names[i]);
        }
        return classes;
    }

    public static CtClass toCtClass(ClassInfo clazz) {
        if (clazz instanceof JavassistTypeInfo) {
            return ((JavassistTypeInfo)clazz).getCtClass();
        }
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            ClassPool classPool = JavassistTypeInfoFactoryImpl.getPoolFactory().getPoolForLoader(classLoader);
            return classPool.get(clazz.getName());
        }
        catch (javassist.NotFoundException e) {
            throw new NotFoundException(e.toString());
        }
    }

    public static TypeInfo toTypeInfo(CtClass ctClass) {
        JavassistTypeInfoFactoryImpl impl = JavassistTypeInfoFactory.delegate;
        return impl.get(ctClass);
    }

    public static CtClass[] toCtClass(ClassInfo[] classes) {
        CtClass[] clazzes = new CtClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            clazzes[i] = JavassistUtil.toCtClass(classes[i]);
        }
        return clazzes;
    }

    public static ClassLoader getClassLoader(CtClass ctClass) {
        ClassPool pool = ctClass.getClassPool();
        ClassLoader loader = null;
        if (pool != null) {
            loader = pool.getClassLoader();
        }
        if (loader == null) {
            loader = SecurityActions.getContextClassLoader();
        }
        return loader;
    }

    public static String getSignature(CtConstructor ctor) {
        return ctor.getDeclaringClass().getName() + ctor.getSignature();
    }

    public static String getSignature(CtMethod method) {
        return method.getDeclaringClass().getName() + "." + method.getName() + method.getSignature();
    }

    public static String getSignature(CtField field) {
        return field.getDeclaringClass().getName() + "." + field.getName();
    }

    private static Class<?> loadClass(ClassLoader cl, CtClass ctClass) {
        if (ctClass.isPrimitive()) {
            return JavassistUtil.getPrimitiveClass(ctClass);
        }
        if (ctClass.isArray()) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            try {
                CtClass temp = ctClass;
                boolean dims = false;
                while (temp.isArray()) {
                    buffer.append('[');
                    temp = temp.getComponentType();
                }
                if (temp.isPrimitive()) {
                    CtPrimitiveType primitive = (CtPrimitiveType)temp;
                    buffer.append(Character.toString(primitive.getDescriptor()));
                } else {
                    buffer.append('L');
                    buffer.append(temp.getName());
                    buffer.append(';');
                }
                return Classes.loadClass((String)buffer.toString(), (ClassLoader)cl);
            }
            catch (javassist.NotFoundException e) {
                throw new RuntimeException(ctClass.getName(), e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(buffer.toString() + " not found in " + cl);
            }
        }
        try {
            return cl.loadClass(ctClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(ctClass.getName() + " not found in " + cl);
        }
    }

    private static Class<?> getPrimitiveClass(CtClass ctClass) {
        if (!ctClass.isPrimitive()) {
            throw new IllegalArgumentException("Not a primitive ");
        }
        if (ctClass == CtClass.booleanType) {
            return Boolean.TYPE;
        }
        if (ctClass == CtClass.byteType) {
            return Byte.TYPE;
        }
        if (ctClass == CtClass.charType) {
            return Character.TYPE;
        }
        if (ctClass == CtClass.doubleType) {
            return Double.TYPE;
        }
        if (ctClass == CtClass.floatType) {
            return Float.TYPE;
        }
        if (ctClass == CtClass.intType) {
            return Integer.TYPE;
        }
        if (ctClass == CtClass.longType) {
            return Long.TYPE;
        }
        if (ctClass == CtClass.shortType) {
            return Short.TYPE;
        }
        return null;
    }
}

