/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Arrays;
import javassist.CtBehavior;
import javassist.bytecode.Descriptor;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class SignatureKey {
    String name;
    String[] params;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    private static final String[] NO_PARAMS = new String[0];

    public SignatureKey(String name) {
        this.name = name;
        this.params = NO_PARAMS;
    }

    public SignatureKey(String name, TypeInfo ... typeInfos) {
        this.name = name;
        if (typeInfos != null && typeInfos.length > 0) {
            this.params = new String[typeInfos.length];
            for (int i = 0; i < typeInfos.length; ++i) {
                this.params[i] = typeInfos[i].getName();
            }
        } else {
            this.params = NO_PARAMS;
        }
    }

    public SignatureKey(String name, CtBehavior behavior) {
        this.name = name;
        this.params = this.getParameterTypeStringsForSignature(behavior);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SignatureKey)) {
            return false;
        }
        SignatureKey other = (SignatureKey)obj;
        if (this.name == null && other.name != null) {
            return false;
        }
        if (this.name != null && other.name == null) {
            return false;
        }
        if (this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        if (this.params == null && other.params == null) {
            return true;
        }
        if (this.params == null && other.params != null) {
            return false;
        }
        if (this.params != null && other.params == null) {
            return false;
        }
        if (this.params.length != other.params.length) {
            return false;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].equals(other.params[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            JBossStringBuilder builder = new JBossStringBuilder();
            if (this.name != null) {
                builder.append(this.name);
            }
            if (this.params != null) {
                for (int i = 0; i < this.params.length; ++i) {
                    builder.append(this.params[i]);
                }
            }
            this.cachedHashCode = builder.toString().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.params == null) {
            return this.name + "[]";
        }
        return this.name + Arrays.asList(this.params);
    }

    private String[] getParameterTypeStringsForSignature(CtBehavior behavior) {
        String desc = behavior.getSignature();
        String[] args = new String[Descriptor.numOfParameters((String)desc)];
        int n = 0;
        int i = 1;
        while ((i = this.getParameterTypeString(desc, i, args, n++)) > 0 && n < args.length) {
        }
        return args;
    }

    private int getParameterTypeString(String desc, int i, String[] args, int n) {
        String name;
        int i2;
        int arrayDim = 0;
        char c = desc.charAt(i);
        if (c == ')') {
            return ++i;
        }
        while (c == '[') {
            ++arrayDim;
            c = desc.charAt(++i);
        }
        boolean object = false;
        if (c == 'L') {
            i2 = desc.indexOf(59, ++i);
            name = desc.substring(i, i2++).replace('/', '.');
            object = true;
        } else {
            String type = arrayDim == 0 ? this.toPrimitiveClass(c) : String.valueOf(c);
            i2 = i + 1;
            if (arrayDim == 0) {
                args[n] = type;
                return i2;
            }
            name = type;
        }
        if (arrayDim > 0) {
            StringBuilder sb = new StringBuilder();
            while (arrayDim-- > 0) {
                sb.append("[");
            }
            if (object) {
                sb.append("L");
            }
            sb.append(name);
            if (object) {
                sb.append(";");
            }
            name = sb.toString();
        }
        args[n] = name;
        return i2;
    }

    private String toPrimitiveClass(char c) {
        String type = null;
        switch (c) {
            case 'Z': {
                type = "boolean";
                break;
            }
            case 'C': {
                type = "char";
                break;
            }
            case 'B': {
                type = "byte";
                break;
            }
            case 'S': {
                type = "short";
                break;
            }
            case 'I': {
                type = "int";
                break;
            }
            case 'J': {
                type = "long";
                break;
            }
            case 'F': {
                type = "float";
                break;
            }
            case 'D': {
                type = "double";
                break;
            }
            case 'V': {
                type = "void";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive type " + c);
            }
        }
        return type;
    }

    public String[] getParams() {
        return this.params;
    }

    public boolean isDouble(int i) {
        return this.params[i].equals("double");
    }

    public boolean isLong(int i) {
        return this.params[i].equals("long");
    }
}

