/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode;

import java.io.Serializable;
import java.lang.reflect.Array;
import javassist.Modifier;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeArrayInfoImpl
extends BytecodeTypeInfo
implements ArrayInfo {
    private static final long serialVersionUID = 1L;
    static final AnnotationValue[] UNKNOWN_ANNOTATIONS = new AnnotationValue[0];
    private volatile int modifiers;
    protected final TypeInfo componentType;
    protected final int hash;

    private static String getName(TypeInfo componentType) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        TypeInfo temp = componentType;
        while (temp.isArray()) {
            builder.append("[");
            temp = ((BytecodeArrayInfoImpl)temp).componentType;
        }
        if (temp.isPrimitive()) {
            String encodedName = PrimitiveInfo.getPrimativeArrayType(temp.getName());
            builder.append(encodedName);
        } else {
            builder.append("L").append(temp.getName()).append(";");
        }
        return builder.toString();
    }

    BytecodeArrayInfoImpl(BytecodeTypeInfoFactoryImpl factory, ClassBytes classBytes, Class<? extends Object> clazz, TypeInfo componentType) {
        super(factory, BytecodeArrayInfoImpl.getName(componentType), classBytes, clazz);
        if (componentType == null) {
            throw new IllegalArgumentException("Null component type");
        }
        this.componentType = componentType;
        this.hash = this.calculateHash();
    }

    @Override
    public TypeInfo getComponentType() {
        return this.componentType;
    }

    @Override
    public AnnotationValue getAnnotation(String name) {
        return null;
    }

    @Override
    public AnnotationValue[] getAnnotations() {
        return UNKNOWN_ANNOTATIONS;
    }

    @Override
    public boolean isAnnotationPresent(String name) {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    protected String getPackageName() {
        TypeInfo info = this.componentType;
        while (info.isArray() && info instanceof ClassInfo) {
            info = ((ClassInfo)info).getComponentType();
        }
        return this.getPackageName(info.getName());
    }

    @Override
    public Class<? extends Object> getType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        String name = this.getName();
        int dims = 0;
        int i = 0;
        while (name.charAt(i) == '[') {
            ++dims;
            ++i;
        }
        int dim = 0;
        TypeInfo info = this.componentType;
        while (info.isArray()) {
            ++dim;
            if (!(info instanceof ClassInfo)) break;
            info = ((ClassInfo)info).getComponentType();
        }
        this.clazz = Array.newInstance(info.getType(), new int[dims]).getClass();
        return this.clazz;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayInfo)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArrayInfo arrayInfo = (ArrayInfo)o;
        return this.componentType.equals(arrayInfo.getComponentType());
    }

    public int hashCode() {
        return this.hash;
    }

    protected int calculateHash() {
        int result = super.hashCode();
        result = 29 * result + this.componentType.hashCode();
        return result;
    }

    @Override
    public InterfaceInfo[] getGenericInterfaces() {
        return this.getInterfaces();
    }

    @Override
    public InterfaceInfo[] getInterfaces() {
        InterfaceInfo cloneable = (InterfaceInfo)this.getFactory().get(Cloneable.class);
        InterfaceInfo serializable = (InterfaceInfo)this.getFactory().get(Serializable.class);
        return new InterfaceInfo[]{cloneable, serializable};
    }

    @Override
    public int getModifiers() {
        if (this.modifiers == 0) {
            TypeInfo info = this.componentType;
            if (info.isArray()) {
                this.modifiers = ((ClassInfo)info).getModifiers();
            } else {
                int mod = 0;
                if (this.componentType instanceof ClassInfo) {
                    int typeModifiers = ((ClassInfo)this.componentType).getModifiers();
                    if (Modifier.isPublic((int)typeModifiers)) {
                        mod = 1;
                    } else if (Modifier.isProtected((int)typeModifiers)) {
                        mod = 4;
                    } else if (Modifier.isPrivate((int)typeModifiers)) {
                        mod = 2;
                    }
                } else if (this.componentType instanceof PrimitiveInfo) {
                    mod = 1;
                }
                mod |= 0x10;
                this.modifiers = mod |= 0x400;
            }
        }
        return this.modifiers;
    }
}

