/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.util.objectweb.asm;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.reflect.util.objectweb.asm.AnnotationVisitor;
import org.jboss.reflect.util.objectweb.asm.Attribute;
import org.jboss.reflect.util.objectweb.asm.ClassVisitor;
import org.jboss.reflect.util.objectweb.asm.ClassWriter;
import org.jboss.reflect.util.objectweb.asm.FieldVisitor;
import org.jboss.reflect.util.objectweb.asm.Item;
import org.jboss.reflect.util.objectweb.asm.Label;
import org.jboss.reflect.util.objectweb.asm.MethodVisitor;
import org.jboss.reflect.util.objectweb.asm.MethodWriter;
import org.jboss.reflect.util.objectweb.asm.Opcodes;
import org.jboss.reflect.util.objectweb.asm.Type;

public class ClassReader {
    static final boolean SIGNATURES = true;
    static final boolean ANNOTATIONS = true;
    static final boolean FRAMES = true;
    static final boolean WRITER = true;
    static final boolean RESIZE = true;
    public static final int SKIP_CODE = 1;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    public static final int SKIP_OUTER_CLASSES = 32;
    public static final int SKIP_INNER_CLASSES = 64;
    public static final int SKIP_UNKNOWN_ATTRIBUTES = 128;
    public static final int INCLUDE_HEADER = 256;
    public static final int INCLUDE_CLASS_ANNOTATIONS = 512;
    public static final int INCLUDE_FIELD_OVERVIEW = 1024;
    public static final int INCLUDE_FIELD_ANNOTATIONS = 2048;
    public static final int INCLUDE_FIELD_UNKNOWN_ATTRIBUTES = 4096;
    public static final int INCLUDE_METHOD_OVERVIEW = 8192;
    public static final int INCLUDE_METHOD_ANNOTATIONS = 16384;
    public static final int INCLUDE_METHOD_PARAMETER_ANNOTATIONS = 32768;
    public static final int INCLUDE_METHOD_UNKNOWN_ATTRIBUTES = 65536;
    public static final int INCLUDE_DEFAULT_ANNOTATION_VALUES = 131072;
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;

    public ClassReader(byte[] b) {
        this(b, 0, b.length);
    }

    public ClassReader(byte[] b, int off, int len) {
        this.b = b;
        this.items = new int[this.readUnsignedShort(off + 8)];
        int n = this.items.length;
        this.strings = new String[n];
        int max = 0;
        int index = off + 10;
        for (int i = 1; i < n; ++i) {
            int size;
            this.items[i] = index + 1;
            switch (b[index]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readUnsignedShort(index + 1);
                    if (size <= max) break;
                    max = size;
                    break;
                }
                default: {
                    size = 3;
                }
            }
            index += size;
        }
        this.maxStringLength = max;
        this.header = index;
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    public String getSuperName() {
        int n = this.items[this.readUnsignedShort(this.header + 4)];
        return n == 0 ? null : this.readUTF8(n, new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int index = this.header + 6;
        int n = this.readUnsignedShort(index);
        String[] interfaces = new String[n];
        if (n > 0) {
            char[] buf = new char[this.maxStringLength];
            for (int i = 0; i < n; ++i) {
                interfaces[i] = this.readClass(index += 2, buf);
            }
        }
        return interfaces;
    }

    void copyPool(ClassWriter classWriter) {
        char[] buf = new char[this.maxStringLength];
        int ll = this.items.length;
        Item[] items2 = new Item[ll];
        for (int i = 1; i < ll; ++i) {
            int index = this.items[i];
            byte tag = this.b[index - 1];
            Item item = new Item(i);
            switch (tag) {
                case 9: 
                case 10: 
                case 11: {
                    int nameType = this.items[this.readUnsignedShort(index + 2)];
                    item.set(tag, this.readClass(index, buf), this.readUTF8(nameType, buf), this.readUTF8(nameType + 2, buf));
                    break;
                }
                case 3: {
                    item.set(this.readInt(index));
                    break;
                }
                case 4: {
                    item.set(Float.intBitsToFloat(this.readInt(index)));
                    break;
                }
                case 12: {
                    item.set(tag, this.readUTF8(index, buf), this.readUTF8(index + 2, buf), null);
                    break;
                }
                case 5: {
                    item.set(this.readLong(index));
                    ++i;
                    break;
                }
                case 6: {
                    item.set(Double.longBitsToDouble(this.readLong(index)));
                    ++i;
                    break;
                }
                case 1: {
                    String s = this.strings[i];
                    if (s == null) {
                        index = this.items[i];
                        s = this.strings[i] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
                    }
                    item.set(tag, s, null, null);
                    break;
                }
                default: {
                    item.set(tag, this.readUTF8(index, buf), null, null);
                }
            }
            int index2 = item.hashCode % items2.length;
            item.next = items2[index2];
            items2[index2] = item;
        }
        int off = this.items[1] - 1;
        classWriter.pool.putByteArray(this.b, off, this.header - off);
        classWriter.items = items2;
        classWriter.threshold = (int)(0.75 * (double)ll);
        classWriter.index = ll;
    }

    public ClassReader(InputStream is) throws IOException {
        this(ClassReader.readClass(is));
    }

    public ClassReader(String name) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(name.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Class not found");
        }
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    byte[] c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            int last = is.read();
            if (last < 0) {
                return b;
            }
            byte[] c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            c[len++] = (byte)last;
            b = c;
        }
    }

    public void accept(ClassVisitor classVisitor, int flags) {
        this.accept(classVisitor, new Attribute[0], flags);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attrs, int flags) {
        Attribute attr;
        int j;
        int i;
        char[] c = new char[this.maxStringLength];
        int anns = 0;
        int ianns = 0;
        Attribute cattrs = null;
        boolean skipDebug = (flags & 2) != 0;
        boolean skipOuterClasses = (flags & 0x20) != 0;
        boolean skipInnerClasses = (flags & 0x40) != 0;
        boolean includeHeader = (flags & 0x100) != 0;
        boolean includeClassAnnotations = (flags & 0x200) != 0;
        boolean skipUnknownAttributes = (flags & 0x80) != 0;
        int u = this.header;
        int access = this.readUnsignedShort(u);
        String name = this.readClass(u + 2, c);
        int v = this.items[this.readUnsignedShort(u + 4)];
        String superClassName = v == 0 || includeHeader ? null : this.readUTF8(v, c);
        String[] implementedItfs = new String[this.readUnsignedShort(u + 6)];
        int w = 0;
        u += 8;
        for (i = 0; i < implementedItfs.length; ++i) {
            if (includeHeader) {
                implementedItfs[i] = this.readClass(u, c);
            }
            u += 2;
        }
        v = u;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            j = this.readUnsignedShort(v + 6);
            v += 8;
            while (j > 0) {
                v += 6 + this.readInt(v + 2);
                --j;
            }
            --i;
        }
        String signature = null;
        String sourceFile = null;
        String sourceDebug = null;
        String enclosingOwner = null;
        String enclosingName = null;
        String enclosingDesc = null;
        i = this.readUnsignedShort(v);
        v += 2;
        while (i > 0) {
            String attrName = this.readUTF8(v, c);
            if ("SourceFile".equals(attrName)) {
                if (!skipDebug) {
                    sourceFile = this.readUTF8(v + 6, c);
                }
            } else if ("InnerClasses".equals(attrName)) {
                w = v + 6;
            } else if ("EnclosingMethod".equals(attrName)) {
                if (!skipOuterClasses) {
                    enclosingOwner = this.readClass(v + 6, c);
                    int item = this.readUnsignedShort(v + 8);
                    if (item != 0) {
                        enclosingName = this.readUTF8(this.items[item], c);
                        enclosingDesc = this.readUTF8(this.items[item] + 2, c);
                    }
                }
            } else if ("Signature".equals(attrName)) {
                if (includeHeader) {
                    signature = this.readUTF8(v + 6, c);
                }
            } else if (includeClassAnnotations && "RuntimeVisibleAnnotations".equals(attrName)) {
                anns = v + 6;
            } else if ("Deprecated".equals(attrName)) {
                access |= 0x20000;
            } else if ("Synthetic".equals(attrName)) {
                access |= 0x1000;
            } else if ("SourceDebugExtension".equals(attrName)) {
                if (!skipDebug) {
                    int len = this.readInt(v + 2);
                    sourceDebug = this.readUTF(v + 6, len, new char[len]);
                }
            } else if (includeClassAnnotations && "RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = v + 6;
            } else if (!skipUnknownAttributes && (attr = this.readAttribute(attrs, attrName, v + 6, this.readInt(v + 2), c, -1, null)) != null) {
                attr.next = cattrs;
                cattrs = attr;
            }
            v += 6 + this.readInt(v + 2);
            --i;
        }
        if (includeHeader) {
            classVisitor.visit(this.readInt(4), access, name, signature, superClassName, implementedItfs);
        }
        if (!(skipDebug || sourceFile == null && sourceDebug == null)) {
            classVisitor.visitSource(sourceFile, sourceDebug);
        }
        if (enclosingOwner != null && !skipOuterClasses) {
            classVisitor.visitOuterClass(enclosingOwner, enclosingName, enclosingDesc);
        }
        if (includeClassAnnotations) {
            for (i = 1; i >= 0; --i) {
                int n = v = i == 0 ? ianns : anns;
                if (v == 0) continue;
                j = this.readUnsignedShort(v);
                v += 2;
                while (j > 0) {
                    v = this.readAnnotationValues(v + 2, c, true, classVisitor.visitAnnotation(this.readUTF8(v, c), i != 0));
                    --j;
                }
            }
        }
        if (!skipUnknownAttributes) {
            while (cattrs != null) {
                attr = cattrs.next;
                cattrs.next = null;
                classVisitor.visitAttribute(cattrs);
                cattrs = attr;
            }
        }
        if (w != 0 && !skipInnerClasses) {
            i = this.readUnsignedShort(w);
            w += 2;
            while (i > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(w) == 0 ? null : this.readClass(w, c), this.readUnsignedShort(w + 2) == 0 ? null : this.readClass(w + 2, c), this.readUnsignedShort(w + 4) == 0 ? null : this.readUTF8(w + 4, c), this.readUnsignedShort(w + 6));
                w += 8;
                --i;
            }
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            u = this.readField(classVisitor, flags, attrs, c, u);
            --i;
        }
        i = this.readUnsignedShort(u);
        u += 2;
        while (i > 0) {
            u = this.readMethod(classVisitor, flags, attrs, c, u);
            --i;
        }
        classVisitor.visitEnd();
    }

    public int readMethod(ClassVisitor classVisitor, int flags, Attribute[] attrs, char[] c, int u) {
        MethodVisitor mv;
        Attribute attr;
        int byteCodeIndex = u;
        if (c == null) {
            c = new char[this.maxStringLength];
        }
        byte[] b = this.b;
        boolean skipCode = (flags & 1) != 0;
        boolean unzip = (flags & 8) != 0;
        boolean skipDebug = (flags & 8) != 0;
        boolean includeMethodOverview = (flags & 0x2000) != 0;
        boolean includeMethodAnnotations = (flags & 0x4000) != 0;
        boolean includeMethodParameterAnnotations = (flags & 0x8000) != 0;
        boolean includeAnnotationDefaultValues = (flags & 0x20000) != 0;
        boolean includeMethodUnknownAttributes = (flags & 0x10000) != 0;
        int u0 = u + 6;
        int access = 0;
        String name = null;
        String desc = null;
        if (includeMethodOverview) {
            access = this.readUnsignedShort(u);
            name = this.readUTF8(u + 2, c);
            desc = this.readUTF8(u + 4, c);
        } else if (includeMethodParameterAnnotations) {
            desc = this.readUTF8(u + 4, c);
        }
        String signature = null;
        int anns = 0;
        int ianns = 0;
        int dann = 0;
        int mpanns = 0;
        int impanns = 0;
        Attribute cattrs = null;
        int v = 0;
        int w = 0;
        int k = 0;
        int j = this.readUnsignedShort(u + 6);
        u += 8;
        while (j > 0) {
            String attrName = this.readUTF8(u, c);
            int attrSize = this.readInt(u + 2);
            u += 6;
            if ("Code".equals(attrName)) {
                if (!skipCode) {
                    v = u;
                }
            } else if ("Exceptions".equals(attrName)) {
                w = u;
            } else if ("Signature".equals(attrName)) {
                if (includeMethodOverview) {
                    signature = this.readUTF8(u, c);
                }
            } else if ("Deprecated".equals(attrName)) {
                if (includeMethodOverview) {
                    access |= 0x20000;
                }
            } else if (includeMethodAnnotations && "RuntimeVisibleAnnotations".equals(attrName)) {
                anns = u;
            } else if ("AnnotationDefault".equals(attrName)) {
                dann = u;
            } else if ("Synthetic".equals(attrName)) {
                if (includeMethodOverview) {
                    access |= 0x1000;
                }
            } else if (includeMethodAnnotations && "RuntimeInvisibleAnnotations".equals(attrName)) {
                ianns = u;
            } else if (includeMethodParameterAnnotations && "RuntimeVisibleParameterAnnotations".equals(attrName)) {
                mpanns = u;
            } else if (includeMethodParameterAnnotations && "RuntimeInvisibleParameterAnnotations".equals(attrName)) {
                impanns = u;
            } else if (includeMethodUnknownAttributes && (attr = this.readAttribute(attrs, attrName, u, attrSize, c, -1, null)) != null) {
                attr.next = cattrs;
                cattrs = attr;
            }
            u += attrSize;
            --j;
        }
        String[] exceptions = null;
        if (includeMethodOverview) {
            if (w == 0) {
                exceptions = null;
            } else {
                exceptions = new String[this.readUnsignedShort(w)];
                w += 2;
                for (j = 0; j < exceptions.length; ++j) {
                    exceptions[j] = this.readClass(w, c);
                    w += 2;
                }
            }
        }
        if ((mv = classVisitor.visitMethod(access, name, desc, signature, exceptions, byteCodeIndex)) != null) {
            if (mv instanceof MethodWriter) {
                MethodWriter mw = (MethodWriter)mv;
                if (mw.cw.cr == this && signature == mw.signature) {
                    boolean sameExceptions = false;
                    if (exceptions == null) {
                        sameExceptions = mw.exceptionCount == 0;
                    } else if (exceptions.length == mw.exceptionCount) {
                        sameExceptions = true;
                        for (j = exceptions.length - 1; j >= 0; --j) {
                            if (mw.exceptions[j] == this.readUnsignedShort(w -= 2)) continue;
                            sameExceptions = false;
                            break;
                        }
                    }
                    if (sameExceptions) {
                        mw.classReaderOffset = u0;
                        mw.classReaderLength = u - u0;
                        return u;
                    }
                }
            }
            if (includeAnnotationDefaultValues && dann != 0) {
                AnnotationVisitor dv = mv.visitAnnotationDefault();
                this.readAnnotationValue(dann, c, null, dv);
                if (dv != null) {
                    dv.visitEnd();
                }
            }
            if (includeMethodAnnotations) {
                for (j = 1; j >= 0; --j) {
                    int n = w = j == 0 ? ianns : anns;
                    if (w == 0) continue;
                    k = this.readUnsignedShort(w);
                    w += 2;
                    while (k > 0) {
                        w = this.readAnnotationValues(w + 2, c, true, mv.visitAnnotation(this.readUTF8(w, c), j != 0));
                        --k;
                    }
                }
            }
            if (includeMethodParameterAnnotations && mpanns != 0) {
                this.readParameterAnnotations(mpanns, desc, c, true, mv);
            }
            if (includeMethodParameterAnnotations && impanns != 0) {
                this.readParameterAnnotations(impanns, desc, c, false, mv);
            }
            if (includeMethodUnknownAttributes) {
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    mv.visitAttribute(cattrs);
                    cattrs = attr;
                }
            }
        }
        if (mv != null && v != 0) {
            int label;
            int maxStack = this.readUnsignedShort(v);
            int maxLocals = this.readUnsignedShort(v + 2);
            int codeLength = this.readInt(v + 4);
            int codeStart = v += 8;
            int codeEnd = v + codeLength;
            mv.visitCode();
            Label[] labels = new Label[codeLength + 2];
            this.readLabel(codeLength + 1, labels);
            block42: while (v < codeEnd) {
                w = v - codeStart;
                int opcode = b[v] & 0xFF;
                switch (ClassWriter.TYPE[opcode]) {
                    case 0: 
                    case 4: {
                        ++v;
                        continue block42;
                    }
                    case 8: {
                        this.readLabel(w + this.readShort(v + 1), labels);
                        v += 3;
                        continue block42;
                    }
                    case 9: {
                        this.readLabel(w + this.readInt(v + 1), labels);
                        v += 5;
                        continue block42;
                    }
                    case 16: {
                        opcode = b[v + 1] & 0xFF;
                        if (opcode == 132) {
                            v += 6;
                            continue block42;
                        }
                        v += 4;
                        continue block42;
                    }
                    case 13: {
                        v = v + 4 - (w & 3);
                        this.readLabel(w + this.readInt(v), labels);
                        j = this.readInt(v + 8) - this.readInt(v + 4) + 1;
                        v += 12;
                        while (j > 0) {
                            this.readLabel(w + this.readInt(v), labels);
                            v += 4;
                            --j;
                        }
                        continue block42;
                    }
                    case 14: {
                        v = v + 4 - (w & 3);
                        this.readLabel(w + this.readInt(v), labels);
                        j = this.readInt(v + 4);
                        v += 8;
                        while (j > 0) {
                            this.readLabel(w + this.readInt(v + 4), labels);
                            v += 8;
                            --j;
                        }
                        continue block42;
                    }
                    case 1: 
                    case 3: 
                    case 10: {
                        v += 2;
                        continue block42;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        v += 3;
                        continue block42;
                    }
                    case 7: {
                        v += 5;
                        continue block42;
                    }
                }
                v += 4;
            }
            j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                Label start = this.readLabel(this.readUnsignedShort(v), labels);
                Label end = this.readLabel(this.readUnsignedShort(v + 2), labels);
                Label handler = this.readLabel(this.readUnsignedShort(v + 4), labels);
                int type = this.readUnsignedShort(v + 6);
                if (type == 0) {
                    mv.visitTryCatchBlock(start, end, handler, null);
                } else {
                    mv.visitTryCatchBlock(start, end, handler, this.readUTF8(this.items[type], c));
                }
                v += 8;
                --j;
            }
            int varTable = 0;
            int varTypeTable = 0;
            int stackMap = 0;
            int frameCount = 0;
            int frameMode = 0;
            int frameOffset = 0;
            int frameLocalCount = 0;
            int frameLocalDiff = 0;
            int frameStackCount = 0;
            Object[] frameLocal = null;
            Object[] frameStack = null;
            boolean zip = true;
            cattrs = null;
            j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                String attrName = this.readUTF8(v, c);
                if ("LocalVariableTable".equals(attrName)) {
                    if (!skipDebug) {
                        varTable = v + 6;
                        w = v + 8;
                        for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                            label = this.readUnsignedShort(w);
                            if (labels[label] == null) {
                                this.readLabel((int)label, (Label[])labels).status |= 1;
                            }
                            if (labels[label += this.readUnsignedShort(w + 2)] == null) {
                                this.readLabel((int)label, (Label[])labels).status |= 1;
                            }
                            w += 10;
                        }
                    }
                } else if ("LocalVariableTypeTable".equals(attrName)) {
                    varTypeTable = v + 6;
                } else if ("LineNumberTable".equals(attrName)) {
                    if (!skipDebug) {
                        w = v + 8;
                        for (k = this.readUnsignedShort(v + 6); k > 0; --k) {
                            label = this.readUnsignedShort(w);
                            if (labels[label] == null) {
                                this.readLabel((int)label, (Label[])labels).status |= 1;
                            }
                            labels[label].line = this.readUnsignedShort(w + 2);
                            w += 4;
                        }
                    }
                } else if ("StackMapTable".equals(attrName)) {
                    if ((flags & 4) == 0) {
                        stackMap = v + 8;
                        frameCount = this.readUnsignedShort(v + 6);
                    }
                } else if ("StackMap".equals(attrName)) {
                    if ((flags & 4) == 0) {
                        stackMap = v + 8;
                        frameCount = this.readUnsignedShort(v + 6);
                        zip = false;
                    }
                } else {
                    for (k = 0; k < attrs.length; ++k) {
                        if (!attrs[k].type.equals(attrName) || (attr = attrs[k].read(this, v + 6, this.readInt(v + 2), c, codeStart - 8, labels)) == null) continue;
                        attr.next = cattrs;
                        cattrs = attr;
                    }
                }
                v += 6 + this.readInt(v + 2);
                --j;
            }
            if (stackMap != 0) {
                frameLocal = new Object[maxLocals];
                frameStack = new Object[maxStack];
                if (unzip) {
                    int local = 0;
                    if ((access & 8) == 0) {
                        frameLocal[local++] = "<init>".equals(name) ? Opcodes.UNINITIALIZED_THIS : this.readClass(this.header + 2, c);
                    }
                    j = 1;
                    block50: while (true) {
                        k = j;
                        switch (desc.charAt(j++)) {
                            case 'B': 
                            case 'C': 
                            case 'I': 
                            case 'S': 
                            case 'Z': {
                                frameLocal[local++] = Opcodes.INTEGER;
                                continue block50;
                            }
                            case 'F': {
                                frameLocal[local++] = Opcodes.FLOAT;
                                continue block50;
                            }
                            case 'J': {
                                frameLocal[local++] = Opcodes.LONG;
                                continue block50;
                            }
                            case 'D': {
                                frameLocal[local++] = Opcodes.DOUBLE;
                                continue block50;
                            }
                            case '[': {
                                while (desc.charAt(j) == '[') {
                                    ++j;
                                }
                                if (desc.charAt(j) == 'L') {
                                    ++j;
                                    while (desc.charAt(j) != ';') {
                                        ++j;
                                    }
                                }
                                frameLocal[local++] = desc.substring(k, ++j);
                                continue block50;
                            }
                            case 'L': {
                                while (desc.charAt(j) != ';') {
                                    ++j;
                                }
                                frameLocal[local++] = desc.substring(k + 1, j++);
                                continue block50;
                            }
                        }
                        break;
                    }
                    frameLocalCount = local;
                }
                frameOffset = -1;
            }
            v = codeStart;
            block54: while (v < codeEnd) {
                w = v - codeStart;
                Label l = labels[w];
                if (l != null) {
                    mv.visitLabel(l);
                    if (!skipDebug && l.line > 0) {
                        mv.visitLineNumber(l.line, l);
                    }
                }
                while (frameLocal != null && (frameOffset == w || frameOffset == -1)) {
                    if (!zip || unzip) {
                        mv.visitFrame(-1, frameLocalCount, frameLocal, frameStackCount, frameStack);
                    } else if (frameOffset != -1) {
                        mv.visitFrame(frameMode, frameLocalDiff, frameLocal, frameStackCount, frameStack);
                    }
                    if (frameCount > 0) {
                        int delta;
                        int tag;
                        if (zip) {
                            tag = b[stackMap++] & 0xFF;
                        } else {
                            tag = 255;
                            frameOffset = -1;
                        }
                        frameLocalDiff = 0;
                        if (tag < 64) {
                            delta = tag;
                            frameMode = 3;
                            frameStackCount = 0;
                        } else if (tag < 128) {
                            delta = tag - 64;
                            stackMap = this.readFrameType(frameStack, 0, stackMap, c, labels);
                            frameMode = 4;
                            frameStackCount = 1;
                        } else {
                            delta = this.readUnsignedShort(stackMap);
                            stackMap += 2;
                            if (tag == 247) {
                                stackMap = this.readFrameType(frameStack, 0, stackMap, c, labels);
                                frameMode = 4;
                                frameStackCount = 1;
                            } else if (tag >= 248 && tag < 251) {
                                frameMode = 2;
                                frameLocalDiff = 251 - tag;
                                frameLocalCount -= frameLocalDiff;
                                frameStackCount = 0;
                            } else if (tag == 251) {
                                frameMode = 3;
                                frameStackCount = 0;
                            } else if (tag < 255) {
                                j = unzip ? frameLocalCount : 0;
                                for (k = tag - 251; k > 0; --k) {
                                    stackMap = this.readFrameType(frameLocal, j++, stackMap, c, labels);
                                }
                                frameMode = 1;
                                frameLocalDiff = tag - 251;
                                frameLocalCount += frameLocalDiff;
                                frameStackCount = 0;
                            } else {
                                int n;
                                frameMode = 0;
                                frameLocalDiff = frameLocalCount = this.readUnsignedShort(stackMap);
                                stackMap += 2;
                                j = 0;
                                for (n = frameLocalCount; n > 0; --n) {
                                    stackMap = this.readFrameType(frameLocal, j++, stackMap, c, labels);
                                }
                                n = frameStackCount = this.readUnsignedShort(stackMap);
                                stackMap += 2;
                                j = 0;
                                while (n > 0) {
                                    stackMap = this.readFrameType(frameStack, j++, stackMap, c, labels);
                                    --n;
                                }
                            }
                        }
                        this.readLabel(frameOffset += delta + 1, labels);
                        --frameCount;
                        continue;
                    }
                    frameLocal = null;
                }
                int opcode = b[v] & 0xFF;
                switch (ClassWriter.TYPE[opcode]) {
                    case 0: {
                        mv.visitInsn(opcode);
                        ++v;
                        continue block54;
                    }
                    case 4: {
                        if (opcode > 54) {
                            mv.visitVarInsn(54 + ((opcode -= 59) >> 2), opcode & 3);
                        } else {
                            mv.visitVarInsn(21 + ((opcode -= 26) >> 2), opcode & 3);
                        }
                        ++v;
                        continue block54;
                    }
                    case 8: {
                        mv.visitJumpInsn(opcode, labels[w + this.readShort(v + 1)]);
                        v += 3;
                        continue block54;
                    }
                    case 9: {
                        mv.visitJumpInsn(opcode - 33, labels[w + this.readInt(v + 1)]);
                        v += 5;
                        continue block54;
                    }
                    case 16: {
                        opcode = b[v + 1] & 0xFF;
                        if (opcode == 132) {
                            mv.visitIincInsn(this.readUnsignedShort(v + 2), this.readShort(v + 4));
                            v += 6;
                            continue block54;
                        }
                        mv.visitVarInsn(opcode, this.readUnsignedShort(v + 2));
                        v += 4;
                        continue block54;
                    }
                    case 13: {
                        v = v + 4 - (w & 3);
                        label = w + this.readInt(v);
                        int min = this.readInt(v + 4);
                        int max = this.readInt(v + 8);
                        v += 12;
                        Label[] table = new Label[max - min + 1];
                        for (j = 0; j < table.length; ++j) {
                            table[j] = labels[w + this.readInt(v)];
                            v += 4;
                        }
                        mv.visitTableSwitchInsn(min, max, labels[label], table);
                        continue block54;
                    }
                    case 14: {
                        v = v + 4 - (w & 3);
                        label = w + this.readInt(v);
                        j = this.readInt(v + 4);
                        v += 8;
                        int[] keys = new int[j];
                        Label[] values = new Label[j];
                        for (j = 0; j < keys.length; ++j) {
                            keys[j] = this.readInt(v);
                            values[j] = labels[w + this.readInt(v + 4)];
                            v += 8;
                        }
                        mv.visitLookupSwitchInsn(labels[label], keys, values);
                        continue block54;
                    }
                    case 3: {
                        mv.visitVarInsn(opcode, b[v + 1] & 0xFF);
                        v += 2;
                        continue block54;
                    }
                    case 1: {
                        mv.visitIntInsn(opcode, b[v + 1]);
                        v += 2;
                        continue block54;
                    }
                    case 2: {
                        mv.visitIntInsn(opcode, this.readShort(v + 1));
                        v += 3;
                        continue block54;
                    }
                    case 10: {
                        mv.visitLdcInsn(this.readConst(b[v + 1] & 0xFF, c));
                        v += 2;
                        continue block54;
                    }
                    case 11: {
                        mv.visitLdcInsn(this.readConst(this.readUnsignedShort(v + 1), c));
                        v += 3;
                        continue block54;
                    }
                    case 6: 
                    case 7: {
                        String iowner;
                        int cpIndex = this.items[this.readUnsignedShort(v + 1)];
                        if (opcode == 186) {
                            iowner = "java/lang/dyn/Dynamic";
                        } else {
                            iowner = this.readClass(cpIndex, c);
                            cpIndex = this.items[this.readUnsignedShort(cpIndex + 2)];
                        }
                        String iname = this.readUTF8(cpIndex, c);
                        String idesc = this.readUTF8(cpIndex + 2, c);
                        if (opcode < 182) {
                            mv.visitFieldInsn(opcode, iowner, iname, idesc);
                        } else {
                            mv.visitMethodInsn(opcode, iowner, iname, idesc);
                        }
                        if (opcode == 185 || opcode == 186) {
                            v += 5;
                            continue block54;
                        }
                        v += 3;
                        continue block54;
                    }
                    case 5: {
                        mv.visitTypeInsn(opcode, this.readClass(v + 1, c));
                        v += 3;
                        continue block54;
                    }
                    case 12: {
                        mv.visitIincInsn(b[v + 1] & 0xFF, b[v + 2]);
                        v += 3;
                        continue block54;
                    }
                }
                mv.visitMultiANewArrayInsn(this.readClass(v + 1, c), b[v + 3] & 0xFF);
                v += 4;
            }
            Label l = labels[codeEnd - codeStart];
            if (l != null) {
                mv.visitLabel(l);
            }
            if (!skipDebug && varTable != 0) {
                int[] typeTable = null;
                if (varTypeTable != 0) {
                    k = this.readUnsignedShort(varTypeTable) * 3;
                    w = varTypeTable + 2;
                    typeTable = new int[k];
                    while (k > 0) {
                        typeTable[--k] = w + 6;
                        typeTable[--k] = this.readUnsignedShort(w + 8);
                        typeTable[--k] = this.readUnsignedShort(w);
                        w += 10;
                    }
                }
                w = varTable + 2;
                for (k = this.readUnsignedShort(varTable); k > 0; --k) {
                    int start = this.readUnsignedShort(w);
                    int length = this.readUnsignedShort(w + 2);
                    int index = this.readUnsignedShort(w + 8);
                    String vsignature = null;
                    if (typeTable != null) {
                        for (int a = 0; a < typeTable.length; a += 3) {
                            if (typeTable[a] != start || typeTable[a + 1] != index) continue;
                            vsignature = this.readUTF8(typeTable[a + 2], c);
                            break;
                        }
                    }
                    mv.visitLocalVariable(this.readUTF8(w + 4, c), this.readUTF8(w + 6, c), vsignature, labels[start], labels[start + length], index);
                    w += 10;
                }
            }
            while (cattrs != null) {
                attr = cattrs.next;
                cattrs.next = null;
                mv.visitAttribute(cattrs);
                cattrs = attr;
            }
            mv.visitMaxs(maxStack, maxLocals);
        }
        if (mv != null) {
            mv.visitEnd();
        }
        return u;
    }

    public int readField(ClassVisitor classVisitor, int flags, Attribute[] attrs, char[] c, int u) {
        Attribute attr;
        int byteCodeIndex = u;
        if (c == null) {
            c = new char[this.maxStringLength];
        }
        boolean includeFieldOverview = (flags & 0x400) != 0;
        boolean includeFieldAnnotations = (flags & 0x800) != 0;
        boolean includeFieldUnknownAttributes = (flags & 0x1000) != 0;
        int access = 0;
        String name = null;
        String desc = null;
        if (includeFieldOverview) {
            access = this.readUnsignedShort(u);
            desc = this.readUTF8(u + 4, c);
            name = this.readUTF8(u + 2, c);
        }
        int fieldValueItem = 0;
        String signature = null;
        int anns = 0;
        int ianns = 0;
        Attribute cattrs = null;
        int j = this.readUnsignedShort(u + 6);
        u += 8;
        while (j > 0) {
            String attrName = this.readUTF8(u, c);
            if ("ConstantValue".equals(attrName)) {
                if (includeFieldOverview) {
                    fieldValueItem = this.readUnsignedShort(u + 6);
                }
            } else if ("Signature".equals(attrName)) {
                if (includeFieldOverview) {
                    signature = this.readUTF8(u + 6, c);
                }
            } else if ("Deprecated".equals(attrName)) {
                if (includeFieldOverview) {
                    access |= 0x20000;
                }
            } else if ("Synthetic".equals(attrName)) {
                if (includeFieldOverview) {
                    access |= 0x1000;
                }
            } else if ("RuntimeVisibleAnnotations".equals(attrName)) {
                if (includeFieldAnnotations) {
                    anns = u + 6;
                }
            } else if ("RuntimeInvisibleAnnotations".equals(attrName)) {
                if (includeFieldAnnotations) {
                    ianns = u + 6;
                }
            } else if (includeFieldUnknownAttributes && (attr = this.readAttribute(attrs, attrName, u + 6, this.readInt(u + 2), c, -1, null)) != null) {
                attr.next = cattrs;
                cattrs = attr;
            }
            u += 6 + this.readInt(u + 2);
            --j;
        }
        FieldVisitor fv = classVisitor.visitField(access, name, desc, signature, fieldValueItem == 0 ? null : this.readConst(fieldValueItem, c), byteCodeIndex);
        if (fv != null) {
            if (includeFieldAnnotations) {
                for (j = 1; j >= 0; --j) {
                    int v;
                    int n = v = j == 0 ? ianns : anns;
                    if (v == 0) continue;
                    int k = this.readUnsignedShort(v);
                    v += 2;
                    while (k > 0) {
                        v = this.readAnnotationValues(v + 2, c, true, fv.visitAnnotation(this.readUTF8(v, c), j != 0));
                        --k;
                    }
                }
            }
            if (includeFieldUnknownAttributes) {
                while (cattrs != null) {
                    attr = cattrs.next;
                    cattrs.next = null;
                    fv.visitAttribute(cattrs);
                    cattrs = attr;
                }
            }
            fv.visitEnd();
        }
        return u;
    }

    private void readParameterAnnotations(int v, String desc, char[] buf, boolean visible, MethodVisitor mv) {
        AnnotationVisitor av;
        int i;
        int n = this.b[v++] & 0xFF;
        int synthetics = Type.getArgumentTypes(desc).length - n;
        for (i = 0; i < synthetics; ++i) {
            av = mv.visitParameterAnnotation(i, "Ljava/lang/Synthetic;", false);
            if (av == null) continue;
            av.visitEnd();
        }
        while (i < n + synthetics) {
            int j = this.readUnsignedShort(v);
            v += 2;
            while (j > 0) {
                av = mv.visitParameterAnnotation(i, this.readUTF8(v, buf), visible);
                v = this.readAnnotationValues(v + 2, buf, true, av);
                --j;
            }
            ++i;
        }
    }

    private int readAnnotationValues(int v, char[] buf, boolean named, AnnotationVisitor av) {
        int i = this.readUnsignedShort(v);
        v += 2;
        if (named) {
            while (i > 0) {
                v = this.readAnnotationValue(v + 2, buf, this.readUTF8(v, buf), av);
                --i;
            }
        } else {
            while (i > 0) {
                v = this.readAnnotationValue(v, buf, null, av);
                --i;
            }
        }
        if (av != null) {
            av.visitEnd();
        }
        return v;
    }

    private int readAnnotationValue(int v, char[] buf, String name, AnnotationVisitor av) {
        if (av == null) {
            switch (this.b[v] & 0xFF) {
                case 101: {
                    return v + 5;
                }
                case 64: {
                    return this.readAnnotationValues(v + 3, buf, true, null);
                }
                case 91: {
                    return this.readAnnotationValues(v + 1, buf, false, null);
                }
            }
            return v + 3;
        }
        block5 : switch (this.b[v++] & 0xFF) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                av.visit(name, this.readConst(this.readUnsignedShort(v), buf));
                v += 2;
                break;
            }
            case 66: {
                av.visit(name, new Byte((byte)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 90: {
                av.visit(name, this.readInt(this.items[this.readUnsignedShort(v)]) == 0 ? Boolean.FALSE : Boolean.TRUE);
                v += 2;
                break;
            }
            case 83: {
                av.visit(name, new Short((short)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 67: {
                av.visit(name, new Character((char)this.readInt(this.items[this.readUnsignedShort(v)])));
                v += 2;
                break;
            }
            case 115: {
                av.visit(name, this.readUTF8(v, buf));
                v += 2;
                break;
            }
            case 101: {
                av.visitEnum(name, this.readUTF8(v, buf), this.readUTF8(v + 2, buf));
                v += 4;
                break;
            }
            case 99: {
                av.visit(name, Type.getType(this.readUTF8(v, buf)));
                v += 2;
                break;
            }
            case 64: {
                v = this.readAnnotationValues(v + 2, buf, true, av.visitAnnotation(name, this.readUTF8(v, buf)));
                break;
            }
            case 91: {
                int size = this.readUnsignedShort(v);
                v += 2;
                if (size == 0) {
                    return this.readAnnotationValues(v - 2, buf, false, av.visitArray(name));
                }
                switch (this.b[v++] & 0xFF) {
                    case 66: {
                        byte[] bv = new byte[size];
                        for (int i = 0; i < size; ++i) {
                            bv[i] = (byte)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, bv);
                        --v;
                        break block5;
                    }
                    case 90: {
                        boolean[] zv = new boolean[size];
                        for (int i = 0; i < size; ++i) {
                            zv[i] = this.readInt(this.items[this.readUnsignedShort(v)]) != 0;
                            v += 3;
                        }
                        av.visit(name, zv);
                        --v;
                        break block5;
                    }
                    case 83: {
                        short[] sv = new short[size];
                        for (int i = 0; i < size; ++i) {
                            sv[i] = (short)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, sv);
                        --v;
                        break block5;
                    }
                    case 67: {
                        char[] cv = new char[size];
                        for (int i = 0; i < size; ++i) {
                            cv[i] = (char)this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, cv);
                        --v;
                        break block5;
                    }
                    case 73: {
                        int[] iv = new int[size];
                        for (int i = 0; i < size; ++i) {
                            iv[i] = this.readInt(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, iv);
                        --v;
                        break block5;
                    }
                    case 74: {
                        long[] lv = new long[size];
                        for (int i = 0; i < size; ++i) {
                            lv[i] = this.readLong(this.items[this.readUnsignedShort(v)]);
                            v += 3;
                        }
                        av.visit(name, lv);
                        --v;
                        break block5;
                    }
                    case 70: {
                        float[] fv = new float[size];
                        for (int i = 0; i < size; ++i) {
                            fv[i] = Float.intBitsToFloat(this.readInt(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name, fv);
                        --v;
                        break block5;
                    }
                    case 68: {
                        double[] dv = new double[size];
                        for (int i = 0; i < size; ++i) {
                            dv[i] = Double.longBitsToDouble(this.readLong(this.items[this.readUnsignedShort(v)]));
                            v += 3;
                        }
                        av.visit(name, dv);
                        --v;
                        break block5;
                    }
                }
                v = this.readAnnotationValues(v - 3, buf, false, av.visitArray(name));
            }
        }
        return v;
    }

    private int readFrameType(Object[] frame, int index, int v, char[] buf, Label[] labels) {
        int type = this.b[v++] & 0xFF;
        switch (type) {
            case 0: {
                frame[index] = Opcodes.TOP;
                break;
            }
            case 1: {
                frame[index] = Opcodes.INTEGER;
                break;
            }
            case 2: {
                frame[index] = Opcodes.FLOAT;
                break;
            }
            case 3: {
                frame[index] = Opcodes.DOUBLE;
                break;
            }
            case 4: {
                frame[index] = Opcodes.LONG;
                break;
            }
            case 5: {
                frame[index] = Opcodes.NULL;
                break;
            }
            case 6: {
                frame[index] = Opcodes.UNINITIALIZED_THIS;
                break;
            }
            case 7: {
                frame[index] = this.readClass(v, buf);
                v += 2;
                break;
            }
            default: {
                frame[index] = this.readLabel(this.readUnsignedShort(v), labels);
                v += 2;
            }
        }
        return v;
    }

    protected Label readLabel(int offset, Label[] labels) {
        if (labels[offset] == null) {
            labels[offset] = new Label();
        }
        return labels[offset];
    }

    private Attribute readAttribute(Attribute[] attrs, String type, int off, int len, char[] buf, int codeOff, Label[] labels) {
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].type.equals(type)) continue;
            return attrs[i].read(this, off, len, buf, codeOff, labels);
        }
        return new Attribute(type).read(this, off, len, null, -1, null);
    }

    public int getItem(int item) {
        return this.items[item];
    }

    public int readByte(int index) {
        return this.b[index] & 0xFF;
    }

    public int readUnsignedShort(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 8 | b[index + 1] & 0xFF;
    }

    public short readShort(int index) {
        byte[] b = this.b;
        return (short)((b[index] & 0xFF) << 8 | b[index + 1] & 0xFF);
    }

    public int readInt(int index) {
        byte[] b = this.b;
        return (b[index] & 0xFF) << 24 | (b[index + 1] & 0xFF) << 16 | (b[index + 2] & 0xFF) << 8 | b[index + 3] & 0xFF;
    }

    public long readLong(int index) {
        long l1 = this.readInt(index);
        long l0 = (long)this.readInt(index + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUTF8(int index, char[] buf) {
        int item = this.readUnsignedShort(index);
        String s = this.strings[item];
        if (s != null) {
            return s;
        }
        index = this.items[item];
        this.strings[item] = this.readUTF(index + 2, this.readUnsignedShort(index), buf);
        return this.strings[item];
    }

    private String readUTF(int index, int utfLen, char[] buf) {
        int endIndex = index + utfLen;
        byte[] b = this.b;
        int strLen = 0;
        int st = 0;
        int cc = 0;
        while (index < endIndex) {
            int c = b[index++];
            switch (st) {
                case 0: {
                    if ((c &= 0xFF) < 128) {
                        buf[strLen++] = (char)c;
                        break;
                    }
                    if (c < 224 && c > 191) {
                        cc = (char)(c & 0x1F);
                        st = 1;
                        break;
                    }
                    cc = (char)(c & 0xF);
                    st = 2;
                    break;
                }
                case 1: {
                    buf[strLen++] = (char)(cc << 6 | c & 0x3F);
                    st = 0;
                    break;
                }
                case 2: {
                    cc = (char)(cc << 6 | c & 0x3F);
                    st = 1;
                }
            }
        }
        return new String(buf, 0, strLen);
    }

    public String readClass(int index, char[] buf) {
        return this.readUTF8(this.items[this.readUnsignedShort(index)], buf);
    }

    public Object readConst(int item, char[] buf) {
        int index = this.items[item];
        switch (this.b[index - 1]) {
            case 3: {
                return new Integer(this.readInt(index));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(index)));
            }
            case 5: {
                return new Long(this.readLong(index));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(index)));
            }
            case 7: {
                return Type.getObjectType(this.readUTF8(index, buf));
            }
        }
        return this.readUTF8(index, buf);
    }
}

