/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.AnnotationValueFactory;
import org.jboss.reflect.plugins.AnnotationValueImpl;
import org.jboss.reflect.plugins.EnumConstantInfoImpl;
import org.jboss.reflect.plugins.GenericsUtil;
import org.jboss.reflect.plugins.TypeVariableAware;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.plugins.javassist.JavassistAnnotationInfo;
import org.jboss.reflect.plugins.javassist.JavassistArrayInfoImpl;
import org.jboss.reflect.plugins.javassist.JavassistEnumInfo;
import org.jboss.reflect.plugins.javassist.JavassistHelper;
import org.jboss.reflect.plugins.javassist.JavassistParameterizedClassInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeVariableSpy;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.plugins.javassist.SecurityActions;
import org.jboss.reflect.plugins.javassist.classpool.ClassPoolFactory;
import org.jboss.reflect.plugins.javassist.classpool.DefaultClassPoolFactory;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.DelegateClassInfo;
import org.jboss.reflect.spi.MutableClassInfo;
import org.jboss.reflect.spi.MutableTypeInfoFactory;
import org.jboss.reflect.spi.NumberInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.WeakClassCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistTypeInfoFactoryImpl
extends WeakClassCache<TypeInfo>
implements MutableTypeInfoFactory,
AnnotationHelper {
    private static ClassPoolFactory poolFactory = DefaultClassPoolFactory.getInstance();
    private static ThreadLocal<Map<CtClass, TypeInfo>> results = new ThreadLocal();
    static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];

    JavassistTypeInfoFactoryImpl() {
    }

    public static ClassPoolFactory getPoolFactory() {
        return poolFactory;
    }

    public static void setPoolFactory(ClassPoolFactory classPoolFactory) {
        poolFactory = classPoolFactory;
    }

    public static NoClassDefFoundError raiseClassNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseClassNotFound(String name, ClassNotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class " + name);
        ex.initCause(e);
        throw ex;
    }

    public static NoClassDefFoundError raiseMethodNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchMethodError ex = new NoSuchMethodError("Unable to find method " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseFieldNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchFieldError ex = new NoSuchFieldError("Unable to find field " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    protected TypeInfo instantiate(Class clazz) {
        CtClass ctClass = this.getCtClass(clazz.getName(), clazz.getClassLoader());
        return this.instantiate(ctClass, clazz);
    }

    protected TypeInfo instantiate(CtClass ctClass, Class<?> clazz) {
        TypeInfo cached;
        boolean start = false;
        Map<CtClass, TypeInfo> tmp = results.get();
        if (tmp == null) {
            start = true;
            tmp = new HashMap<CtClass, TypeInfo>();
            results.set(tmp);
        }
        if ((cached = tmp.get(ctClass)) != null) {
            return cached;
        }
        try {
            if (ctClass.isArray()) {
                TypeInfo componentType = this.getTypeInfo(ctClass.getComponentType());
                JavassistArrayInfoImpl result = new JavassistArrayInfoImpl(this, ctClass, clazz, componentType);
                tmp.put(ctClass, result);
                JavassistArrayInfoImpl javassistArrayInfoImpl = result;
                return javassistArrayInfoImpl;
            }
            if (ctClass.isAnnotation()) {
                JavassistAnnotationInfo result = new JavassistAnnotationInfo(this, ctClass, clazz);
                tmp.put(ctClass, result);
                CtMethod[] methods = ctClass.getDeclaredMethods();
                AnnotationAttributeImpl[] atttributes = new AnnotationAttributeImpl[methods.length];
                for (int i = 0; i < methods.length; ++i) {
                    atttributes[i] = new AnnotationAttributeImpl(methods[i].getName(), this.getTypeInfo(methods[i].getReturnType()), null);
                }
                result.setAttributes(atttributes);
                JavassistAnnotationInfo i = result;
                return i;
            }
            if (ctClass.isEnum()) {
                JavassistEnumInfo enumInfo = new JavassistEnumInfo(this, ctClass, clazz);
                tmp.put(ctClass, enumInfo);
                CtField[] fields = ctClass.getFields();
                ArrayList<EnumConstantInfoImpl> constants = new ArrayList<EnumConstantInfoImpl>();
                for (CtField field : fields) {
                    if (!Modifier.isEnum((int)field.getModifiers())) continue;
                    AnnotationValue[] annotations = this.getAnnotations(field);
                    constants.add(new EnumConstantInfoImpl(field.getName(), enumInfo, annotations));
                }
                enumInfo.setEnumConstants(constants.toArray(new EnumConstantInfoImpl[constants.size()]));
                JavassistEnumInfo javassistEnumInfo = enumInfo;
                return javassistEnumInfo;
            }
            JavassistTypeInfo result = new JavassistTypeInfo(this, ctClass, clazz);
            tmp.put(ctClass, result);
            JavassistTypeInfo javassistTypeInfo = result;
            return javassistTypeInfo;
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (start) {
                results.remove();
            }
        }
    }

    protected TypeInfo getTypeInfo(CtClass ctClass) {
        try {
            String name = JavassistTypeInfoFactoryImpl.convertName(ctClass);
            ClassLoader cl = JavassistUtil.getClassLoader(ctClass);
            return this.getTypeInfo(name, cl);
        }
        catch (ClassNotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(ctClass.getName(), e);
        }
    }

    protected static String convertName(CtClass clazz) {
        CtClass temp = clazz;
        if (temp.isArray()) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            try {
                while (temp.isArray()) {
                    buffer.append('[');
                    temp = temp.getComponentType();
                }
                if (temp.isPrimitive()) {
                    CtPrimitiveType primitive = (CtPrimitiveType)temp;
                    buffer.append(Character.toString(primitive.getDescriptor()));
                } else {
                    buffer.append('L');
                    buffer.append(temp.getName());
                    buffer.append(';');
                }
                return buffer.toString();
            }
            catch (NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(clazz.getName(), e);
            }
        }
        return clazz.getName();
    }

    protected CtClass getCtClass(String name, ClassLoader classLoader) {
        try {
            return poolFactory.getPoolForLoader(classLoader).get(name);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(name, e);
        }
    }

    protected CtClass getCtClass(String name) {
        return this.getCtClass(name, null);
    }

    protected void generate(Class clazz, TypeInfo result) {
    }

    @Override
    public TypeInfo getTypeInfo(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        return (TypeInfo)this.get(clazz);
    }

    @Override
    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return this.get(name, cl);
    }

    @Override
    public TypeInfo getTypeInfo(Type type) {
        if (type instanceof Class) {
            return this.getTypeInfo((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getParameterizedType((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return this.getWildcardType((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.getGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof TypeVariable) {
            return this.getTypeVariable((TypeVariable)type);
        }
        throw new UnsupportedOperationException("Unknown type: " + type + " class=" + type.getClass());
    }

    public TypeInfo get(String name, ClassLoader cl) throws ClassNotFoundException {
        return this.get(name, cl, null);
    }

    public TypeInfo get(Class clazz) {
        try {
            ClassLoader cl = SecurityActions.getClassLoader(clazz);
            if (cl == null) {
                cl = SecurityActions.getContextClassLoader();
            }
            return this.get(clazz.getName(), cl, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + e.getMessage());
        }
    }

    protected TypeInfo get(String name, ClassLoader cl, Class<?> clazz) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        return this.get(null, clazz, name, cl, true);
    }

    protected TypeInfo get(CtClass ctClass) {
        if (ctClass == null) {
            throw new IllegalArgumentException("Null class");
        }
        try {
            return this.get(ctClass, null, ctClass.getName(), ctClass.getClassPool().getClassLoader(), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeInfo get(CtClass ctClass, Class<?> clazz, String name, ClassLoader cl, boolean delegateToReflectIfNotFound) throws ClassNotFoundException {
        ClassLoader realLoader;
        Map<String, WeakReference<TypeInfo>> classLoaderCache;
        TypeInfo result;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null class loader");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(name);
        if (primitive != null) {
            return primitive;
        }
        NumberInfo number = NumberInfo.valueOf(name);
        if (number != null) {
            NumberInfo numberInfo = number;
            synchronized (numberInfo) {
                if (number.getPhase() != NumberInfo.Phase.INITIALIZING) {
                    if (number.getPhase() != NumberInfo.Phase.COMPLETE) {
                        number.initializing();
                        Class<?> useClass = clazz;
                        try {
                            if (useClass == null) {
                                useClass = cl.loadClass(name);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                        number.setDelegate((TypeInfo)this.get(useClass));
                    }
                    return number;
                }
            }
        }
        if (name.charAt(0) == '[') {
            name = Descriptor.toClassName((String)name);
        }
        if ((result = this.getFromCache(name, classLoaderCache = this.getClassLoaderCache(cl))) != null) {
            return result;
        }
        boolean changedCache = false;
        try {
            if (ctClass == null && (realLoader = (ctClass = poolFactory.getPoolForLoader(cl).get(name)).getClassPool().getClassLoader()) != null && realLoader != cl) {
                changedCache = true;
                classLoaderCache = this.getClassLoaderCache(realLoader);
                result = this.getFromCache(name, classLoaderCache);
                if (result != null) {
                    return result;
                }
            }
            result = this.instantiate(ctClass, clazz);
        }
        catch (NotFoundException e) {
            if (delegateToReflectIfNotFound) {
                result = this.delegateToIntrospectionImplementation(cl, name);
            }
            throw new RuntimeException(e);
        }
        if (!changedCache && (realLoader = this.getClassLoader(result)) != cl) {
            classLoaderCache = this.getClassLoaderCache(realLoader);
        }
        WeakReference<TypeInfo> weak = new WeakReference<TypeInfo>(result);
        classLoaderCache.put(name, weak);
        return result;
    }

    private ClassLoader getClassLoader(final TypeInfo info) {
        if (System.getSecurityManager() == null) {
            return info.getClassLoader();
        }
        if (info instanceof JavassistTypeInfo) {
            return ((JavassistTypeInfo)info).getClassLoaderInternal();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return info.getClassLoader();
            }
        });
    }

    private TypeInfo delegateToIntrospectionImplementation(ClassLoader cl, String name) throws ClassNotFoundException {
        IntrospectionTypeInfoFactory factory = new IntrospectionTypeInfoFactory();
        return factory.getTypeInfo(name, cl);
    }

    private TypeInfo getFromCache(String name, Map<String, WeakReference<TypeInfo>> classLoaderCache) {
        TypeInfo result;
        WeakReference<TypeInfo> weak = classLoaderCache.get(name);
        if (weak != null && (result = (TypeInfo)weak.get()) != null) {
            CtClass clazz = this.getCtClass(result, false);
            if (clazz != null && clazz.isModified() && !this.compare(clazz, (ClassInfo)result)) {
                classLoaderCache.remove(name);
            }
            return result;
        }
        return null;
    }

    @Override
    public AnnotationValue[] getAnnotations(Object obj) {
        try {
            Object[] annotations;
            if (obj instanceof CtMember) {
                annotations = ((CtMember)obj).getAvailableAnnotations();
            } else if (obj instanceof CtClass) {
                annotations = ((CtClass)obj).getAvailableAnnotations();
            } else {
                throw new RuntimeException("Attempt was made to read annotations from unsupported type " + obj.getClass().getName() + ": " + obj);
            }
            if (annotations.length == 0) {
                return NO_ANNOTATIONS;
            }
            AnnotationValue[] annotationValues = new AnnotationValueImpl[annotations.length];
            for (int i = 0; i < annotations.length; ++i) {
                Class<? extends Annotation> clazz = ((Annotation)annotations[i]).annotationType();
                AnnotationInfo info = (AnnotationInfo)this.getTypeInfo(clazz);
                annotationValues[i] = AnnotationValueFactory.createAnnotationValue(this, this, info, annotations[i]);
            }
            return annotationValues;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not read annotations for " + (obj instanceof CtClass ? ((CtClass)obj).getName() : obj.toString()), t);
        }
    }

    @Override
    public AnnotationValue createAnnotationValue(AnnotationInfo info, Object ann) {
        return AnnotationValueFactory.createAnnotationValue(this, this, info, ann);
    }

    private boolean compare(CtClass clazz, ClassInfo info) {
        return clazz.getDeclaredMethods().length == info.getDeclaredMethods().length && clazz.getDeclaredConstructors().length == info.getDeclaredConstructors().length && clazz.getDeclaredFields().length == info.getDeclaredFields().length;
    }

    @Override
    public MutableClassInfo getMutable(String name, ClassLoader cl) {
        try {
            CtClass clazz = poolFactory.getPoolForLoader(cl).get(name);
            return new JavassistTypeInfo(this, clazz, null);
        }
        catch (NotFoundException e) {
            throw new org.jboss.reflect.spi.NotFoundException(e.toString());
        }
    }

    @Override
    public MutableClassInfo createNewMutableClass(String name) {
        CtClass clazz = poolFactory.getPoolForLoader(null).makeClass(name);
        return new JavassistTypeInfo(this, clazz, null);
    }

    @Override
    public MutableClassInfo createNewMutableClass(String name, ClassInfo superClass) {
        CtClass clazz = poolFactory.getPoolForLoader(superClass.getClassLoader()).makeClass(name, JavassistUtil.toCtClass(superClass));
        return new JavassistTypeInfo(this, clazz, null);
    }

    @Override
    public MutableClassInfo createNewMutableInterface(String name) {
        CtClass clazz = poolFactory.getPoolForLoader(null).makeInterface(name);
        return new JavassistTypeInfo(this, clazz, null);
    }

    @Override
    public MutableClassInfo createNewMutableInterface(String name, ClassInfo superClass) {
        CtClass clazz = poolFactory.getPoolForLoader(superClass.getClassLoader()).makeInterface(name, JavassistUtil.toCtClass(superClass));
        return new JavassistTypeInfo(this, clazz, null);
    }

    protected TypeInfo getParameterizedType(ParameterizedType type) {
        Class rawType = (Class)type.getRawType();
        ClassInfo raw = (ClassInfo)this.getTypeInfo(rawType);
        Type[] types = type.getActualTypeArguments();
        return new JavassistParameterizedClassInfo(this, raw, types);
    }

    protected TypeInfo getTypeInfo(ClassLoader loader, SignatureAttribute.Type type, JavassistTypeVariableSpy spy) {
        if (type instanceof SignatureAttribute.ClassType) {
            return this.getTypeInfo(loader, (SignatureAttribute.ClassType)type, spy);
        }
        if (type instanceof SignatureAttribute.ArrayType) {
            return this.getGenericArrayType(loader, (SignatureAttribute.ArrayType)type, spy);
        }
        if (type instanceof SignatureAttribute.BaseType) {
            String s = String.valueOf(((SignatureAttribute.BaseType)type).getDescriptor());
            Class<?> clazz = PrimitiveInfo.getPrimativeArrayComponentType(s);
            return PrimitiveInfo.valueOf(clazz.getName());
        }
        if (type instanceof SignatureAttribute.TypeVariable) {
            TypeInfo typeInfo = this.getTypeInfo(loader, spy.getTypeBound((SignatureAttribute.TypeVariable)type), spy);
            if (typeInfo instanceof TypeVariableAware) {
                ((TypeVariableAware)((Object)typeInfo)).setTypeVariable(((SignatureAttribute.TypeVariable)type).getName());
            }
            return typeInfo;
        }
        throw new IllegalArgumentException("Bad type " + type + " - " + type.getClass().getName());
    }

    protected TypeInfo getTypeInfo(ClassLoader loader, SignatureAttribute.ClassType type, JavassistTypeVariableSpy spy) {
        Map<String, WeakReference<TypeInfo>> cache;
        boolean isParameterized;
        boolean bl = isParameterized = type.getTypeArguments() != null && type.getTypeArguments().length > 0;
        if (!isParameterized) {
            try {
                return this.get(JavassistHelper.getClassNameForGenericType(type), loader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        String genericName = JavassistHelper.getGenericName((SignatureAttribute.ObjectType)type, spy);
        TypeInfo info = this.getFromCache(genericName, cache = this.getClassLoaderCache(loader));
        if (info != null) {
            if (!(info instanceof ClassInfo)) {
                throw new IllegalStateException("Not a ClassInfo " + info);
            }
            return info;
        }
        try {
            ClassInfo delegate = (ClassInfo)this.get(JavassistHelper.getClassNameForGenericType(type), loader);
            if (!isParameterized) {
                return delegate;
            }
            info = new JavassistParameterizedClassInfo(this, delegate, loader, type.getTypeArguments(), spy);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        cache.put(genericName, new WeakReference<TypeInfo>(info));
        return info;
    }

    protected TypeInfo createTypeInfoForTypeArgument(SignatureAttribute.TypeArgument arg, ClassLoader loader, JavassistTypeVariableSpy spy) {
        SignatureAttribute.ObjectType type = arg.getType();
        if (type == null) {
            try {
                return this.get(Object.class.getName(), loader, null);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (type instanceof SignatureAttribute.ClassType) {
            return this.getTypeInfo(loader, (SignatureAttribute.ClassType)type, spy);
        }
        if (type instanceof SignatureAttribute.TypeVariable) {
            return this.getTypeInfo(loader, spy.getTypeBound((SignatureAttribute.TypeVariable)type), spy);
        }
        throw new IllegalStateException("Unhandled type " + type);
    }

    protected TypeInfo getWildcardType(WildcardType type) {
        Type bound = type.getLowerBounds().length > 0 ? type.getLowerBounds()[0] : type.getUpperBounds()[0];
        return this.getTypeInfo(bound);
    }

    protected Map<String, WeakReference<TypeInfo>> getClassLoaderCache(ClassLoader cl) {
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return super.getClassLoaderCache(cl);
    }

    protected TypeInfo getGenericArrayType(GenericArrayType type) {
        ClassLoader cl;
        Map<String, WeakReference<TypeInfo>> cache;
        String genericName = GenericsUtil.getGenericName(type);
        TypeInfo info = this.getFromCache(genericName, cache = this.getClassLoaderCache(cl = GenericsUtil.findClassLoader(type)));
        if (info != null) {
            return info;
        }
        Type compType = type.getGenericComponentType();
        TypeInfo componentType = this.getTypeInfo(compType);
        String arrayName = this.getCtClass(componentType, true).getName();
        CtClass clazz = this.getCtClass(arrayName + "[]", cl);
        info = new JavassistArrayInfoImpl(this, clazz, null, componentType);
        cache.put(genericName, new WeakReference<TypeInfo>(info));
        return info;
    }

    protected ArrayInfo getGenericArrayType(ClassLoader cl, SignatureAttribute.ArrayType type, JavassistTypeVariableSpy spy) {
        ModifiableArrayType wrapped = new ModifiableArrayType(type);
        return this.getGenericArrayType(cl, wrapped, spy);
    }

    protected ArrayInfo getGenericArrayType(ClassLoader cl, ModifiableArrayType type, JavassistTypeVariableSpy spy) {
        Map<String, WeakReference<TypeInfo>> cache;
        String genericName = JavassistHelper.getGenericName((SignatureAttribute.ObjectType)type, spy);
        ArrayInfo info = (ArrayInfo)this.getFromCache(genericName, cache = this.getClassLoaderCache(cl));
        if (info != null) {
            return info;
        }
        type.decrement();
        TypeInfo componentType = type.getDimension() > 0 ? this.getGenericArrayType(cl, type, spy) : this.getTypeInfo(cl, type.getComponentType(), spy);
        String arrayName = this.getCtClass(componentType, true).getName();
        CtClass clazz = this.getCtClass(arrayName + "[]", cl);
        info = new JavassistArrayInfoImpl(this, clazz, null, componentType);
        cache.put(genericName, new WeakReference<ArrayInfo>(info));
        return info;
    }

    private CtClass getCtClass(TypeInfo typeInfo, boolean error) {
        if (typeInfo instanceof PrimitiveInfo) {
            return this.getPrimitiveCtClass(typeInfo.getName());
        }
        if (typeInfo instanceof JavassistTypeInfo) {
            return ((JavassistTypeInfo)typeInfo).getCtClass();
        }
        if (typeInfo instanceof DelegateClassInfo) {
            return this.getCtClass(((DelegateClassInfo)typeInfo).getDelegate(), error);
        }
        if (error) {
            throw new IllegalArgumentException(typeInfo + " is not a JavassistType info, a PrimitiveTypeInfo or a JavassistParameterizedType");
        }
        return null;
    }

    private CtClass getPrimitiveCtClass(String name) {
        try {
            return ClassPool.getDefault().get(name);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Could not find primitive called " + name, e);
        }
    }

    protected TypeInfo getTypeVariable(TypeVariable<?> type) {
        return this.getTypeInfo(type.getBounds()[0]);
    }

    protected static class ModifiableArrayType
    extends SignatureAttribute.ArrayType {
        int dims;

        ModifiableArrayType(SignatureAttribute.ArrayType original) {
            super(original.getDimension(), original.getComponentType());
            this.dims = original.getDimension();
        }

        public int getDimension() {
            return this.dims;
        }

        void decrement() {
            --this.dims;
        }
    }
}

