/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.protocol.v1;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.Constants;
import org.jboss.naming.remote.client.ClientUtil;
import org.jboss.naming.remote.client.RemoteNamingStore;
import org.jboss.naming.remote.protocol.ProtocolCommand;
import org.jboss.naming.remote.protocol.v1.Protocol;
import org.jboss.naming.remote.protocol.v1.VersionOne;
import org.jboss.naming.remote.protocol.v1.WriteUtil;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

public class RemoteNamingStoreV1
implements RemoteNamingStore {
    private static final Logger log = Logger.getLogger(RemoteNamingStoreV1.class);
    protected final Executor executor = Executors.newFixedThreadPool(10);
    private final Channel channel;

    public RemoteNamingStoreV1(Channel channel) {
        this.channel = channel;
    }

    void start() throws IOException {
        this.sendVersionHeader();
        this.channel.receiveMessage((Channel.Receiver)new MessageReceiver());
    }

    private void sendVersionHeader() throws IOException {
        WriteUtil.write(this.channel, new WriteUtil.Writer(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.write(Constants.NAMING);
                output.writeByte(VersionOne.getVersionIdentifier());
            }
        });
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        try {
            return Protocol.LOOKUP.execute(this.channel, name);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute lookup for [" + name + "]", e);
        }
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        try {
            Protocol.BIND.execute(this.channel, name, object);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute bind for [" + name + ", " + object + "]", e);
        }
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        try {
            Protocol.REBIND.execute(this.channel, name, object);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute rebind for [" + name + ", " + object + "]", e);
        }
    }

    @Override
    public List<NameClassPair> list(Name name) throws NamingException {
        try {
            return Protocol.LIST.execute(this.channel, name);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute list for [" + name + "]", e);
        }
    }

    @Override
    public List<Binding> listBindings(Name name) throws NamingException {
        try {
            return Protocol.LIST_BINDINGS.execute(this.channel, name);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute list bindings for [" + name + "]", e);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            Protocol.UNBIND.execute(this.channel, name);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute unbind for [" + name + "]", e);
        }
    }

    @Override
    public void rename(Name name, Name newName) throws NamingException {
        try {
            Protocol.RENAME.execute(this.channel, name, newName);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute rename for [" + name + ", " + newName + "]", e);
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        try {
            return Protocol.CREATE_SUBCONTEXT.execute(this.channel, name);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute createSubcontext for [" + name + "]", e);
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        try {
            Protocol.DESTROY_SUBCONTEXT.execute(this.channel, name);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute destroySubcontext for [" + name + "]", e);
        }
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        try {
            return Protocol.LOOKUP_LINK.execute(this.channel, name);
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to execute lookupLink for [" + name + "]", e);
        }
    }

    @Override
    public void close() throws NamingException {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw ClientUtil.namingException("Failed to close remote naming store", e);
        }
    }

    private class MessageReceiver
    implements Channel.Receiver {
        private MessageReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream message) {
            block6: {
                final DataInputStream dis = new DataInputStream((InputStream)message);
                try {
                    byte messageId = dis.readByte();
                    final int correlationId = dis.readInt();
                    log.tracef("Message Received id(%h), correlationId(%d)", (Object)messageId, (Object)correlationId);
                    final ProtocolCommand command = Protocol.forId(messageId);
                    if (command != null) {
                        RemoteNamingStoreV1.this.executor.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    command.handleClientMessage(dis, correlationId, RemoteNamingStoreV1.this);
                                }
                                catch (IOException e) {
                                    log.error((Object)e);
                                }
                                finally {
                                    IoUtils.safeClose((Closeable)dis);
                                }
                            }
                        });
                        break block6;
                    }
                    throw new IOException("Unrecognised Message ID");
                }
                catch (IOException e) {
                    log.error((Object)e);
                    IoUtils.safeClose((Closeable)dis);
                }
                finally {
                    channel.receiveMessage((Channel.Receiver)this);
                }
            }
        }

        public void handleError(Channel channel, IOException error) {
        }

        public void handleEnd(Channel channel) {
        }
    }
}

