/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.retrocheck;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import org.jboss.ant.tasks.retrocheck.CheckerClassPath;
import org.jboss.ant.tasks.retrocheck.EmptyClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checker {
    private static final String INIT = "<init>";
    private static final String CLINIT = "<clinit>";
    private FileFilter classFileFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".class");
        }
    };
    private FileFilter directoryFilter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    public boolean verbose = false;
    public boolean suppress = true;
    public static URLClassLoader loader;
    private HashMap<String, CheckClassInfo> classesToCheck = new HashMap();

    public boolean isJarFile(File src) {
        boolean isJarFile = false;
        if (src.isFile()) {
            String name = src.getName().toLowerCase();
            isJarFile = name.endsWith(".jar") || name.endsWith(".zip");
        }
        return isJarFile;
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        Checker checker = new Checker();
        checker.check(args);
        System.out.println("Check Successful: " + (System.currentTimeMillis() - start) + " ms");
    }

    public void usage() {
        System.err.println("Usage: RetroCheck [-cp <classpath>] [-classpath <classpath>] [-verbose] <dir>+");
    }

    public void check(String[] args) throws Exception {
        if (args.length == 0) {
            this.usage();
            System.exit(1);
            return;
        }
        ArrayList<URL> paths = new ArrayList<URL>();
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (args[i].equals("-suppress")) {
                this.suppress = true;
                continue;
            }
            if (args[i].equals("-cp") || args[i].equals("-classpath")) {
                if (i + 1 > args.length - 1) {
                    this.usage();
                    System.exit(1);
                    return;
                }
                StringTokenizer tokenizer = new StringTokenizer(args[++i], File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String cpath = tokenizer.nextToken();
                    File f = new File(cpath);
                    paths.add(f.toURL());
                }
                continue;
            }
            if (args[i].equals("--SOURCEPATH")) {
                this.addFilesFromSourcePathFile(files, args[++i]);
                continue;
            }
            File f = new File(args[i]).getCanonicalFile();
            files.add(f);
        }
        URL[] urls = paths.toArray(new URL[paths.size()]);
        loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        String classpath = System.getProperty("java.class.path", ".");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(classpath, pathSeparator);
        paths.clear();
        while (st.hasMoreTokens()) {
            String cpath = st.nextToken();
            File f = new File(cpath);
            paths.add(f.toURL());
        }
        urls = paths.toArray(new URL[paths.size()]);
        URLClassLoader poolLoader = new URLClassLoader(urls, (ClassLoader)EmptyClassLoader.EMPTY);
        ClassPool pool = new ClassPool(false);
        pool.appendClassPath((ClassPath)new CheckerClassPath(poolLoader));
        pool.appendClassPath((ClassPath)new ClassClassPath(Object.class));
        for (File f : files) {
            if (f.isDirectory()) {
                this.addDirectory(f, pool);
                continue;
            }
            if (this.classFileFilter.accept(f)) {
                this.addFile(f, pool);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("[retrocheck] " + f + " is neither a java class or a directory");
        }
        int failed = 0;
        for (CheckClassInfo info : this.classesToCheck.values()) {
            failed += this.checkFile(info);
        }
        if (failed > 0) {
            System.out.println("Total errors/warnings: " + failed);
            System.exit(1);
        }
    }

    private void addDirectory(File dir, ClassPool pool) throws Exception {
        File[] directories;
        File[] classFiles;
        for (File classFile : classFiles = dir.listFiles(this.classFileFilter)) {
            this.addFile(classFile, pool);
        }
        for (File directory : directories = dir.listFiles(this.directoryFilter)) {
            this.addDirectory(directory, pool);
        }
    }

    private void addFile(File file, ClassPool pool) throws Exception {
        ClassFile cf = this.createClassFile(file);
        CtClass clazz = pool.get(cf.getName());
        String className = cf.getName();
        String srcRoot = file.getCanonicalPath();
        srcRoot = srcRoot.substring(0, srcRoot.length() - className.length() - 6);
        CheckClassInfo info = new CheckClassInfo(file, srcRoot, clazz);
        this.classesToCheck.put(className, info);
    }

    private ClassFile createClassFile(File file) throws Exception {
        DataInputStream is = new DataInputStream(new FileInputStream(file));
        ClassFile cf = new ClassFile(is);
        is.close();
        return cf;
    }

    private void addFilesFromSourcePathFile(ArrayList<File> files, String sourcePathFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File(sourcePathFile).getCanonicalFile()));
            String fileName = reader.readLine();
            while (fileName != null) {
                files.add(new File(fileName).getCanonicalFile());
                fileName = reader.readLine();
            }
        }
        catch (Exception e) {
            try {
                reader.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    public int checkFile(CheckClassInfo info) throws Exception {
        File infoFile;
        URL classUrl;
        if (info.isCompiled()) {
            return 0;
        }
        if (this.verbose) {
            System.out.println("[checkFile] " + info.getClassName());
        }
        if ((classUrl = loader.getResource(info.getClassName().replace('.', '/') + ".class")) == null) {
            System.out.println("[warning] Unable to find " + info.getFile() + " within classpath.  Make sure all transforming classes are within classpath.");
            return 1;
        }
        File classUrlFile = new File(URLDecoder.decode(classUrl.getFile(), "UTF-8"));
        if (!classUrlFile.equals(infoFile = new File(URLDecoder.decode(info.getFile().toString(), "UTF-8")))) {
            System.out.println("[warning] Trying to compile " + info.getFile() + " and found it also within " + classUrl.getFile() + " will not proceed. ");
            return 1;
        }
        int failed = this.doCheck(loader, info);
        info.setCompiled(true);
        if (this.verbose && failed == 0) {
            System.out.println("[ok] " + info.getClassName());
        }
        return failed;
    }

    public int doCheck(ClassLoader cl, CheckClassInfo info) {
        String[] intfs;
        CtClass clazz = info.getClazz();
        ClassFile file = clazz.getClassFile();
        ClassPool pool = clazz.getClassPool();
        int failed = 0;
        int major = file.getMajorVersion();
        if (major > 48) {
            if (failed == 0) {
                System.out.println("==== " + info.getFile());
            }
            System.out.println("Wrong major version " + major);
            ++failed;
        }
        String superClassName = file.getSuperclass();
        try {
            pool.get(superClassName);
        }
        catch (NotFoundException e) {
            if (failed == 0) {
                System.out.println("==== " + info.getFile());
            }
            System.out.println("SuperClass not found " + superClassName);
            ++failed;
        }
        for (String intf : intfs = file.getInterfaces()) {
            try {
                pool.get(intf);
            }
            catch (NotFoundException e) {
                if (failed == 0) {
                    System.out.println("==== " + info.getFile());
                }
                System.out.println("Interface not found " + intf);
                ++failed;
            }
        }
        List fields = file.getFields();
        for (FieldInfo field : fields) {
            String name = field.getName();
            String typeName = Descriptor.toJavaName((String)field.getDescriptor());
            try {
                CtField ctField = clazz.getField(name);
                ctField.getType();
            }
            catch (NotFoundException e) {
                if (failed == 0) {
                    System.out.println("==== " + info.getFile());
                }
                System.out.println("Class not found " + typeName + " for field " + name);
                ++failed;
            }
        }
        List methods = file.getMethods();
        for (MethodInfo method : methods) {
            CtMethod ctMethod;
            String name = method.getName();
            String descriptor = method.getDescriptor();
            if (CLINIT.equals(name)) continue;
            try {
                if (!INIT.equals(name)) {
                    ctMethod = clazz.getMethod(name, descriptor);
                    ctMethod.getReturnType();
                }
            }
            catch (NotFoundException e) {
                if (failed == 0) {
                    System.out.println("==== " + info.getFile());
                }
                System.out.println("Return type not found for method " + name + "." + descriptor);
                ++failed;
            }
            if (INIT.equals(name)) {
                CtConstructor ctConstructor;
                try {
                    ctConstructor = clazz.getConstructor(descriptor);
                    ctConstructor.getParameterTypes();
                }
                catch (NotFoundException e) {
                    if (failed == 0) {
                        System.out.println("==== " + info.getFile());
                    }
                    System.out.println("Cannot find constructor parameter types " + name + "." + descriptor);
                    ++failed;
                }
                try {
                    ctConstructor = clazz.getConstructor(descriptor);
                    ctConstructor.getExceptionTypes();
                }
                catch (NotFoundException e) {
                    if (failed == 0) {
                        System.out.println("==== " + info.getFile());
                    }
                    System.out.println("Cannot find constructor exception types " + name + "." + descriptor);
                    ++failed;
                }
                continue;
            }
            try {
                ctMethod = clazz.getMethod(name, descriptor);
                ctMethod.getParameterTypes();
            }
            catch (NotFoundException e) {
                if (failed == 0) {
                    System.out.println("==== " + info.getFile());
                }
                System.out.println("Cannot find method parameter types " + name + "." + descriptor);
                ++failed;
            }
            try {
                ctMethod = clazz.getMethod(name, descriptor);
                ctMethod.getExceptionTypes();
            }
            catch (NotFoundException e) {
                if (failed == 0) {
                    System.out.println("==== " + info.getFile());
                }
                System.out.println("Cannot find method exception types " + name + "." + descriptor);
                ++failed;
            }
        }
        file.compact();
        ConstPool consts = file.getConstPool();
        block32: for (int i = 1; i < consts.getSize(); ++i) {
            switch (consts.getTag(i)) {
                case 9: {
                    String type = consts.getFieldrefClassName(i);
                    String name = consts.getFieldrefName(i);
                    try {
                        CtClass ctClazz = pool.get(type);
                        ctClazz.getField(name);
                    }
                    catch (NotFoundException e) {
                        if (failed == 0) {
                            System.out.println("==== " + info.getFile());
                        }
                        System.out.println("Cannot find field " + type + "." + name);
                        ++failed;
                    }
                    continue block32;
                }
                case 11: {
                    CtClass ctClazz;
                    String type = consts.getInterfaceMethodrefClassName(i);
                    String name = consts.getInterfaceMethodrefName(i);
                    String descriptor = consts.getInterfaceMethodrefType(i);
                    try {
                        ctClazz = pool.get(type);
                        ctClazz.getMethod(name, descriptor);
                    }
                    catch (NotFoundException e) {
                        if (failed == 0) {
                            System.out.println("==== " + info.getFile());
                        }
                        System.out.println("Cannot find interface method " + type + "." + name + descriptor);
                        ++failed;
                    }
                    continue block32;
                }
                case 10: {
                    CtClass ctClazz;
                    String type = consts.getMethodrefClassName(i);
                    String name = consts.getMethodrefName(i);
                    String descriptor = consts.getMethodrefType(i);
                    if (INIT.equals(name)) {
                        try {
                            ctClazz = pool.get(type);
                            ctClazz.getConstructor(descriptor);
                        }
                        catch (NotFoundException e) {
                            if (failed == 0) {
                                System.out.println("==== " + info.getFile());
                            }
                            System.out.println("Cannot find constructor " + type + descriptor);
                            ++failed;
                        }
                        continue block32;
                    }
                    try {
                        ctClazz = pool.get(type);
                        ctClazz.getMethod(name, descriptor);
                    }
                    catch (NotFoundException e) {
                        if (failed == 0) {
                            System.out.println("==== " + info.getFile());
                        }
                        System.out.println("Cannot find method " + type + "." + name + descriptor);
                        ++failed;
                    }
                    continue block32;
                }
            }
        }
        if (failed > 0) {
            System.out.println(failed + " errors for " + info.getFile());
            System.out.println();
        }
        return failed;
    }

    private class CheckClassInfo {
        File file;
        String srcRoot;
        String className;
        CtClass clazz;
        boolean compiled;

        CheckClassInfo(File file, String srcRoot, CtClass clazz) {
            this.file = file;
            this.srcRoot = srcRoot;
            this.className = clazz.getName();
            this.clazz = clazz;
        }

        public File getFile() {
            return this.file;
        }

        public String getSrcRoot() {
            return this.srcRoot;
        }

        public boolean isCompiled() {
            return this.compiled;
        }

        public void setCompiled(boolean compiled) {
            this.compiled = compiled;
        }

        public String getClassName() {
            return this.className;
        }

        public CtClass getClazz() {
            return this.clazz;
        }

        public void setClazz(CtClass clazz) {
            this.clazz = clazz;
        }
    }
}

