/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.jboss.lang.Annotation;

public class AnnotationHelper {
    private static final ScopedClassPoolRepository repository = ScopedClassPoolRepositoryImpl.getInstance();

    public static boolean isAnnotationPresent(Class clazz, Class annotationClass) {
        return AnnotationHelper.getAnnotation(clazz, annotationClass) != null;
    }

    public static Annotation getAnnotation(Class clazz, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        for (Object annotation : AnnotationHelper.getAnnotationsInternal(clazz)) {
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return (Annotation)annotation;
        }
        return null;
    }

    public static Annotation[] getAnnotations(Class clazz) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal(clazz));
    }

    static Object[] getAnnotationsInternal(Class clazz) {
        return AnnotationHelper.getCtClass(clazz).getAvailableAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Class clazz) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getDeclaredAnnotationsInternal(clazz));
    }

    static Object[] getDeclaredAnnotationsInternal(Class clazz) {
        return AnnotationHelper.getCtClass(clazz).getAvailableAnnotations();
    }

    static CtClass getCtClass(Class clazz) {
        try {
            ClassPool pool = repository.findClassPool(clazz.getClassLoader());
            return pool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to load CtClass for " + clazz, e);
        }
    }

    public static boolean isAnnotationPresent(Object obj, Class annotationClass) {
        if (obj instanceof Class) {
            return AnnotationHelper.isAnnotationPresent((Class)obj, annotationClass);
        }
        if (obj instanceof Method) {
            return AnnotationHelper.isAnnotationPresent((Method)obj, annotationClass);
        }
        if (obj instanceof Constructor) {
            return AnnotationHelper.isAnnotationPresent((Constructor)obj, annotationClass);
        }
        if (obj instanceof Field) {
            return AnnotationHelper.isAnnotationPresent((Field)obj, annotationClass);
        }
        throw new RuntimeException("Invalid AccessibleObject passed in " + obj);
    }

    public static Annotation getAnnotation(AccessibleObject ao, Class annotationClass) {
        if (ao instanceof Method) {
            return AnnotationHelper.getAnnotation((Method)ao, annotationClass);
        }
        if (ao instanceof Constructor) {
            return AnnotationHelper.getAnnotation((Constructor)ao, annotationClass);
        }
        if (ao instanceof Field) {
            return AnnotationHelper.getAnnotation((Field)ao, annotationClass);
        }
        throw new RuntimeException("Invalid AccessibleObject passed in " + ao);
    }

    public static Annotation[] getAnnotations(AccessibleObject ao) {
        if (ao instanceof Method) {
            return AnnotationHelper.getAnnotations((Method)ao);
        }
        if (ao instanceof Constructor) {
            return AnnotationHelper.getAnnotations((Constructor)ao);
        }
        if (ao instanceof Field) {
            return AnnotationHelper.getAnnotations((Field)ao);
        }
        throw new RuntimeException("Invalid AccessibleObject passed in " + ao);
    }

    public static Annotation[] getDeclaredAnnotations(AccessibleObject ao) {
        if (ao instanceof Method) {
            return AnnotationHelper.getDeclaredAnnotations((Method)ao);
        }
        if (ao instanceof Constructor) {
            return AnnotationHelper.getDeclaredAnnotations((Constructor)ao);
        }
        if (ao instanceof Field) {
            return AnnotationHelper.getDeclaredAnnotations((Field)ao);
        }
        throw new RuntimeException("Invalid AccessibleObject passed in " + ao);
    }

    public static boolean isAnnotationPresent(Method method, Class annotationClass) {
        return AnnotationHelper.getAnnotation(method, annotationClass) != null;
    }

    public static Annotation getAnnotation(Method method, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        for (Object annotation : AnnotationHelper.getAnnotationsInternal(method)) {
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return (Annotation)annotation;
        }
        return null;
    }

    public static Annotation[] getAnnotations(Object object) {
        if (object instanceof Class) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal((Class)object));
        }
        if (object instanceof Constructor) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal((Constructor)object));
        }
        if (object instanceof Field) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal((Field)object));
        }
        if (object instanceof Method) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal((Method)object));
        }
        return new Annotation[0];
    }

    public static Annotation[] getDeclaredAnnotations(Object object) {
        if (object instanceof Class) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getDeclaredAnnotations((Class)object));
        }
        if (object instanceof Constructor) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getDeclaredAnnotations((Constructor)object));
        }
        if (object instanceof Field) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getDeclaredAnnotations((Field)object));
        }
        if (object instanceof Method) {
            return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal((Method)object));
        }
        return new Annotation[0];
    }

    public static Annotation getAnnotation(Object object, Class annotationClass) {
        if (object instanceof Class) {
            return AnnotationHelper.getAnnotation((Class)object, annotationClass);
        }
        if (object instanceof Constructor) {
            return AnnotationHelper.getAnnotation((Constructor)object, annotationClass);
        }
        if (object instanceof Field) {
            return AnnotationHelper.getAnnotation((Field)object, annotationClass);
        }
        if (object instanceof Method) {
            return AnnotationHelper.getAnnotation((Method)object, annotationClass);
        }
        return null;
    }

    public static Annotation[] getAnnotations(Method method) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal(method));
    }

    public static Object[] getAnnotationsInternal(Method method) {
        return AnnotationHelper.getCtMethod(method).getAvailableAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Method method) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal(method));
    }

    public static Object[] getDeclaredAnnotationsInternal(Method method) {
        return AnnotationHelper.getCtMethod(method).getAvailableAnnotations();
    }

    public static Annotation[][] getParameterAnnotations(Method method) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getCtMethod(method).getAvailableParameterAnnotations());
    }

    static CtMethod getCtMethod(Method method) {
        CtClass clazz = AnnotationHelper.getCtClass(method.getDeclaringClass());
        Class<?>[] parameters = method.getParameterTypes();
        CtClass[] params = new CtClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = AnnotationHelper.getCtClass(parameters[i]);
        }
        CtClass returnType = AnnotationHelper.getCtClass(method.getReturnType());
        String descriptor = Descriptor.ofMethod((CtClass)returnType, (CtClass[])params);
        try {
            return clazz.getMethod(method.getName(), descriptor);
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to find method " + method + " descriptor=" + descriptor, e);
        }
    }

    public static boolean isAnnotationPresent(Constructor constructor, Class annotationClass) {
        return AnnotationHelper.getAnnotation(constructor, annotationClass) != null;
    }

    public static Annotation getAnnotation(Constructor constructor, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        for (Object annotation : AnnotationHelper.getAnnotationsInternal(constructor)) {
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return (Annotation)annotation;
        }
        return null;
    }

    public static Annotation[] getAnnotations(Constructor constructor) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal(constructor));
    }

    static Object[] getAnnotationsInternal(Constructor constructor) {
        return AnnotationHelper.getCtConstructor(constructor).getAvailableAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Constructor constructor) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getDeclaredAnnotationsInternal(constructor));
    }

    static Object[] getDeclaredAnnotationsInternal(Constructor constructor) {
        return AnnotationHelper.getCtConstructor(constructor).getAvailableAnnotations();
    }

    public static Annotation[][] getParameterAnnotations(Constructor constructor) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getCtConstructor(constructor).getAvailableParameterAnnotations());
    }

    static CtConstructor getCtConstructor(Constructor constructor) {
        CtClass clazz = AnnotationHelper.getCtClass(constructor.getDeclaringClass());
        Class<?>[] parameters = constructor.getParameterTypes();
        CtClass[] params = new CtClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = AnnotationHelper.getCtClass(parameters[i]);
        }
        String descriptor = Descriptor.ofConstructor((CtClass[])params);
        try {
            return clazz.getConstructor(descriptor);
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to find constructor descriptor=" + descriptor, e);
        }
    }

    public static boolean isAnnotationPresent(Field field, Class annotationClass) {
        return AnnotationHelper.getAnnotation(field, annotationClass) != null;
    }

    public static Annotation getAnnotation(Field field, Class annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException("Null annotation");
        }
        String searchName = annotationClass.getName();
        for (Object annotation : AnnotationHelper.getAnnotationsInternal(field)) {
            AnnotationImpl impl = (AnnotationImpl)Proxy.getInvocationHandler(annotation);
            if (!searchName.equals(impl.getTypeName())) continue;
            return (Annotation)annotation;
        }
        return null;
    }

    public static Annotation[] getAnnotations(Field field) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getAnnotationsInternal(field));
    }

    static Object[] getAnnotationsInternal(Field field) {
        return AnnotationHelper.getCtField(field).getAvailableAnnotations();
    }

    public static Annotation[] getDeclaredAnnotations(Field field) {
        return AnnotationHelper.convertAnnotationArray(AnnotationHelper.getDeclaredAnnotationsInternal(field));
    }

    static Object[] getDeclaredAnnotationsInternal(Field field) {
        return AnnotationHelper.getCtField(field).getAvailableAnnotations();
    }

    static CtField getCtField(Field field) {
        CtClass clazz = AnnotationHelper.getCtClass(field.getDeclaringClass());
        try {
            return clazz.getField(field.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to find field " + field, e);
        }
    }

    static Annotation[] convertAnnotationArray(Object[] annotations) {
        Annotation[] anns = new Annotation[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            anns[i] = (Annotation)annotations[i];
        }
        return anns;
    }

    static Annotation[][] convertAnnotationArray(Object[][] annotations) {
        Annotation[][] anns = new Annotation[annotations.length][];
        for (int i = 0; i < annotations.length; ++i) {
            anns[i] = new Annotation[annotations[i].length];
            for (int j = 0; j < annotations[i].length; ++j) {
                anns[i][j] = (Annotation)annotations[i][j];
            }
        }
        return anns;
    }

    private AnnotationHelper() {
    }
}

