/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomicReferenceFieldUpdater<T, V> {
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> tClass, Class<W> vClass, String fieldName) {
        return new Implementation<U, W>(tClass, vClass, fieldName);
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract V get(T var1);

    public V getAndSet(T obj, V newValue) {
        V expect;
        while (!this.compareAndSet(obj, expect = this.get(obj), newValue)) {
        }
        return expect;
    }

    public abstract void set(T var1, V var2);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Implementation<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private Class<T> tClass;
        private String fieldName;
        private Field field;

        public Implementation(Class<T> tClass, Class<V> vClass, String fieldName) {
            if (tClass == null) {
                throw new IllegalArgumentException("Null type class");
            }
            if (vClass == null) {
                throw new IllegalArgumentException("Null value class");
            }
            if (fieldName == null) {
                throw new IllegalArgumentException("Null field name");
            }
            this.tClass = tClass;
            this.fieldName = fieldName;
            try {
                this.field = tClass.getDeclaredField(fieldName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find field class=" + tClass.getName() + " field=" + fieldName, e);
            }
            if (this.field.getType().isAssignableFrom(vClass)) {
                throw new IllegalArgumentException("Field is not a " + vClass.getName() + " class=" + tClass.getName() + " field=" + fieldName);
            }
            if (!Modifier.isVolatile(this.field.getModifiers())) {
                throw new IllegalArgumentException("Field is not volatile class=" + tClass.getName() + " field=" + fieldName);
            }
            this.field.setAccessible(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndSet(T obj, V expect, V update) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    Object value = this.field.get(obj);
                    if (value != expect) {
                        return false;
                    }
                    this.field.set(obj, update);
                    return true;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error class=" + this.tClass.getName() + " field=" + this.fieldName, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(T obj) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    return (V)this.field.get(obj);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error class=" + this.tClass.getName() + " field=" + this.fieldName, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T obj, V newValue) {
            try {
                Implementation implementation = this;
                synchronized (implementation) {
                    this.field.set(obj, newValue);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error class=" + this.tClass.getName() + " field=" + this.fieldName, e);
            }
        }

        @Override
        public boolean weakCompareAndSet(T obj, V expect, V update) {
            return this.compareAndSet(obj, expect, update);
        }
    }
}

