/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weaver;

import java.io.IOException;
import java.util.logging.Logger;
import org.jboss.weaver.WeaveRunner;
import org.jboss.weaver.Weaver;

public class Main {
    private static Logger log = Logger.getLogger(Main.class.getName());

    public static void parseArgs(WeaveRunner weaveRunner, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("-help")) {
            Main.printUsageAndExit();
        }
        String weaverClass = null;
        String classPath = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-verbose")) {
                weaveRunner.setVerbose(true);
                continue;
            }
            if (args[i].equals("-suppress")) {
                weaveRunner.setSuppress(true);
                continue;
            }
            if (args[i].equals("-outputPath")) {
                weaveRunner.setOutputPath(args[++i]);
                continue;
            }
            if (args[i].equals("-cp") || args[i].equals("-classpath")) {
                if (i + 1 > args.length - 1) {
                    Main.printUsageAndExit();
                }
                classPath = args[++i];
                continue;
            }
            if (args[i].equals("--SOURCEPATH")) {
                if (i + 1 > args.length - 1) {
                    Main.printUsageAndExit();
                }
                weaveRunner.addFilesFromSourcePathFile(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-weaverClass")) {
                if (i + 1 > args.length - 1) {
                    Main.printUsageAndExit();
                }
                weaverClass = args[++i];
                continue;
            }
            try {
                weaveRunner.addSourcePath(args[i]);
                continue;
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Problem accessing source path: " + ioe);
            }
        }
        Weaver weaver = null;
        if (weaverClass == null) {
            weaver = new Weaver();
        } else {
            try {
                weaver = (Weaver)Class.forName(weaverClass).newInstance();
            }
            catch (Exception e) {
                log.severe("Unable to instantiate weaver class");
                log.severe(e.getMessage());
                System.exit(1);
            }
        }
        weaver.setClasspath(classPath);
        weaver.init();
        weaveRunner.setWeaver(weaver);
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        WeaveRunner weaveRunner = new WeaveRunner();
        Main.parseArgs(weaveRunner, args);
        try {
            weaveRunner.weave();
        }
        catch (Exception e) {
            if (weaveRunner.isVerbose()) {
                throw e;
            }
            throw e;
        }
        System.out.println("Build Successful: " + (System.currentTimeMillis() - start) + " ms");
    }

    private static void printUsageAndExit() {
        Main.usage();
        System.exit(1);
    }

    public static void usage() {
        StringBuffer usage = new StringBuffer();
        usage.append("usage: java org.jboss.Weaver [options] <path>+)\noptions:\n-classpath (-cp) <classpath>\n-verbose\n-suppress\n-outputPath <path>\n-outputToJar--SOURCEPATH  <source-path-file>\n");
        System.out.println(usage);
    }
}

