/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weaver;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import org.jboss.weaver.ClassFileInfo;
import org.jboss.weaver.Weaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaveRunner {
    private static Logger log = Logger.getLogger(WeaveRunner.class.getName());
    private ArrayList<String> sourcePaths = new ArrayList();
    private Set<ClassFileInfo> classesToCompile = new HashSet<ClassFileInfo>();
    private Weaver weaver;
    private boolean verbose = false;
    private boolean suppress = true;
    private String outputPath;
    private boolean outputToJar = false;
    private JarOutputStream jarOutputStream;
    private FileFilter classFileFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".class");
        }
    };
    private FileFilter directoryFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private FileFilter jarFileFilter = new FileFilter(){

        public boolean accept(File file) {
            boolean result = false;
            try {
                JarFile jar = new JarFile(file);
                result = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
    };
    public static URLClassLoader loader;

    public WeaveRunner() {
        this.weaver = new Weaver();
    }

    public WeaveRunner(Weaver weaver) {
        this.weaver = weaver;
    }

    public void weave() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        pool.appendPathList(this.weaver.getClasspath());
        URL[] urls = this.weaver.getClassPathUrls().toArray(new URL[this.weaver.getClassPathUrls().size()]);
        loader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
        for (String fileName : this.sourcePaths) {
            File file = new File(fileName);
            if (file.isDirectory()) {
                this.addDirectory(file, pool);
                continue;
            }
            if (this.classFileFilter.accept(file)) {
                this.addFile(file, pool);
                continue;
            }
            if (this.jarFileFilter.accept(file)) {
                this.addJarFile(new JarFile(file), pool);
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("[retro] " + file + " is neither a java class or a directory");
        }
        if (this.outputToJar) {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.putValue("Manifest-Version", "1.0");
            attributes.putValue("Created-By", System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
            this.jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.outputPath), manifest);
            this.jarOutputStream.setLevel(9);
        }
        for (ClassFileInfo classFileInfo : this.classesToCompile) {
            this.compileFile(classFileInfo);
            this.writeClassFile(classFileInfo);
        }
        if (this.outputToJar) {
            this.jarOutputStream.close();
        }
    }

    private void writeClassFile(ClassFileInfo classFileInfo) throws IOException {
        try {
            String dir;
            byte[] classData = classFileInfo.getClazz().toBytecode();
            String classname = classFileInfo.getClassName();
            String filename = this.outputPath + File.separatorChar + classname.replace('.', File.separatorChar) + ".class";
            int pos = filename.lastIndexOf(File.separatorChar);
            if (pos > 0 && !(dir = filename.substring(0, pos)).equals(".")) {
                new File(dir).mkdirs();
            }
            if (this.outputToJar) {
                JarEntry jarEntry = new JarEntry(classname.replace('.', File.separatorChar) + ".class");
                this.jarOutputStream.putNextEntry(jarEntry);
                this.jarOutputStream.write(classData);
            } else {
                FileOutputStream fos = new FileOutputStream(filename);
                fos.write(classData);
                fos.close();
            }
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
        }
    }

    private void addDirectory(File dir, ClassPool pool) throws IOException, NotFoundException {
        File[] directories;
        File[] classFiles;
        for (File classFile : classFiles = dir.listFiles(this.classFileFilter)) {
            this.addFile(classFile, pool);
        }
        for (File directory : directories = dir.listFiles(this.directoryFilter)) {
            this.addDirectory(directory, pool);
        }
    }

    private void addJarFile(JarFile jarFile, ClassPool pool) throws IOException, NotFoundException {
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry nextEntry = jarEntries.nextElement();
            this.addToCompileList(jarFile.getInputStream(nextEntry), pool);
        }
    }

    private void addFile(File file, ClassPool pool) throws IOException, NotFoundException {
        FileInputStream fis = new FileInputStream(file);
        String className = this.getClassName(fis);
        this.addToCompileList(className, pool);
    }

    private void addToCompileList(InputStream is, ClassPool pool) throws IOException, NotFoundException {
        String className = this.getClassName(is);
        this.addToCompileList(className, pool);
    }

    private void addToCompileList(String className, ClassPool pool) throws IOException, NotFoundException {
        CtClass clazz = pool.get(className);
        this.classesToCompile.add(new ClassFileInfo(className, clazz));
    }

    public String getClassName(InputStream is) throws IOException {
        return this.createClassFile(is).getName();
    }

    public ClassFile createClassFile(InputStream is) throws IOException {
        DataInputStream dis = null;
        dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
        ClassFile cf = new ClassFile(dis);
        dis.close();
        return cf;
    }

    public void addFilesFromSourcePathFile(String sourcePathFile) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(new File(sourcePathFile).getCanonicalFile()));
            String fileName = reader.readLine();
            while (fileName != null) {
                this.sourcePaths.add(fileName);
                fileName = reader.readLine();
            }
        }
        catch (IOException ioe) {
            log.warning("Problem reading sourcepath file: " + ioe);
            try {
                reader.close();
            }
            catch (IOException ioe1) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public void compileFile(ClassFileInfo info) throws Exception {
        URL classUrl;
        if (info.isCompiled()) {
            return;
        }
        if (this.verbose) {
            System.out.println("[compileFile] " + info.getClassName());
        }
        if ((classUrl = loader.getResource(info.getClassName().replace('.', '/') + ".class")) == null) {
            System.out.println("[warning] Unable to find " + info.getClassName() + " within classpath.  Make sure all transforming classes are within classpath.");
            return;
        }
        boolean weaved = this.weaver.doWeave(loader, info);
        if (!weaved) {
            if (this.verbose) {
                System.out.println("[no comp needed] " + info.getFileName());
            }
            return;
        }
        info.setCompiled(true);
        if (this.verbose) {
            System.out.println("[compiled] " + info.getFileName());
        }
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void addSourcePath(String path) throws IOException {
        this.sourcePaths.add(path);
    }

    public ArrayList<String> getSourcePaths() {
        return this.sourcePaths;
    }

    public void setSourcePaths(ArrayList<String> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public Weaver getWeaver() {
        return this.weaver;
    }

    public void setWeaver(Weaver weaver) {
        this.weaver = weaver;
    }

    public void setWeaver(String weaverClass) {
        try {
            this.weaver = (Weaver)Class.forName(weaverClass).newInstance();
        }
        catch (Exception e) {
            log.warning("Unable to instantiate weaver: " + weaverClass);
            log.warning(e.getMessage());
        }
    }

    public boolean isOutputToJar() {
        return this.outputToJar;
    }

    public void setOutputToJar(boolean outputToJar) {
        this.outputToJar = outputToJar;
    }

    public boolean isSuppress() {
        return this.suppress;
    }

    public void setSuppress(boolean suppress) {
        this.suppress = suppress;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (verbose) {
            Logger weaverLog = Logger.getLogger("org.jboss.weaver");
            weaverLog.setUseParentHandlers(false);
            ConsoleHandler console = new ConsoleHandler();
            console.setLevel(Level.FINE);
            weaverLog.addHandler(console);
            weaverLog.setLevel(Level.FINE);
        }
    }
}

