/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weaver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.bytecode.ClassFile;
import javassist.expr.ExprEditor;
import org.jboss.weaver.ClassFileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Weaver {
    static Logger log = Logger.getLogger(Weaver.class.getName());
    private Map<String, String> classRenames = new Hashtable<String, String>();
    private List<CodeConverter> codeConverters = new ArrayList<CodeConverter>();
    private List<ExprEditor> exprEditors = new ArrayList<ExprEditor>();
    private String classpath = "";
    private ArrayList<URL> classPathUrls = new ArrayList();

    public boolean doWeave(ClassLoader cl, ClassFileInfo info) throws Exception {
        CtClass clazz = info.getClazz();
        ClassFile file = clazz.getClassFile();
        file.renameClass(this.classRenames);
        for (CodeConverter converter : this.codeConverters) {
            clazz.instrument(converter);
        }
        for (ExprEditor editor : this.exprEditors) {
            clazz.instrument(editor);
        }
        return true;
    }

    public Map<String, String> getClassRenames() {
        return this.classRenames;
    }

    public void setClassRenames(Map<String, String> classRenames) {
        this.classRenames = classRenames;
    }

    public void loadClassRenames(InputStream props) {
        block2: {
            Properties classRenamesProps = new Properties();
            try {
                classRenamesProps.load(props);
                this.putClassRenames(classRenamesProps);
            }
            catch (IOException ioe) {
                log.warning("Unable to load class renames from given input stream");
                log.warning(ioe.getMessage());
                if (log.getLevel() != Level.FINE) break block2;
                ioe.printStackTrace();
            }
        }
    }

    public void putClassRename(String origClass, String renamedClass) {
        this.classRenames.put(origClass, renamedClass);
    }

    public void putClassRenames(Map<String, String> props) {
        this.classRenames.putAll(props);
    }

    public void clearClassRenames() {
        this.classRenames.clear();
    }

    public void addCodeConverter(CodeConverter converter) {
        this.codeConverters.add(converter);
    }

    public List<CodeConverter> getCodeConverters() {
        return this.codeConverters;
    }

    public void clearCodeConverters() {
        this.codeConverters.clear();
    }

    public void addExprEditor(ExprEditor editor) {
        this.exprEditors.add(editor);
    }

    public List<ExprEditor> getExprEditors() {
        return this.exprEditors;
    }

    public void clearExprEditors() {
        this.exprEditors.clear();
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classPath) {
        if (classPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String cpath = tokenizer.nextToken();
            File f = new File(cpath);
            try {
                this.classPathUrls.add(f.toURL());
            }
            catch (MalformedURLException mue) {
                throw new IllegalArgumentException("Malformed URL in classpath param: " + mue);
            }
        }
        this.classpath = classPath;
    }

    public ArrayList<URL> getClassPathUrls() {
        return this.classPathUrls;
    }

    public void setClassPathUrls(ArrayList<URL> classPathUrls) {
        this.classPathUrls = classPathUrls;
    }

    public void init() {
    }
}

