/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weaver.retro;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.jboss.lang.Autoboxing;

public class AutoboxCodeConverter
extends CodeConverter {
    public AutoboxCodeConverter(ClassPool pool) throws NotFoundException, CannotCompileException {
        CtClass autoboxClass = pool.get(Autoboxing.class.getName());
        this.autoBox(pool, autoboxClass, Byte.class.getName(), Byte.TYPE.getName());
        this.autoBox(pool, autoboxClass, Character.class.getName(), Character.TYPE.getName());
        this.autoBox(pool, autoboxClass, Short.class.getName(), Short.TYPE.getName());
        this.autoBox(pool, autoboxClass, Integer.class.getName(), Integer.TYPE.getName());
        this.autoBox(pool, autoboxClass, Long.class.getName(), Long.TYPE.getName());
        this.autoBox(pool, autoboxClass, Double.class.getName(), Double.TYPE.getName());
        this.autoBox(pool, autoboxClass, Float.class.getName(), Float.TYPE.getName());
    }

    public void autoBox(ClassPool pool, CtClass autoboxClass, String boxed, String unboxed) throws NotFoundException, CannotCompileException {
        CtClass boxedClass = pool.get(boxed);
        CtClass unboxedClass = pool.get(unboxed);
        CtClass[] sig = new CtClass[]{unboxedClass};
        CtMethod autoboxValueOf = autoboxClass.getDeclaredMethod("valueOf", sig);
        CtMethod originalValueOf = boxedClass.getDeclaredMethod("valueOf", sig);
        this.redirectMethodCall(originalValueOf, autoboxValueOf);
    }
}

