/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weaver.retro;

import edu.emory.mathcs.backport.java.util.Collections;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Timer;
import java.util.regex.Matcher;
import javassist.CannotCompileException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.lang.AnnotationHelper;
import org.jboss.lang.Boolean;
import org.jboss.lang.CharacterRedirects;
import org.jboss.lang.ClassRedirects;
import org.jboss.lang.ExceptionHelper;
import org.jboss.lang.GenericsHelper;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.lang.NumberHelper;
import org.jboss.lang.StringRedirects;
import org.jboss.util.StringWriterHelper;

public class ClassRedirectEditor
extends ExprEditor {
    private static final String CLASS_REDIRECTS = ClassRedirects.class.getName();
    private static final String STRING_REDIRECTS = StringRedirects.class.getName();
    private static final String CHARACTER_REDIRECTS = CharacterRedirects.class.getName();
    private static final String ANNOTATION_HELPER = AnnotationHelper.class.getName();
    private static final String EXCEPTION_HELPER = ExceptionHelper.class.getName();
    private static final String STRINGWRITER_HELPER = StringWriterHelper.class.getName();
    private static final String CONCURRENT_UTILS = Utils.class.getName();
    private static final String NUMBER_HELPER = NumberHelper.class.getName();
    private static final String GENERICS_HELPER = GenericsHelper.class.getName();
    private static final String OBJECT = Object.class.getName();
    private static final String CLASS = Class.class.getName();
    private static final String METHOD = Method.class.getName();
    private static final String CONSTRUCTOR = Constructor.class.getName();
    private static final String FIELD = Field.class.getName();
    private static final String ACCESSIBLE_OBJECT = AccessibleObject.class.getName();
    private static final String STRING = String.class.getName();
    private static final String BOOLEAN = java.lang.Boolean.class.getName();
    private static final String INTEGER = Integer.class.getName();
    private static final String LONG = Long.class.getName();
    private static final String CHARACTER = Character.class.getName();
    private static final String MATCHER = Matcher.class.getName();
    private static final String SYSTEM = System.class.getName();
    private static final String COLLECTIONS = Collections.class.getName();
    private static final String THREAD_LOCAL = ThreadLocal.class.getName();
    private static final String INHERTIABLE_THREAD_LOCAL = InheritableThreadLocal.class.getName();
    private static final String CONDITION = Condition.class.getName();
    private static final String TIME_UNIT = TimeUnit.class.getName();
    private static final String STRING_WRITER = StringWriter.class.getName();
    private static final String TIMER = Timer.class.getName();
    private static final String URL = URL.class.getName();
    private static final String STRING_BUFFER = StringBuffer.class.getName();
    private static final String STRING_BUILDER = JBossStringBuilder.class.getName();
    private static HashSet<String> exceptionCtors = new HashSet();
    private static HashSet<String> integerBitMethods;
    private static HashSet<String> characterCodePointMethods;
    private static HashSet<String> characterOverloadMethods;
    private static HashSet<String> bufferBuilderCodePointMethods;
    private static final String CTOR_TIMER1;
    private static final String CTOR_TIMER2;

    public void edit(NewExpr newExpr) throws CannotCompileException {
        String signature = newExpr.getClassName() + newExpr.getSignature();
        if (exceptionCtors.contains(signature)) {
            newExpr.replace("$_ = " + EXCEPTION_HELPER + ".createExceptionWithCause($class, $args);");
        } else if (CTOR_TIMER1.equals(signature)) {
            newExpr.replace("$_ = new " + TIMER + "();");
        } else if (CTOR_TIMER2.equals(signature)) {
            newExpr.replace("$_ = new " + TIMER + "($2);");
        }
    }

    public void edit(FieldAccess access) throws CannotCompileException {
        if (COLLECTIONS.equals(access.getClassName())) {
            if ("EMPTY_LIST".equals(access.getFieldName())) {
                access.replace("$_ = " + COLLECTIONS + ".emptyList();");
            } else if ("EMPTY_SET".equals(access.getFieldName())) {
                access.replace("$_ = " + COLLECTIONS + ".emptySet();");
            } else if ("EMPTY_MAP".equals(access.getFieldName())) {
                access.replace("$_ = " + COLLECTIONS + ".emptyMap();");
            }
        }
    }

    public void edit(MethodCall call) throws CannotCompileException {
        String callName = call.getMethodName();
        String className = call.getClassName();
        if (CLASS.equals(className)) {
            if ("isEnum".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".isEnum($0);");
            }
            if ("isAnnotation".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".isAnnotation($0);");
            } else if ("getEnumConstants".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".getEnumConstants($0);");
            } else if ("cast".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".cast($0, $1);");
            } else if ("asSubclass".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".asSubclass($0, $1);");
            } else if ("getSimpleName".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".getSimpleName($0);");
            } else if ("getCanonicalName".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".getCanonicalName($0);");
            } else if ("isAnonymousClass".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".isAnonymousClass($0);");
            } else if ("getGenericSuperclass".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".getGenericSuperclass($0);");
            } else if ("getGenericInterfaces".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".getGenericInterfaces($0);");
            }
        } else if (METHOD.equals(className)) {
            if ("getParameterAnnotations".equals(callName)) {
                call.replace("$_ = " + ANNOTATION_HELPER + ".getParameterAnnotations($0);");
            } else if ("getGenericReturnType".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".getGenericReturnType($0);");
            } else if ("getGenericReturnType".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".getGenericReturnType($0);");
            } else if ("getGenericParameterTypes".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".getGenericParameterTypes($0);");
            } else if ("getGenericExceptionTypes".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".getGenericExceptionTypes($0);");
            } else if ("toGenericString".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".toGenericString($0);");
            }
        } else if (FIELD.equals(className)) {
            if ("getGenericType".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".getGenericType($0);");
            } else if ("toGenericString".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".toGenericString($0);");
            }
        } else if (CONSTRUCTOR.equals(className)) {
            if ("getParameterAnnotations".equals(callName)) {
                call.replace("$_ = " + ANNOTATION_HELPER + ".getParameterAnnotations($0);");
            } else if ("getGenericParameterTypes".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".getGenericParameterTypes($0);");
            } else if ("getGenericExceptionTypes".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".getGenericExceptionTypes($0);");
            } else if ("toGenericString".equals(callName)) {
                call.replace("$_ = " + GENERICS_HELPER + ".toGenericString($0);");
            }
        } else if (STRING.equals(className)) {
            String signature = call.getSignature();
            if ("replace".equals(callName) && signature.equals("(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;")) {
                call.replace("$_ = " + STRING_REDIRECTS + ".replace($0, $1, $2);");
            } else if ("contains".equals(callName)) {
                call.replace("$_ = " + STRING_REDIRECTS + ".contains($0, $1);");
            } else if ("codePointAt".equals(callName)) {
                call.replace("$_ = " + STRING_REDIRECTS + ".codePointAt($0, $1);");
            } else if ("codePointBefore".equals(callName)) {
                call.replace("$_ = " + STRING_REDIRECTS + ".codePointBefore($0, $1);");
            } else if ("codePointCount".equals(callName)) {
                call.replace("$_ = " + STRING_REDIRECTS + ".codePointCount($0, $1, $2);");
            } else if ("offsetByCodePoints".equals(callName)) {
                call.replace("$_ = " + STRING_REDIRECTS + ".offsetByCodePoints($0, $1, $2);");
            }
        } else if (STRING_BUFFER.equals(className) || STRING_BUILDER.equals(className)) {
            if (bufferBuilderCodePointMethods.contains(callName)) {
                call.replace("$_ = " + STRING_REDIRECTS + "." + callName + "($0, $$);");
            }
        } else if (BOOLEAN.equals(className)) {
            if (callName.equals("parseBoolean")) {
                call.replace("$_ = " + Boolean.class.getName() + "." + callName + "($$);");
            } else if (callName.equals("compareTo")) {
                call.replace("$_ = " + Boolean.class.getName() + "." + callName + "($0, $1);");
            }
        } else if (INTEGER.equals(className)) {
            if (integerBitMethods.contains(callName)) {
                call.replace("$_ = " + NUMBER_HELPER + "." + callName + "($$);");
            }
        } else if (LONG.equals(className)) {
            if (integerBitMethods.contains(callName)) {
                call.replace("$_ = " + NUMBER_HELPER + "." + callName + "($$);");
            }
        } else if (CHARACTER.equals(className)) {
            if (characterCodePointMethods.contains(callName)) {
                call.replace("$_ = " + CHARACTER_REDIRECTS + "." + callName + "($$);");
            } else {
                String signature = callName + call.getSignature();
                if (characterOverloadMethods.contains(signature)) {
                    call.replace("$_ = " + CHARACTER_REDIRECTS + "." + callName + "($$);");
                }
            }
        } else if (MATCHER.equals(className)) {
            if ("quoteReplacement".equals(callName)) {
                call.replace("$_ = " + CLASS_REDIRECTS + ".quoteReplacement($1);");
            }
        } else if (SYSTEM.equals(className)) {
            if ("nanoTime".equals(callName)) {
                call.replace("$_ = " + CONCURRENT_UTILS + ".nanoTime();");
            }
        } else if (THREAD_LOCAL.equals(className)) {
            if ("remove".equals(callName)) {
                call.replace("$0.set(null);");
            }
        } else if (INHERTIABLE_THREAD_LOCAL.equals(className)) {
            if ("remove".equals(callName)) {
                call.replace("$0.set(null);");
            }
        } else if (CONDITION.equals(className)) {
            if ("awaitNanos".equals(callName)) {
                call.replace("$_ = $0.await($1, " + TIME_UNIT + ".NANOSECONDS);");
            }
        } else if (STRING_WRITER.equals(className)) {
            if ("append".equals(callName)) {
                String signature = call.getSignature();
                if (signature.equals("(Ljava/lang/CharSequence;)Ljava/io/StringWriter;")) {
                    call.replace("$_ = " + STRINGWRITER_HELPER + ".append($0, $1);");
                } else if (signature.equals("(C)Ljava/io/StringWriter;")) {
                    call.replace("$_ = " + STRINGWRITER_HELPER + ".append($0, $1);");
                } else if (signature.equals("(Ljava/lang/CharSequence;II)Ljava/io/StringWriter;")) {
                    call.replace("$_ = " + STRINGWRITER_HELPER + ".append($0, $1, $2, $3);");
                }
            }
        } else if (URL.equals(className)) {
            if ("toURI".equals(callName)) {
                call.replace("$_ = java.net.URI.create($0.toString());");
            }
        } else if (TIMER.equals(className) && "purge".equals(callName)) {
            call.replace("$_ = 0;");
        }
        if ((OBJECT.equals(className) || METHOD.endsWith(className) || CLASS.equals(className) || FIELD.equals(className) || CONSTRUCTOR.equals(className)) && "getTypeParameters".equals(callName)) {
            call.replace("$_ = " + GENERICS_HELPER + ".getTypeParameters($0);");
        }
        if (OBJECT.equals(className) || METHOD.endsWith(className) || CLASS.equals(className) || FIELD.equals(className) || CONSTRUCTOR.equals(className) || ACCESSIBLE_OBJECT.equals(className)) {
            if ("isAnnotationPresent".equals(callName)) {
                call.replace("$_ = " + ANNOTATION_HELPER + ".isAnnotationPresent($0, $1);");
            } else if ("getAnnotations".equals(callName)) {
                call.replace("$_ = " + ANNOTATION_HELPER + ".getAnnotations($0);");
            } else if ("getAnnotation".equals(callName)) {
                call.replace("$_ = " + ANNOTATION_HELPER + ".getAnnotation($0, $1);");
            } else if ("getDeclaredAnnotations".equals(callName)) {
                call.replace("$_ = " + ANNOTATION_HELPER + ".getDeclaredAnnotations($0);");
            }
        }
    }

    static {
        exceptionCtors.add("java.security.cert.CertificateException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.cert.CertificateException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.InvalidKeyException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.InvalidKeyException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.KeyManagementException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.KeyManagementException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.SignatureException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.SignatureException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("org.xml.sax.SAXException()V");
        exceptionCtors.add("org.xml.sax.SAXNotRecognizedException()V");
        exceptionCtors.add("java.security.cert.CRLException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.cert.CRLException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.cert.CertificateEncodingException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.cert.CertificateEncodingException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.IllegalArgumentException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.IllegalArgumentException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.GeneralSecurityException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.GeneralSecurityException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.cert.CertificateParsingException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.cert.CertificateParsingException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.KeyStoreException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.KeyStoreException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.ProviderException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.ProviderException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.InvalidAlgorithmParameterException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.InvalidAlgorithmParameterException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.IllegalStateException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.IllegalStateException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.UnsupportedOperationException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.UnsupportedOperationException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.SecurityException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.lang.SecurityException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.DigestException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.DigestException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("org.xml.sax.SAXNotSupportedException()V");
        exceptionCtors.add("java.security.NoSuchAlgorithmException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.NoSuchAlgorithmException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.spec.InvalidKeySpecException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.spec.InvalidKeySpecException(Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.KeyException(Ljava/lang/String;Ljava/lang/Throwable;)V");
        exceptionCtors.add("java.security.KeyException(Ljava/lang/Throwable;)V");
        integerBitMethods = new HashSet();
        String[] s = new String[]{"highestOneBit", "lowestOneBit", "numberOfLeadingZeros", "bitCount", "rotateLeft", "rotateRight", "reverse", "signum", "reverseBytes"};
        for (int i = 0; i < s.length; ++i) {
            integerBitMethods.add(s[i]);
        }
        characterCodePointMethods = new HashSet();
        characterCodePointMethods.add("charCount");
        characterCodePointMethods.add("codePointAt");
        characterCodePointMethods.add("codePointBefore");
        characterCodePointMethods.add("codePointCount");
        characterCodePointMethods.add("isHighSurrogate");
        characterCodePointMethods.add("isLowSurrogate");
        characterCodePointMethods.add("isSurrogatePair");
        characterCodePointMethods.add("offsetByCodePoints");
        characterCodePointMethods.add("toChars");
        characterCodePointMethods.add("toCodePoint");
        characterCodePointMethods.add("reverseBytes");
        characterOverloadMethods = new HashSet();
        characterOverloadMethods.add("isLowerCase(I)Z");
        characterOverloadMethods.add("isUpperCase(I)Z");
        characterOverloadMethods.add("isTitleCase(I)Z");
        characterOverloadMethods.add("isDigit(I)Z");
        characterOverloadMethods.add("isDefined(I)Z");
        characterOverloadMethods.add("isLetter(I)Z");
        characterOverloadMethods.add("isLetterOrDigit(I)Z");
        characterOverloadMethods.add("isJavaIdentifierStart(I)Z");
        characterOverloadMethods.add("isJavaIdentifierPart(I)Z");
        characterOverloadMethods.add("isUnicodeIdentifierStart(I)Z");
        characterOverloadMethods.add("isUnicodeIdentifierPart(I)Z");
        characterOverloadMethods.add("isUnicodeIdentifierIgnorable(I)Z");
        characterOverloadMethods.add("toLowerCase(I)I");
        characterOverloadMethods.add("toUpperCase(I)I");
        characterOverloadMethods.add("toTitleCase(I)I");
        characterOverloadMethods.add("digit(I)I");
        characterOverloadMethods.add("getNumericValue(I)I");
        characterOverloadMethods.add("isSpaceChar(I)Z");
        characterOverloadMethods.add("isWhitespace(I)Z");
        characterOverloadMethods.add("isISOControl(I)Z");
        characterOverloadMethods.add("getType(I)I");
        characterOverloadMethods.add("getDirectionality(I)B");
        characterOverloadMethods.add("isMirrored(I)Z");
        characterOverloadMethods.add("reverseBytes(C)C");
        bufferBuilderCodePointMethods = new HashSet();
        bufferBuilderCodePointMethods.add("appendCodePoint");
        bufferBuilderCodePointMethods.add("codePointAt");
        bufferBuilderCodePointMethods.add("codePointBefore");
        bufferBuilderCodePointMethods.add("codePointCount");
        bufferBuilderCodePointMethods.add("offsetByCodePoints");
        CTOR_TIMER1 = TIMER + "(Ljava/lang/String;)V";
        CTOR_TIMER2 = TIMER + "(Ljava/lang/String;Z)V";
    }
}

