/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ant.tasks.retrocheck;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javassist.ClassPath;
import javassist.NotFoundException;

/**
 * CheckerClassPath.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 33 $
 */
public class CheckerClassPath implements ClassPath
{
   /** The classloader */
   private ClassLoader cl;
   
   /**
    * Create a new CheckerClassPath.
    * 
    * @param cl the classloader
    */
   public CheckerClassPath(ClassLoader cl)
   {
      this.cl = cl;
   }

   public void close()
   {
   }

   public URL find(String classname)
   {
      String jarname = classname.replace('.', '/') + ".class";
      URL url = cl.getResource(jarname);
      return url;
   }

   public InputStream openClassfile(String classname) throws NotFoundException
   {
      URL url = find(classname);
      if (url == null)
         throw new NotFoundException("Cannot find " + classname);
      try
      {
         return url.openStream();
      }
      catch (IOException e)
      {
         throw new NotFoundException("Unable to open stream " + url, e);
      }
   }
}
