/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.lang;

/**
 * Autoboxing.
 * 
 * @author scott.stark@jboss.com
 * @author adrian@jboss.com
 * @version $Revision$
 */
public class Autoboxing
{
   /**
    * Box a byte
    * 
    * @param n the number
    * @return the boxed value 
    */
   public final static Byte valueOf(final byte n)
   {
      return new Byte(n);
   }

   /**
    * Box a char
    * 
    * @param n the number
    * @return the boxed value 
    */
   public final static Character valueOf(final char n)
   {
      return new Character(n);
   }
   
   /**
    * Box a short
    * 
    * @param n the number
    * @return the boxed value 
    */
   public final static Short valueOf(final short n)
   {
      return new Short(n);
   }
   
   /**
    * Box an integer
    * 
    * @param n the number
    * @return the boxed value 
    */
   public final static Integer valueOf(final int n)
   {
      return new Integer(n);
   }

   /**
    * Box a long 
    * 
    * @param n the number
    * @return the boxed value 
    */
   public final static Long valueOf(final long n)
   {
      return new Long(n);
   }

   /**
    * Box a float 
    * 
    * @param n the number
    * @return the boxed value 
    */
   public final static Float valueOf(final float n)
   {
      return new Float(n);
   }

   /**
    * Box a double 
    * 
    * @param n the number
    * @return the boxed value 
    */
   public final static Double valueOf(final double n)
   {
      return new Double(n);
   }
}
