/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.lang;

import java.lang.reflect.Constructor;

/**
 @author Scott.Stark@jboss.org
 @version $Revision: 200 $ */
public class ExceptionHelper
{
   public static Throwable createExceptionWithCause(Class exClass, Object... vargs)
   {
      Throwable ex = null;
      try
      {
         // Check for a msg
         String msg = null;
         Throwable cause = null;
         for(Object o : vargs)
         {
            if( o instanceof String )
               msg = (String) o;
            else if( o instanceof Throwable )
               cause = (Throwable) o;
         }
         Class[] sig = {String.class};
         try
         {
            Constructor ctor = exClass.getConstructor(sig);
            ex = (Throwable) ctor.newInstance(new Object[] { msg });
         }
         catch(NoSuchMethodException e)
         {
            ex = (Throwable) exClass.newInstance();
         }
         ex.initCause(cause);
      }
      catch(Exception e)
      {
         e.printStackTrace();
      }
      return ex;
   }
}
