/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.lang;

/**
 * Implementations of java.lang.Integer and other Number methods added in jdk5
 * Code from http://www.hackersdelight.org/HDcode.htm
 * 
 * @author Elias Ross
 * @version $Revision: 200 $
 */
public class NumberHelper
{

   /**
    * {@link http://www.hackersdelight.org/HDcode/flp2.c}
    */
   public static int highestOneBit(int i)
   {
      i |= (i >> 1);
      i |= (i >> 2);
      i |= (i >> 4);
      i |= (i >> 8);
      i |= (i >> 16);
      return i - (i >>> 1);
   }

   /**
    * {@link http://www.topcoder.com/tc?module=Static&d1=tutorials&d2=bitManipulation}
    */
   public static int lowestOneBit(int i)
   {
      return i & -i;
   }

   /**
    * {@link http://www.hackersdelight.org/HDcode/nlz.c}
    */
   public static int numberOfLeadingZeros(int i)
   {
      if (i == 0)
         return 32;
      int n = 1;
      if (i >>> 16 == 0)
      {
         n += 16;
         i <<= 16;
      }
      if (i >>> 24 == 0)
      {
         n += 8;
         i <<= 8;
      }
      if (i >>> 28 == 0)
      {
         n += 4;
         i <<= 4;
      }
      if (i >>> 30 == 0)
      {
         n += 2;
         i <<= 2;
      }
      n -= i >>> 31;
      return n;
   }

   /**
    * {@link http://www.hackersdelight.org/HDcode/ntz.c}
    */
   public static int numberOfTrailingZeros(int i)
   {
      int y;
      if (i == 0)
         return 32;
      int n = 31;
      y = i << 16;
      if (y != 0)
      {
         n = n - 16;
         i = y;
      }
      y = i << 8;
      if (y != 0)
      {
         n = n - 8;
         i = y;
      }
      y = i << 4;
      if (y != 0)
      {
         n = n - 4;
         i = y;
      }
      y = i << 2;
      if (y != 0)
      {
         n = n - 2;
         i = y;
      }
      return n - ((i << 1) >>> 31);
   }

   /**
    * {@link http://www.hackersdelight.org/HDcode/pop.c}
    */
   public static int bitCount(int i)
   {
      i = i - ((i >>> 1) & 0x55555555);
      i = (i & 0x33333333) + ((i >>> 2) & 0x33333333);
      i = (i + (i >>> 4)) & 0x0f0f0f0f;
      i = i + (i >>> 8);
      i = i + (i >>> 16);
      return i & 0x3f;
   }

   public static int rotateLeft(int i, int distance)
   {
      return (i << distance) | (i >>> -distance);
   }

   public static int rotateRight(int i, int distance)
   {
      return (i >>> distance) | (i << -distance);
   }

   /**
    * {@link http://www.hackersdelight.org/HDcode/reverse.c}
    */
   public static int reverse(int i)
   {
      i = (i & 0x55555555) << 1 | (i >>> 1) & 0x55555555;
      i = (i & 0x33333333) << 2 | (i >>> 2) & 0x33333333;
      i = (i & 0x0f0f0f0f) << 4 | (i >>> 4) & 0x0f0f0f0f;
      i = (i << 24) | ((i & 0xff00) << 8) | ((i >>> 8) & 0xff00) | (i >>> 24);
      return i;
   }

   public static int signum(int i)
   {
      return (i >> 31) | (-i >>> 31);
   }

   public static int reverseBytes(int i)
   {
      return ((i >>> 24)) | ((i >> 8) & 0xFF00) | ((i << 8) & 0xFF0000) | ((i << 24));
   }

   // long methods

   public static long highestOneBit(long i)
   {
      i |= (i >> 1);
      i |= (i >> 2);
      i |= (i >> 4);
      i |= (i >> 8);
      i |= (i >> 16);
      i |= (i >> 32);
      return i - (i >>> 1);
   }

   public static long lowestOneBit(long i)
   {
      return i & -i;
   }

   public static int numberOfLeadingZeros(long i)
   {
      if (i == 0)
         return 64;
      int n = 1;
      int x = (int) (i >>> 32);
      if (x == 0)
      {
         n += 32;
         x = (int) i;
      }
      if (x >>> 16 == 0)
      {
         n += 16;
         x <<= 16;
      }
      if (x >>> 24 == 0)
      {
         n += 8;
         x <<= 8;
      }
      if (x >>> 28 == 0)
      {
         n += 4;
         x <<= 4;
      }
      if (x >>> 30 == 0)
      {
         n += 2;
         x <<= 2;
      }
      n -= x >>> 31;
      return n;
   }

   public static int numberOfTrailingZeros(long i)
   {
      int x, y;
      if (i == 0)
         return 64;
      int n = 63;
      y = (int) i;
      if (y != 0)
      {
         n = n - 32;
         x = y;
      }
      else
         x = (int) (i >>> 32);
      y = x << 16;
      if (y != 0)
      {
         n = n - 16;
         x = y;
      }
      y = x << 8;
      if (y != 0)
      {
         n = n - 8;
         x = y;
      }
      y = x << 4;
      if (y != 0)
      {
         n = n - 4;
         x = y;
      }
      y = x << 2;
      if (y != 0)
      {
         n = n - 2;
         x = y;
      }
      return n - ((x << 1) >>> 31);
   }

   public static int bitCount(long i)
   {
      i = i - ((i >>> 1) & 0x5555555555555555L);
      i = (i & 0x3333333333333333L) + ((i >>> 2) & 0x3333333333333333L);
      i = (i + (i >>> 4)) & 0x0f0f0f0f0f0f0f0fL;
      i = i + (i >>> 8);
      i = i + (i >>> 16);
      i = i + (i >>> 32);
      return (int) i & 0x7f;
   }

   public static long rotateLeft(long i, int distance)
   {
      return (i << distance) | (i >>> -distance);
   }

   public static long rotateRight(long i, int distance)
   {
      return (i >>> distance) | (i << -distance);
   }

   public static long reverse(long i)
   {
      i = (i & 0x5555555555555555L) << 1 | (i >>> 1) & 0x5555555555555555L;
      i = (i & 0x3333333333333333L) << 2 | (i >>> 2) & 0x3333333333333333L;
      i = (i & 0x0f0f0f0f0f0f0f0fL) << 4 | (i >>> 4) & 0x0f0f0f0f0f0f0f0fL;
      i = (i & 0x00ff00ff00ff00ffL) << 8 | (i >>> 8) & 0x00ff00ff00ff00ffL;
      i = (i << 48) | ((i & 0xffff0000L) << 16) | ((i >>> 16) & 0xffff0000L) | (i >>> 48);
      return i;
   }

   public static int signum(long i)
   {
      return (int) ((i >> 63) | (-i >>> 63));
   }

   public static long reverseBytes(long i)
   {
      i = (i & 0x00ff00ff00ff00ffL) << 8 | (i >>> 8) & 0x00ff00ff00ff00ffL;
      return (i << 48) | ((i & 0xffff0000L) << 16) | ((i >>> 16) & 0xffff0000L) | (i >>> 48);
   }

}
