/*
  * JBoss, Home of Professional Open Source
  * Copyright 2006, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */

package org.jboss.lang.reflect;

/**
* TypeVariable is the common superinterface for type variables of kinds. A
* type variable is created the first time it is needed by a reflective method,
* as specified in this package. If a type variable t is referenced by a type
* (i.e, class, interface or annotation type) T, and T is declared by the nth
* enclosing class of T (see JLS 8.1.2), then the creation of t requires the
* resolution (see JVMS 5) of the ith enclosing class of T, for i = 0 to n,
* inclusive. Creating a type variable must not cause the creation of its
* bounds. Repeated creation of a type variable has no effect.
* 
* Multiple objects may be instantiated at run-time to represent a given type
* variable. Even though a type variable is created only once, this does not
* imply any requirement to cache instances representing the type variable.
* However, all instances representing a type variable must be equal() to each
* other. As a consequence, users of type variables must not rely on the identity
* of instances of classes implementing this interface.
* 
* The type parameter D represents the type of generic declaration that declared
* the underlying type variable.
*  
* @author Scott.Stark@jboss.org
* @version $Revision: 200 $
*/
public interface TypeVariable
  extends Type
{
  /**
   * Returns an array of Type objects representing the upper bound(s) of this
   * type variable. Note that if no upper bound is explicitly declared, the
   * upper bound is Object.
   * 
   * For each upper bound B:
   * if B is a parameterized type or a type variable, it is created, (see
   * ParameterizedType for the details of the creation process for
   * parameterized types). Otherwise, B is resolved. 
   * @return an array of Types representing the upper bound(s) of this type variable
   * @throws TypeNotPresentException - if any of the bounds refers to a
   * non-existent type declaration
   * @throws MalformedParameterizedTypeException - if any of
   * the bounds refer to a parameterized type that cannot be instantiated for
   * any reason
   */
  public Object[] getBounds();

  /**
   * 
   * @return the GenericDeclaration object representing the generic
   * declaration declared this type variable.
   */
  public Object getGenericDeclaration();

  /**
   * 
   * @return Returns the name of this type variable, as it occurs in the
   * source code.
   */
  public String getName();
}
