/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * EnumMap.
 *
 * @todo EnumMap
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 200 $
 */
public class EnumMap<K extends Enum<K>, V> extends AbstractMap<K, V> implements Cloneable, Serializable
{
   /** The serialVersionUID @todo fix the serialization */
   private static final long serialVersionUID = 4921388988138518901L;

   // @todo bitset as described in the javadoc (using TreeMap for iterator ordering)
   private TreeMap<K, V> values;
   
   private final Class<K> enumType;
   
   private final Enum[] constants;  
   
   public EnumMap(Class<K> keyType)
   {
      if (keyType.isEnum() == false)
         throw new IllegalArgumentException("Not an enum " + keyType);
      this.enumType = keyType;
      values = new TreeMap();
      constants = enumType.getEnumConstants();
   }

   public EnumMap(EnumMap<K, ? extends V> m)
   {
      this(m.enumType);
      values.putAll(m);
   }

   public EnumMap(Map<K, ? extends V> m)
   {
      if (m instanceof EnumMap)
      {
         EnumMap<K, V> em = (EnumMap<K, V>) m;
         this.enumType = em.enumType;
         values = (TreeMap<K, V>) em.values.clone();
         constants = em.constants;
      }
      else
      {
         if (m.isEmpty())
            throw new IllegalArgumentException("Empty collection");
         enumType = m.keySet().iterator().next().getDeclaringClass();
         constants = enumType.getEnumConstants();
         values = new TreeMap(m);
      }
   }
   
   public void clear()
   {
      values.clear();
   }
   
   public EnumMap<K,V> clone()
   {
      EnumMap result;
      try
      {
         result = (EnumMap<K, V>) super.clone();
      }
      catch (CloneNotSupportedException e)
      {
         throw new Error(e);
      }
      result.values = (TreeMap<K, V>) values.clone();
      return result;
   }
   
   public boolean containsKey(Object key)
   {
      return values.containsKey(key);
   }
   
   public boolean containsValue(Object value)
   {
      return values.containsValue(value);
   }
   
   public Set<Map.Entry<K, V>> entrySet()
   {
      return values.entrySet();
   }
   
   public V get(Object key)
   {
      return values.get(key);
   }
   
   public Set<K> keySet()
   {
      return values.keySet();
   }
   
   public V put(K key, V value)
   {
      return values.put(key, value);
   }
   
   public void putAll(Map<? extends K, ? extends V> m)
   {
      values.putAll(m);
   }
   
   public V remove(Object key)
   {
      return values.remove(key);
   }
   
   public int size()
   {
      return values.size();
   }
   
   public Collection<V> values()
   {
      return values.values();
   }
}
