/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.util;

import java.io.StringWriter;

/**
 * Helper methods for StringWriter jdk5 additions
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 200 $
 */
public class StringWriterHelper
{
   /**
    * jdk1.4 implementation of StringWriter.append(CharSequence)
    * @param sw
    * @param cs
    * @return the StringWriter
    */
   public static StringWriter append(StringWriter sw, CharSequence cs)
   {
      if( cs == null )
         cs = "null";
      int length = cs.length();
      for(int n = 0; n < length; n ++)
      {
         char c = cs.charAt(n);
         sw.write(c);
      }
      return sw;
   }
   /**
    * jdk1.4 implementation of StringWriter.append(CharSequence, int, int)
    * @param sw
    * @param cs
    * @return the StringWriter
    */
   public static StringWriter append(StringWriter sw, CharSequence cs,
      int start, int end)
   {
      if( cs == null )
         cs = "null";
      sw.write(cs.subSequence(start, end).toString());
      return sw;
   }
   /**
    * jdk1.4 implementation of StringWriter.append(char)
    * @param sw
    * @param c
    * @return the StringWriter
    */
   public static StringWriter append(StringWriter sw, char c)
   {
      sw.write(c);
      return sw;
   }
}
