/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.weaver.retro;

import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

import org.jboss.lang.Autoboxing;

/**
 * AutoboxCodeConverter.
 * 
 * @author Scott.Stark@jboss.org
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision$
 */
public class AutoboxCodeConverter extends CodeConverter
{
   public AutoboxCodeConverter(ClassPool pool) throws NotFoundException, CannotCompileException
   {
      CtClass autoboxClass = pool.get(Autoboxing.class.getName());
      autoBox(pool, autoboxClass, Byte.class.getName(), Byte.TYPE.getName());
      autoBox(pool, autoboxClass, Character.class.getName(), Character.TYPE.getName());
      autoBox(pool, autoboxClass, Short.class.getName(), Short.TYPE.getName());
      autoBox(pool, autoboxClass, Integer.class.getName(), Integer.TYPE.getName());
      autoBox(pool, autoboxClass, Long.class.getName(), Long.TYPE.getName());
      autoBox(pool, autoboxClass, Double.class.getName(), Double.TYPE.getName());
      autoBox(pool, autoboxClass, Float.class.getName(), Float.TYPE.getName());
   }

   public void autoBox(ClassPool pool, CtClass autoboxClass, String boxed, String unboxed) throws NotFoundException, CannotCompileException
   {
      CtClass boxedClass = pool.get(boxed);
      CtClass unboxedClass = pool.get(unboxed);
      CtClass[] sig = { unboxedClass };
      CtMethod autoboxValueOf = autoboxClass.getDeclaredMethod("valueOf", sig);
      CtMethod originalValueOf = boxedClass.getDeclaredMethod("valueOf", sig);
      redirectMethodCall(originalValueOf, autoboxValueOf);
   }
}
