/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.javassist;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.Descriptor;
import javassist.scopedpool.ScopedClassPoolRepository;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;

public class JavassistUtil {
    static final ScopedClassPoolRepository repository = ScopedClassPoolRepositoryImpl.getInstance();

    public static CtClass getCtClass(Class clazz) {
        try {
            ClassPool pool = repository.findClassPool(clazz.getClassLoader());
            return pool.get(clazz.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to load CtClass for " + clazz, e);
        }
    }

    public static CtMethod getCtMethod(Method method) {
        CtClass clazz = JavassistUtil.getCtClass(method.getDeclaringClass());
        Class<?>[] parameters = method.getParameterTypes();
        CtClass[] params = new CtClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = JavassistUtil.getCtClass(parameters[i]);
        }
        CtClass returnType = JavassistUtil.getCtClass(method.getReturnType());
        String descriptor = Descriptor.ofMethod((CtClass)returnType, (CtClass[])params);
        try {
            return clazz.getMethod(method.getName(), descriptor);
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to find method " + method + " descriptor=" + descriptor, e);
        }
    }

    public static CtConstructor getCtConstructor(Constructor constructor) {
        CtClass clazz = JavassistUtil.getCtClass(constructor.getDeclaringClass());
        Class<?>[] parameters = constructor.getParameterTypes();
        CtClass[] params = new CtClass[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            params[i] = JavassistUtil.getCtClass(parameters[i]);
        }
        String descriptor = Descriptor.ofConstructor((CtClass[])params);
        try {
            return clazz.getConstructor(descriptor);
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to find constructor descriptor=" + descriptor, e);
        }
    }

    public static CtField getCtField(Field field) {
        CtClass clazz = JavassistUtil.getCtClass(field.getDeclaringClass());
        try {
            return clazz.getField(field.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to find field " + field, e);
        }
    }
}

