/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.lang.Annotation;
import org.jboss.lang.EnumImpl;
import org.jboss.lang.GenericsHelper;
import org.jboss.lang.StringRedirects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRedirects {
    private static final int SYNTHETIC = 4096;

    public static boolean isAnnotation(Class clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getName().equals("java.lang.Annotation")) {
                return true;
            }
            if (interfaces[i].getName().equals(Annotation.class.getName())) {
                return true;
            }
            if (!ClassRedirects.isAnnotation(interfaces[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnum(Class clazz) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return false;
        }
        if (EnumImpl.class == clazz.getSuperclass()) {
            return true;
        }
        return superClass.getName().equals("java.lang.Enum");
    }

    public static <T extends EnumImpl<T>> T[] getEnumConstants(Class<T> enumType) {
        ArrayList<Object> list = EnumImpl.getEnumConstants(enumType);
        Object[] array = (Object[])Array.newInstance(enumType, list.size());
        return (EnumImpl[])list.toArray(array);
    }

    public static <T> T cast(Class<T> clazz, Object o) {
        if (o != null && !clazz.isInstance(o)) {
            throw new ClassCastException("Expected " + clazz.getName() + " got " + o.getClass().getName());
        }
        return (T)o;
    }

    public static <T> Class<? extends T> asSubclass(Class<T> clazz, Class thisClazz) {
        if (clazz.isAssignableFrom(thisClazz)) {
            return thisClazz;
        }
        throw new ClassCastException("Expected " + clazz.getName() + " got " + thisClazz.getName());
    }

    public static String replace(String string, CharSequence target, CharSequence replacement) {
        return StringRedirects.replace(string, target, replacement);
    }

    public static boolean contains(String string, CharSequence s) {
        return StringRedirects.contains(string, s);
    }

    public static String quoteReplacement(String string) {
        return StringRedirects.quoteReplacement(string);
    }

    public static String getSimpleName(Class clazz) {
        int dollar;
        boolean isArray = clazz.isArray();
        if (isArray) {
            String arrayName = ClassRedirects.getSimpleName(clazz.getComponentType()) + "[]";
            return arrayName;
        }
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        if (dot >= 0 && (dollar = (name = name.substring(dot + 1)).lastIndexOf(36)) >= 0) {
            int index;
            name = name.substring(dollar + 1);
            for (index = 0; index < name.length() && Character.isDigit(name.charAt(index)); ++index) {
            }
            if (index > 0) {
                name = name.substring(index);
            }
        }
        return name;
    }

    public static String getCanonicalName(Class clazz) {
        if (clazz.isArray()) {
            String name = clazz.getComponentType().getCanonicalName();
            if (name != null) {
                name = name + "[]";
            }
            return name;
        }
        String name = null;
        if (!ClassRedirects.isAnonymousClass(clazz)) {
            name = clazz.getName();
            name = name.replace('$', '.');
        }
        return name;
    }

    public static boolean isAnonymousClass(Class clazz) {
        String name = ClassRedirects.getSimpleName(clazz);
        return name.length() == 0;
    }

    public static boolean isSynthetic(Class clazz) {
        throw new UnsupportedOperationException("isSynthetic is a TODO");
    }

    public static boolean isLocalClass(Class clazz) {
        throw new UnsupportedOperationException("isLocalClass is a TODO");
    }

    public static boolean isMemberClass(Class clazz) {
        throw new UnsupportedOperationException("isMemberClass is a TODO");
    }

    public static Object getGenericSuperclass(Class clazz) {
        return GenericsHelper.getGenericSuperclass(clazz);
    }

    public static Object[] getGenericInterfaces(Class clazz) {
        return GenericsHelper.getGenericInterfaces(clazz);
    }

    public static Method getEnclosingMethod(Class clazz) {
        throw new UnsupportedOperationException("getEnclosingMethod cannot be implemented");
    }

    public static Constructor<?> getEnclosingConstructor(Class clazz) {
        throw new UnsupportedOperationException("getEnclosingConstructor cannot be implemented");
    }

    public static Class<?> getEnclosingClass(Class clazz) {
        throw new UnsupportedOperationException("getEnclosingClass cannot be implemented");
    }

    private ClassRedirects() {
    }
}

