/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.lang.JBossStringBuilder;

public class StringRedirects {
    public static String replace(String string, CharSequence target, CharSequence replacement) {
        Pattern pattern = Pattern.compile(((Object)target).toString(), 16);
        Matcher matcher = pattern.matcher(string);
        String quotedReplacement = StringRedirects.quoteReplacement(((Object)replacement).toString());
        return matcher.replaceAll(quotedReplacement);
    }

    public static boolean contains(String string, CharSequence s) {
        return string.indexOf(((Object)s).toString()) != -1;
    }

    public static String quoteReplacement(String string) {
        StringBuilder builder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\\') {
                builder.append("\\\\");
                continue;
            }
            if (c == '$') {
                builder.append("\\$");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static int codePointAt(String string, int index) {
        return string.charAt(index);
    }

    public static int codePointBefore(String string, int index) {
        return string.charAt(index - 1);
    }

    public static int codePointCount(String string, int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > string.length() || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("Arguments provided to codePointCount are out of range");
        }
        return endIndex - beginIndex;
    }

    public static int offsetByCodePoints(String string, int index, int codePointOffset) {
        int length = string.length();
        if (index < 0 || index > length || codePointOffset + index > length || codePointOffset + index < 0) {
            throw new IndexOutOfBoundsException("Arguments provided to offsetByCodePoints are out of range");
        }
        return index + codePointOffset;
    }

    public static StringBuffer appendCodePoint(StringBuffer buffer, int codePoint) {
        return buffer.append((char)codePoint);
    }

    public static int codePointAt(StringBuffer buffer, int index) {
        return buffer.charAt(index);
    }

    public static int codePointBefore(StringBuffer buffer, int index) {
        return buffer.charAt(index - 1);
    }

    public static int codePointCount(StringBuffer buffer, int beginIndex, int endIndex) {
        return endIndex - beginIndex;
    }

    public static int offsetByCodePoints(StringBuffer buffer, int index, int codePointOffset) {
        return index + codePointOffset;
    }

    public static JBossStringBuilder appendCodePoint(JBossStringBuilder builder, int codePoint) {
        return builder.append((char)codePoint);
    }

    public static int codePointAt(JBossStringBuilder builder, int index) {
        return builder.charAt(index);
    }

    public static int codePointBefore(JBossStringBuilder builder, int index) {
        return builder.charAt(index - 1);
    }

    public static int codePointCount(JBossStringBuilder builder, int beginIndex, int endIndex) {
        return endIndex - beginIndex;
    }

    public static int offsetByCodePoints(JBossStringBuilder builder, int index, int codePointOffset) {
        return index + codePointOffset;
    }
}

