/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindExceptionCtorChanges {
    static Logger log = Logger.getLogger("FindExceptionCtorChanges");

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("Usage: FindExceptionCtorChanges path-to-jdk14/rt.jar path-to-jdk15/rt.jar");
        }
        String jdk14Jar = args[0];
        JarFile jdk14JarFile = new JarFile(jdk14Jar);
        ClassPool jdk14Pool = new ClassPool();
        jdk14Pool.appendClassPath(jdk14Jar);
        CtClass jdk14Throwable = jdk14Pool.get("java.lang.Throwable");
        HashMap<String, CtClass> throwables14 = new HashMap<String, CtClass>();
        FindExceptionCtorChanges.scanJar(jdk14JarFile, jdk14Pool, jdk14Throwable, throwables14);
        log.info("jdk14 throwable count: " + throwables14.size());
        String jdk5Jar = args[1];
        JarFile jdk5JarFile = new JarFile(jdk5Jar);
        ClassPool jdk5Pool = new ClassPool();
        jdk5Pool.appendClassPath(jdk5Jar);
        CtClass jdk5Throwable = jdk5Pool.get("java.lang.Throwable");
        HashMap<String, CtClass> throwables5 = new HashMap<String, CtClass>();
        FindExceptionCtorChanges.scanJar(jdk5JarFile, jdk5Pool, jdk5Throwable, throwables5);
        log.info("jdk5 throwable count: " + throwables5.size());
        CtorComparator compare = new CtorComparator();
        StringBuffer exceptionCtors = new StringBuffer();
        for (CtClass jdk14EX : throwables14.values()) {
            CtConstructor[] ctors5;
            CtConstructor[] ctors14;
            CtClass jdk5EX = throwables5.get(jdk14EX.getName());
            if (jdk5EX == null || (ctors14 = jdk14EX.getConstructors()).length == (ctors5 = jdk5EX.getConstructors()).length) continue;
            TreeSet<CtConstructor> jdk5Set = new TreeSet<CtConstructor>(compare);
            jdk5Set.addAll(Arrays.asList(ctors5));
            List<CtConstructor> jdk14Set = Arrays.asList(ctors14);
            if (jdk14EX.getName().equals("java.lang.IllegalArgumentException")) {
                log.info("jdk14(IllegalArgumentException): " + jdk14Set);
                log.info("jdk5(IllegalArgumentException): " + jdk5Set);
            }
            jdk5Set.removeAll(jdk14Set);
            for (CtConstructor ctor : jdk5Set) {
                exceptionCtors.append("exceptionCtors.add(\"");
                exceptionCtors.append(ctor.getDeclaringClass().getName());
                exceptionCtors.append(ctor.getSignature());
                exceptionCtors.append("\"),\n");
            }
        }
        log.info(exceptionCtors.toString());
    }

    private static void scanJar(JarFile jar, ClassPool pool, CtClass langThrowable, HashMap<String, CtClass> throwables) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            name = name.replace('/', '.');
            name = name.substring(0, name.length() - 6);
            try {
                CtClass clazz = pool.get(name);
                if (!clazz.subtypeOf(langThrowable)) continue;
                throwables.put(name, clazz);
            }
            catch (NotFoundException e) {
                log.warning(e.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CtorComparator
    implements Comparator<CtConstructor> {
        CtorComparator() {
        }

        @Override
        public int compare(CtConstructor o1, CtConstructor o2) {
            String sig1 = o1.getSignature();
            String sig2 = o2.getSignature();
            return sig1.compareTo(sig2);
        }
    }
}

