/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4921388988138518901L;
    private TreeMap<K, V> values;
    private final Class<K> enumType;
    private final Enum[] constants;

    public EnumMap(Class<K> keyType) {
        if (!keyType.isEnum()) {
            throw new IllegalArgumentException("Not an enum " + keyType);
        }
        this.enumType = keyType;
        this.values = new TreeMap();
        this.constants = (Enum[])this.enumType.getEnumConstants();
    }

    public EnumMap(EnumMap<K, ? extends V> m) {
        this(m.enumType);
        this.values.putAll(m);
    }

    public EnumMap(Map<K, ? extends V> m) {
        if (m instanceof EnumMap) {
            EnumMap em = (EnumMap)m;
            this.enumType = em.enumType;
            this.values = (TreeMap)em.values.clone();
            this.constants = em.constants;
        } else {
            if (m.isEmpty()) {
                throw new IllegalArgumentException("Empty collection");
            }
            this.enumType = ((Enum)m.keySet().iterator().next()).getDeclaringClass();
            this.constants = (Enum[])this.enumType.getEnumConstants();
            this.values = new TreeMap<K, V>(m);
        }
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public EnumMap<K, V> clone() {
        EnumMap result;
        try {
            result = (EnumMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
        result.values = (TreeMap)this.values.clone();
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.values.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.values.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.values.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.values.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Collection<V> values() {
        return this.values.values();
    }
}

