/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSet<E extends Enum>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3136546369353376452L;
    private TreeSet<E> values;
    private final Class<E> enumType;
    private final Enum[] constants;

    private EnumSet(Class<E> enumType) {
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("Not an enum " + enumType);
        }
        this.enumType = enumType;
        this.values = new TreeSet();
        this.constants = (Enum[])enumType.getEnumConstants();
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> enumType) {
        return new EnumSet<E>(enumType);
    }

    public static <E extends Enum<E>> EnumSet<E> allOf(Class<E> enumType) {
        EnumSet<Enum> result = new EnumSet<Enum>(enumType);
        for (Enum e : result.constants) {
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(EnumSet<E> s) {
        return s.clone();
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> c) {
        if (c instanceof EnumSet) {
            return ((EnumSet)c).clone();
        }
        if (c.isEmpty()) {
            throw new IllegalArgumentException("Empty collection");
        }
        Iterator<E> iter = c.iterator();
        Enum first = (Enum)iter.next();
        EnumSet<Enum> result = EnumSet.of(first);
        while (iter.hasNext()) {
            result.add((Enum)iter.next());
        }
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(EnumSet<E> s) {
        EnumSet<E> result = EnumSet.allOf(s.enumType);
        result.removeAll(s);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e) {
        EnumSet<E> result = new EnumSet<E>(e.getDeclaringClass());
        result.add(e);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2) {
        EnumSet<E> result = new EnumSet<E>(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3) {
        EnumSet<E> result = new EnumSet<E>(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3, E e4) {
        EnumSet<E> result = new EnumSet<E>(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        EnumSet<E> result = new EnumSet<E>(e1.getDeclaringClass());
        result.add(e1);
        result.add(e2);
        result.add(e3);
        result.add(e4);
        result.add(e5);
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E first, E ... rest) {
        EnumSet<E> result = EnumSet.of(first);
        for (E e : rest) {
            result.add(e);
        }
        return result;
    }

    public static <E extends Enum<E>> EnumSet<E> range(E from, E to) {
        EnumSet<Enum> result = new EnumSet<Enum>(from.getDeclaringClass());
        for (int i = from.ordinal(); i <= to.ordinal(); ++i) {
            result.add(result.constants[i]);
        }
        return result;
    }

    public EnumSet<E> clone() {
        EnumSet result;
        try {
            result = (EnumSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
        result.values = (TreeSet)this.values.clone();
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.values.iterator();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean add(E o) {
        return this.values.add(o);
    }
}

