/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weaver.retro;

import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Inherited;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ClassFileWriter;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.expr.ExprEditor;
import org.jboss.weaver.ClassFileInfo;
import org.jboss.weaver.Weaver;
import org.jboss.weaver.retro.AutoboxCodeConverter;
import org.jboss.weaver.retro.ClassRedirectEditor;

public class WeaverRetroJdk14
extends Weaver {
    private static Logger log = Logger.getLogger(WeaverRetroJdk14.class.getName());
    public final String DEFAULT_CLASS_RENAMES_RESOURCE = "/org/jboss/weaver/retro/class-renames.properties";

    public void init() {
        this.initClassRenames();
        ClassPool pool = ClassPool.getDefault();
        try {
            if (this.getClasspath() != null) {
                pool.appendPathList(this.getClasspath());
            }
            this.addCodeConverter(new AutoboxCodeConverter(pool));
        }
        catch (NotFoundException nfe) {
            log.severe("Unable to construct default code converter");
            nfe.printStackTrace();
        }
        catch (CannotCompileException cce) {
            log.severe("Unable to construct default code converter");
            cce.printStackTrace();
        }
        this.addExprEditor(new ClassRedirectEditor());
    }

    public void initClassRenames() {
        InputStream is = this.getClass().getResourceAsStream("/org/jboss/weaver/retro/class-renames.properties");
        this.loadClassRenames(is);
    }

    public boolean doWeave(ClassLoader cl, ClassFileInfo info) throws BadBytecode, CannotCompileException {
        CtClass clazz = info.getClazz();
        ClassFile file = clazz.getClassFile();
        log.fine("weaving: " + info.getClassName());
        if (file.getMajorVersion() <= 48) {
            return false;
        }
        file.setMajorVersion(48);
        file.renameClass(this.getClassRenames());
        ConstPool constPool = file.getConstPool();
        HashMap<String, String> mapClasses = new HashMap<String, String>();
        for (String name : constPool.getClassNames()) {
            if (name.indexOf(43) == -1) continue;
            mapClasses.put(name, name.replace('+', '$'));
        }
        if (mapClasses.size() != 0) {
            constPool.renameClass(mapClasses);
        }
        for (MethodInfo method : file.getMethods()) {
            WeaverRetroJdk14.rewriteLDC(constPool, method);
        }
        if (clazz.isAnnotation()) {
            this.rewriteSystemAnnotations(file);
        }
        for (CodeConverter converter : this.getCodeConverters()) {
            clazz.instrument(converter);
        }
        for (ExprEditor editor : this.getExprEditors()) {
            clazz.instrument(editor);
        }
        if (log.isLoggable(Level.FINEST)) {
            PrintWriter out = new PrintWriter(System.out, true);
            out.println("*** constant pool ***");
            file.getConstPool().print(out);
            out.println();
            out.println("*** members ***");
            ClassFileWriter.print((ClassFile)file, (PrintWriter)out);
        }
        return true;
    }

    public static void rewriteLDC(ConstPool constPool, MethodInfo method) throws BadBytecode {
        CodeAttribute code = method.getCodeAttribute();
        if (code == null) {
            return;
        }
        CodeIterator iterator = code.iterator();
        while (iterator.hasNext()) {
            int index0;
            int index = iterator.next();
            int op = iterator.byteAt(index);
            if (op != 18 && op != 19) continue;
            int constIndex = index0 = iterator.byteAt(index + 1);
            if (op == 19) {
                int index1 = iterator.byteAt(index + 2);
                constIndex = (index0 << 8) + index1;
            }
            if (7 != constPool.getTag(constIndex)) continue;
            String className = constPool.getClassInfo(constIndex);
            int theClassName = constPool.addStringInfo(className.replace('/', '.'));
            if (op == 19) {
                int b0 = theClassName >>> 8;
                int b1 = theClassName & 0xFF;
                iterator.writeByte(b0, index + 1);
                iterator.writeByte(b1, index + 2);
            } else {
                iterator.writeByte(theClassName, index + 1);
            }
            int classClass = constPool.addClassInfo("java/lang/Class");
            int descriptor = constPool.addMethodrefInfo(classClass, "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            iterator.insert(new byte[]{-72, (byte)(descriptor >>> 8), (byte)descriptor});
        }
    }

    private void rewriteSystemAnnotations(ClassFile file) {
        AnnotationsAttribute visible = (AnnotationsAttribute)file.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null) {
            Annotation[] annotations = visible.getAnnotations();
            boolean changed = false;
            for (int i = 0; i < annotations.length; ++i) {
                if (!annotations[i].getTypeName().equals(Inherited.class.getName())) continue;
                annotations[i] = new Annotation("org/jboss/lang/annotation/Inherited", file.getConstPool());
                changed = true;
            }
            if (changed) {
                visible.setAnnotations(annotations);
            }
        }
    }
}

