/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.plugins.context.jar.NestedJarFromStream;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoCopyNestedJarHandler
extends AbstractJarHandler {
    private static final long serialVersionUID = 1L;
    private NestedJarFromStream njar;

    public NoCopyNestedJarHandler(VFSContext context, VirtualFileHandler parent, JarFile parentJar, ZipEntry entry, URL url, String entryName) throws IOException {
        super(context, parent, url, parentJar, entry, entryName);
        try {
            this.setPathName(this.getChildPathName(entryName, false));
            this.setVfsUrl(this.getChildVfsUrl(entryName, false));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        try {
            InputStream is = parentJar.getInputStream(entry);
            ZipInputStream zis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
            this.njar = new NestedJarFromStream(context, parent, zis, url, parentJar, entry, entryName);
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
    }

    @Override
    protected void initCacheLastModified() {
    }

    @Override
    public long getLastModified() throws IOException {
        return this.getEntry().getTime();
    }

    @Override
    public long getSize() throws IOException {
        return this.getEntry().getSize();
    }

    @Override
    public boolean isNested() throws IOException {
        return true;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.getJar().getInputStream(this.getEntry());
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if ("".equals(path)) {
            return this;
        }
        return this.njar.getChild(path);
    }

    @Override
    public boolean removeChild(String name) throws IOException {
        return false;
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        return this.njar.getChildren(ignoreErrors);
    }

    @Override
    public boolean delete(int gracePeriod) {
        return false;
    }

    @Override
    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        this.njar.internalReplaceChild(original, replacement);
    }
}

