/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs.helpers;

import java.util.Collection;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixesExcludeFilter
implements VirtualFileFilter {
    private Collection<String> suffixes;

    public SuffixesExcludeFilter(Collection<String> suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffixes");
        }
        for (String suffix : suffixes) {
            if (suffix != null) continue;
            throw new IllegalArgumentException("Null suffix in " + suffixes);
        }
        this.suffixes = suffixes;
    }

    @Override
    public boolean accepts(VirtualFile file) {
        String name = file.getName();
        for (String suffix : this.suffixes) {
            if (!name.endsWith(suffix)) continue;
            return false;
        }
        return true;
    }
}

