/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.plugins.context.VfsArchiveBrowserFactory;
import org.jboss.virtual.plugins.vfs.helpers.WrappingVirtualFileHandlerVisitor;
import org.jboss.virtual.spi.ExceptionHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VFSContextFactory;
import org.jboss.virtual.spi.VFSContextFactoryLocator;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.registry.VFSRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFS {
    private static final Logger log = Logger.getLogger(VFS.class);
    private final VFSContext context;

    public VFS(VFSContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.context = context;
    }

    public static void init() {
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        if (pkgs == null || pkgs.trim().length() == 0) {
            pkgs = "org.jboss.virtual.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        } else if (!pkgs.contains("org.jboss.virtual.protocol")) {
            pkgs = pkgs + "|org.jboss.virtual.protocol";
            System.setProperty("java.protocol.handler.pkgs", pkgs);
        }
        VfsArchiveBrowserFactory factory = VfsArchiveBrowserFactory.INSTANCE;
        ArchiveBrowser.factoryFinder.put("vfsfile", factory);
        ArchiveBrowser.factoryFinder.put("vfszip", factory);
        ArchiveBrowser.factoryFinder.put("vfsjar", factory);
        ArchiveBrowser.factoryFinder.put("vfs", factory);
    }

    VFSContext getContext() {
        return this.context;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.context.setExceptionHandler(exceptionHandler);
    }

    static void cleanup(VirtualFile file) {
        VirtualFileHandler fileHandler = file.getHandler();
        VFSContext context = fileHandler.getVFSContext();
        try {
            context.cleanupTempInfo(fileHandler.getPathName());
        }
        catch (Exception e) {
            log.debug((Object)("Exception cleaning temp info, file=" + file), (Throwable)e);
        }
        try {
            VirtualFileHandler contextHandler = context.getRoot();
            if (fileHandler.equals(contextHandler)) {
                VFSRegistry registry = VFSRegistry.getInstance();
                registry.removeContext(context);
            }
        }
        catch (Exception e) {
            log.debug((Object)("Exception removing cached context, file=" + file), (Throwable)e);
        }
    }

    public static VFS getVFS(URI rootURI) throws IOException {
        VFSContextFactory factory = VFSContextFactoryLocator.getFactory(rootURI);
        if (factory == null) {
            throw new IOException("No context factory for " + rootURI);
        }
        VFSContext context = factory.getVFS(rootURI);
        VFSRegistry.getInstance().addContext(context);
        return context.getVFS();
    }

    public static VirtualFile createNewRoot(URI rootURI) throws IOException {
        VFS vfs = VFS.getVFS(rootURI);
        return vfs.getRoot();
    }

    public static VirtualFile getRoot(URI rootURI) throws IOException {
        VFSRegistry registry = VFSRegistry.getInstance();
        VirtualFile file = registry.getFile(rootURI);
        return file != null ? file : VFS.createNewRoot(rootURI);
    }

    public static VirtualFile getVirtualFile(URI rootURI, String name) throws IOException {
        VirtualFile root = VFS.getRoot(rootURI);
        return root.findChild(name);
    }

    public static VFS getVFS(URL rootURL) throws IOException {
        VFSContextFactory factory = VFSContextFactoryLocator.getFactory(rootURL);
        if (factory == null) {
            throw new IOException("No context factory for " + rootURL);
        }
        VFSContext context = factory.getVFS(rootURL);
        VFSRegistry.getInstance().addContext(context);
        return context.getVFS();
    }

    public static VirtualFile createNewRoot(URL rootURL) throws IOException {
        VFS vfs = VFS.getVFS(rootURL);
        return vfs.getRoot();
    }

    public static VirtualFile getRoot(URL rootURL) throws IOException {
        VFSRegistry registry = VFSRegistry.getInstance();
        VirtualFile file = registry.getFile(rootURL);
        return file != null ? file : VFS.createNewRoot(rootURL);
    }

    public static VirtualFile getVirtualFile(URL rootURL, String name) throws IOException {
        VirtualFile root = VFS.getRoot(rootURL);
        return root.findChild(name);
    }

    public VirtualFile getRoot() throws IOException {
        VirtualFileHandler handler = this.context.getRoot();
        return handler.getVirtualFile();
    }

    @Deprecated
    public VirtualFile findChild(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        VirtualFileHandler handler = this.context.getRoot();
        VirtualFileHandler result = this.context.getChild(handler, VFSUtils.fixName(path));
        if (result == null) {
            List<VirtualFileHandler> children = handler.getChildren(true);
            throw new IOException("Child not found " + path + " for " + handler + ", available children: " + children);
        }
        return result.getVirtualFile();
    }

    public VirtualFile getChild(String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        VirtualFileHandler handler = this.context.getRoot();
        VirtualFileHandler result = this.context.getChild(handler, VFSUtils.fixName(path));
        return result != null ? result.getVirtualFile() : null;
    }

    public List<VirtualFile> getChildren() throws IOException {
        return this.getRoot().getChildren(null);
    }

    public List<VirtualFile> getChildren(VirtualFileFilter filter) throws IOException {
        return this.getRoot().getChildren(filter);
    }

    public List<VirtualFile> getChildrenRecursively() throws IOException {
        return this.getRoot().getChildrenRecursively(null);
    }

    public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        return this.getRoot().getChildrenRecursively(filter);
    }

    public void visit(VirtualFileVisitor visitor) throws IOException {
        VirtualFileHandler handler = this.context.getRoot();
        if (!handler.isLeaf()) {
            WrappingVirtualFileHandlerVisitor wrapper = new WrappingVirtualFileHandlerVisitor(visitor);
            this.context.visit(handler, wrapper);
        }
    }

    protected void visit(VirtualFile file, VirtualFileVisitor visitor) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        VirtualFileHandler handler = file.getHandler();
        WrappingVirtualFileHandlerVisitor wrapper = new WrappingVirtualFileHandlerVisitor(visitor);
        VFSContext handlerContext = handler.getVFSContext();
        handlerContext.visit(handler, wrapper);
    }

    public String toString() {
        return this.context.toString();
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VFS)) {
            return false;
        }
        VFS other = (VFS)obj;
        return this.context.equals(other.context);
    }

    static {
        VFS.init();
    }
}

