/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.collection.ConcurrentNavigableMap;
import org.jboss.util.collection.ConcurrentSkipListMap;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.DefaultOptions;
import org.jboss.virtual.plugins.context.DelegatingHandler;
import org.jboss.virtual.spi.ExceptionHandler;
import org.jboss.virtual.spi.Options;
import org.jboss.virtual.spi.TempInfo;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;
import org.jboss.virtual.spi.VirtualFileHandlerVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVFSContext
implements VFSContext {
    protected final Logger log = Logger.getLogger(this.getClass());
    private final VFS vfs = new VFS(this);
    private final URI rootURI;
    private final Options options = this.createNewOptions();
    private volatile VirtualFileHandler rootPeer;
    private final ConcurrentNavigableMap<TempInfoKey, TempInfo> tempInfos = new ConcurrentSkipListMap();

    protected AbstractVFSContext(URI rootURI) {
        if (rootURI == null) {
            throw new IllegalArgumentException("Null rootURI");
        }
        this.rootURI = rootURI;
        String query = rootURI.getQuery();
        Map<String, String> map = VFSUtils.parseURLQuery(query);
        this.options.addOptions(map);
    }

    protected AbstractVFSContext(URL rootURL) throws URISyntaxException {
        this(rootURL.toURI());
    }

    protected Options createNewOptions() {
        return new DefaultOptions();
    }

    @Override
    public VFS getVFS() {
        return this.vfs;
    }

    @Override
    public URI getRootURI() {
        return this.rootURI;
    }

    public void setRootPeer(VirtualFileHandler handler) {
        this.rootPeer = handler;
    }

    @Override
    public VirtualFileHandler getRootPeer() {
        return this.rootPeer;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    protected void setOption(String name, Object option) {
        if (option == null) {
            this.options.removeOption(name);
        } else {
            this.options.addOption(name, option);
        }
    }

    protected Object getOption(String name) {
        return this.options.getOption(name);
    }

    protected <T> T getOption(Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        return this.getOption(expectedType.getName(), expectedType);
    }

    protected <T> T getOption(String name, Class<T> expectedType) {
        return this.options.getOption(name, expectedType);
    }

    protected VFSContext getPeerContext() {
        VirtualFileHandler peer = this.getRootPeer();
        return peer != null ? peer.getVFSContext() : null;
    }

    protected URL setOptionsToURL(URL url) throws MalformedURLException {
        Map<String, String> map = this.options.getOptions(String.class);
        if (map.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url.toString());
        sb.append("?");
        int i = 0;
        for (Map.Entry<String, String> ent : map.entrySet()) {
            if (i > 0) {
                sb.append("&");
            }
            sb.append(ent.getKey()).append("=").append(ent.getValue());
            ++i;
        }
        return new URL(sb.toString());
    }

    @Override
    public List<VirtualFileHandler> getChildren(VirtualFileHandler parent, boolean ignoreErrors) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        return parent.getChildren(ignoreErrors);
    }

    @Override
    public VirtualFileHandler getChild(VirtualFileHandler parent, String path) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        return parent.getChild(path);
    }

    public URL getChildURL(VirtualFileHandler parent, String name) throws IOException {
        VFSContext parentCtx;
        if (parent != null && (parentCtx = parent.getVFSContext()) != this) {
            if (parentCtx instanceof AbstractVFSContext) {
                return ((AbstractVFSContext)parentCtx).getChildURL(parent, name);
            }
            StringBuilder urlStr = new StringBuilder(512);
            try {
                urlStr.append(parent.toURI());
                if (urlStr.charAt(urlStr.length() - 1) != '/') {
                    urlStr.append("/");
                }
                urlStr.append(name);
                return new URL(urlStr.toString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Failed to create child URL: " + parent + " + " + name, e);
            }
        }
        StringBuilder urlStr = new StringBuilder(512);
        URI rootUri = this.getRootURI();
        urlStr.append(rootUri.getScheme()).append(":").append(rootUri.getPath());
        if (parent != null) {
            String pPathName;
            if (urlStr.charAt(urlStr.length() - 1) != '/') {
                urlStr.append("/");
            }
            if ((pPathName = parent.getPathName()).length() != 0) {
                urlStr.append(pPathName);
            }
            if (urlStr.charAt(urlStr.length() - 1) != '/') {
                urlStr.append("/");
            }
            urlStr.append(name);
        }
        return new URL(urlStr.toString());
    }

    @Override
    public void visit(VirtualFileHandler handler, VirtualFileHandlerVisitor visitor) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        VisitorAttributes attributes = visitor.getAttributes();
        boolean includeRoot = attributes.isIncludeRoot();
        boolean leavesOnly = attributes.isLeavesOnly();
        boolean ignoreErrors = attributes.isIgnoreErrors();
        boolean includeHidden = attributes.isIncludeHidden();
        VirtualFileFilter recurseFilter = attributes.getRecurseFilter();
        this.visit(handler, visitor, includeRoot, leavesOnly, ignoreErrors, includeHidden, recurseFilter);
    }

    protected void visit(VirtualFileHandler handler, VirtualFileHandlerVisitor visitor, boolean includeRoot, boolean leavesOnly, boolean ignoreErrors, boolean includeHidden, VirtualFileFilter recurseFilter) throws IOException {
        List<VirtualFileHandler> children;
        if (includeRoot) {
            visitor.visit(handler);
        }
        boolean trace = this.log.isTraceEnabled();
        try {
            children = this.getChildren(handler, ignoreErrors);
        }
        catch (IOException e) {
            if (!ignoreErrors) {
                throw e;
            }
            if (trace) {
                this.log.trace((Object)("Ignored: " + e));
            }
            return;
        }
        for (VirtualFileHandler child : children) {
            if (!includeHidden && child.isHidden()) {
                if (!trace) continue;
                this.log.trace((Object)("Ignoring hidden file: " + child));
                continue;
            }
            boolean isLeaf = child.isLeaf();
            if (!leavesOnly || isLeaf) {
                visitor.visit(child);
            } else if (trace) {
                this.log.trace((Object)("Skipping non-leaf file: " + child));
            }
            VirtualFile file = child.getVirtualFile();
            if (isLeaf || recurseFilter == null || !recurseFilter.accepts(file)) continue;
            try {
                if (handler instanceof DelegatingHandler) {
                    child.getVFSContext().visit(child, visitor);
                    continue;
                }
                this.visit(child, visitor, false, leavesOnly, ignoreErrors, includeHidden, recurseFilter);
            }
            catch (StackOverflowError e) {
                this.log.debug((Object)("Original: " + child), (Throwable)e);
                throw new IOException("Stack overflow, the file system is too complicated? " + child);
            }
        }
    }

    @Override
    public void addTempInfo(TempInfo tempInfo) {
        TempInfoKey tempInfoKey = new TempInfoKey(tempInfo);
        this.tempInfos.put((Object)tempInfoKey, (Object)tempInfo);
    }

    @Override
    public TempInfo getTempInfo(String path) {
        Iterator iter = this.tempInfos.tailMap((Object)new TempInfoKey(path)).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!((TempInfoKey)entry.getKey()).originalPath.equals(path)) {
                return null;
            }
            TempInfo value = (TempInfo)entry.getValue();
            if (value.isValid()) {
                return value;
            }
            iter.remove();
        }
        return null;
    }

    @Override
    public TempInfo getFurthestParentTemp(String path) {
        Map.Entry floor = this.tempInfos.floorEntry((Object)TempInfoKey.last(path));
        TempInfo result = null;
        while (floor != null && path.startsWith(((TempInfoKey)floor.getKey()).originalPath)) {
            TempInfo value = (TempInfo)floor.getValue();
            if (value.isValid()) {
                result = value;
            }
            floor = this.tempInfos.lowerEntry(floor.getKey());
        }
        return result;
    }

    @Override
    public void cleanupTempInfo(String path) {
        Map.Entry entry;
        boolean trace = this.log.isTraceEnabled();
        ArrayList<String> info = null;
        ConcurrentNavigableMap tailMap = this.tempInfos.tailMap((Object)new TempInfoKey(path));
        Iterator iter = tailMap.entrySet().iterator();
        while (iter.hasNext() && ((TempInfoKey)(entry = (Map.Entry)iter.next()).getKey()).originalPath.startsWith(path)) {
            TempInfo ti = (TempInfo)entry.getValue();
            if (trace) {
                if (info == null) {
                    info = new ArrayList<String>();
                }
                info.add(ti.toString());
            }
            try {
                ti.cleanup();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            iter.remove();
        }
        if (trace) {
            this.log.trace((Object)("Removing temp info for path: '" + path + "', temps: " + info));
        }
    }

    @Override
    public Iterable<TempInfo> getTempInfos() {
        return new ArrayList<TempInfo>(this.tempInfos.values());
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        return this.getOption(ExceptionHandler.class);
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.setOption(ExceptionHandler.class.getName(), exceptionHandler);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append('[');
        buffer.append(this.rootURI);
        buffer.append(']');
        return buffer.toString();
    }

    public int hashCode() {
        return this.rootURI.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof VFSContext)) {
            return false;
        }
        VFSContext other = (VFSContext)obj;
        return this.rootURI.equals(other.getRootURI());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TempInfoKey
    implements Comparable<TempInfoKey> {
        private static String LAST = "---@@@LAST@@@---";
        private final String originalPath;
        private final String tempPath;
        private int hashCode;

        static TempInfoKey last(String path) {
            return new TempInfoKey(path, LAST);
        }

        private TempInfoKey(TempInfo ti) {
            this(ti.getPath(), ti.getTempFile().getAbsolutePath());
        }

        private TempInfoKey(String path) {
            this(path, "");
        }

        private TempInfoKey(String path, String tempPath) {
            if (path == null) {
                throw new IllegalArgumentException("Path can not be null!");
            }
            if (path == null) {
                throw new IllegalArgumentException("Temp path can not be null!");
            }
            this.originalPath = path;
            this.tempPath = tempPath;
        }

        @Override
        public int compareTo(TempInfoKey o) {
            int result = this.originalPath.compareTo(o.originalPath);
            if (result == 0) {
                result = this.tempPath == LAST ? 1 : this.tempPath.compareTo(o.tempPath);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TempInfoKey)) {
                return false;
            }
            TempInfoKey other = (TempInfoKey)o;
            return this.originalPath.equals(other.originalPath) && this.tempPath.equals(other.tempPath);
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = this.originalPath.hashCode() ^ this.tempPath.hashCode();
            return this.hashCode;
        }
    }
}

